/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.expr.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.algebra.transform.TransformExprToBasicPattern;
import org.aksw.jena_sparql_api.algebra.transform.TransformPullFiltersIfCanMergeBGPs;
import org.aksw.jena_sparql_api.algebra.transform.TransformReplaceConstants;
import org.aksw.jena_sparql_api.algebra.utils.FixpointIteration;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.QueryUtils;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.ext.com.google.common.collect.Maps;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.optimize.TransformMergeBGPs;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.user.UserDefinedFunction;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.apache.jena.sparql.function.user.UserDefinedFunctionFactory;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.lang.sparql_11.ParseException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprTransformVirtualBnodeUris
extends ExprTransformCopy {
    public static final UserDefinedFunctionFactory f = UserDefinedFunctionFactory.getFactory();
    public static final String ns = "http://www.example.org/fn/";
    public static final String typeErrorFnUri = "http://www.example.org/fn/typeError";
    public static final String encodeBnodeFnUri = "http://www.example.org/fn/encodeBnodeFnUri";
    public static final String isBnodeUriFnUri = "http://www.example.org/fn/isBnodeUri";
    public static final String decodeBnodeUriFnUri = "http://www.example.org/fn/decodeBnodeUri";
    public String bnodeLabelFnUri;
    public String bnodeLabelFnSymbol;
    public transient String forceBnodeUriFnUri;
    private static final Logger logger = LoggerFactory.getLogger(ExprTransformVirtualBnodeUris.class);

    public ExprTransformVirtualBnodeUris(String vendorLabel, String bnodeLabelFnSymbol) {
        this.bnodeLabelFnSymbol = bnodeLabelFnSymbol;
        this.bnodeLabelFnUri = ns + vendorLabel + "bnode";
        this.forceBnodeUriFnUri = ns + vendorLabel + "/forceBnodeUri";
        try {
            this.registerFunctions();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerFunctions() throws ParseException {
        List<Var> x = Collections.singletonList(Vars.x);
        f.add(this.bnodeLabelFnUri, this.bnodeLabelFnSymbol + "(?x)", x);
        String bnodePrefix = "bnode://";
        f.add(typeErrorFnUri, "ABS('')", Collections.emptyList());
        f.add(encodeBnodeFnUri, "URI(CONCAT('bnode://', ?x))", x);
        f.add(isBnodeUriFnUri, "ISURI(?x) && STRSTARTS(STR(?x), '" + bnodePrefix + "')", x);
        f.add(decodeBnodeUriFnUri, "IF(<http://www.example.org/fn/isBnodeUri>(?x), STRAFTER(STR(?x), '" + bnodePrefix + "'), <" + typeErrorFnUri + "()>)", x);
        f.add(this.forceBnodeUriFnUri, "IF(isBlank(?x), <http://www.example.org/fn/encodeBnodeFnUri>(" + this.bnodeLabelFnSymbol + "(?x)), ?x)", x);
    }

    public Expr transform(ExprFunction2 func, Expr a, Expr b) {
        ExprFunction2 result = null;
        if (!a.isConstant() && b.isConstant()) {
            result = this.trySubst(func, a, b, false);
            a = result.getArg1();
            b = result.getArg2();
        }
        if (a.isConstant() && !b.isConstant()) {
            result = this.trySubst(func, b, a, true);
        }
        if (result == null) {
            result = (ExprFunction2)super.transform(func, a, b);
        }
        return result;
    }

    public static <T extends ExprFunction2> T copy(T func, Expr a, Expr b, boolean swapped) {
        ExprFunction2 result = swapped ? (ExprFunction2)func.copy(b, a) : (ExprFunction2)func.copy(a, b);
        return (T)result;
    }

    public static Expr subst(String udfUri, Expr ... args) {
        UserDefinedFunctionDefinition udfd = f.get(udfUri);
        UserDefinedFunction fi = (UserDefinedFunction)udfd.newFunctionInstance();
        ExprList el = new ExprList(Arrays.asList(args));
        fi.build(udfUri, el);
        Expr expr = fi.getActualExpr();
        return expr;
    }

    public static NodeValue eval(String udfUri, Expr ... args) {
        UserDefinedFunctionDefinition udfd = f.get(udfUri);
        Function fi = udfd.newFunctionInstance();
        ExprList el = new ExprList(Arrays.asList(args));
        fi.build(udfUri, el);
        Context context = ARQ.getContext().copy();
        context.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        ExecutionContext env = new ExecutionContext(context, null, null, null);
        NodeValue result = fi.exec(BindingFactory.binding(), el, udfUri, (FunctionEnv)env);
        return result;
    }

    public ExprFunction2 trySubst(ExprFunction2 func, Expr lhs, Expr b, boolean swapped) {
        ExprFunction2 result;
        NodeValue rhs = b.getConstant();
        boolean isRhsBnodeUri = ExprTransformVirtualBnodeUris.eval(isBnodeUriFnUri, new Expr[]{rhs}).getBoolean();
        if (isRhsBnodeUri) {
            NodeValue rhsLabel = ExprTransformVirtualBnodeUris.eval(decodeBnodeUriFnUri, new Expr[]{rhs});
            Expr x = f.get(this.bnodeLabelFnUri).getBaseExpr();
            Expr aaLabel = ExprTransformer.transform((ExprTransform)new ExprTransformSubstitute(Vars.x, lhs), (Expr)x);
            result = ExprTransformVirtualBnodeUris.copy(func, aaLabel, (Expr)rhsLabel, swapped);
        } else {
            result = ExprTransformVirtualBnodeUris.copy(func, lhs, b, swapped);
        }
        return result;
    }

    public Query rewrite(Query query) {
        Query result = QueryUtils.rewrite((Query)query, op -> {
            Op a = TransformReplaceConstants.transform(op, x -> x.isURI() ? ExprTransformVirtualBnodeUris.eval(isBnodeUriFnUri, new Expr[]{NodeValue.makeNode((Node)x)}).getBoolean() : false);
            Op b = Transformer.transform(null, (ExprTransform)this, (Op)a);
            Op c = this.forceBnodeUris(b);
            Op d = TransformExprToBasicPattern.transform(c, fn -> {
                String id = ExprUtils.getFunctionId((ExprFunction)fn.getFunction());
                if ("str".equals(id)) {
                    return Maps.immutableEntry((Object)"http://foo.bar/baz", (Object)false);
                }
                return null;
            });
            Op e = FixpointIteration.apply(c, x -> {
                x = TransformPullFiltersIfCanMergeBGPs.transform(x);
                x = Transformer.transform((Transform)new TransformMergeBGPs(), (Op)x);
                return x;
            });
            return e;
        });
        logger.debug("Rewrote query\n" + query + " to\n" + result);
        return result;
    }

    public static void main(String[] args) {
        Expr input = org.apache.jena.sparql.util.ExprUtils.parse((String)"?x = <bnode://foobar>");
        ExprTransformVirtualBnodeUris xform = new ExprTransformVirtualBnodeUris("virtuoso", "STR");
        Query query = QueryFactory.create((String)"CONSTRUCT { ?s ?p ?o } { ?s <bnode://foo> ?t . ?s ?p ?o . FILTER(?p = <bnode://bar>)}");
        Query actual = xform.rewrite(query);
        System.out.println(actual);
    }

    public Op forceBnodeUris(Op op) {
        ArrayList visibleVars = new ArrayList(OpVars.visibleVars((Op)op));
        HashSet forbiddenVars = new HashSet(OpVars.mentionedVars((Op)op));
        Map<Var, Var> map = visibleVars.stream().collect(Collectors.toMap(v -> v, v -> VarGeneratorBlacklist.create((String)v.getName(), (Collection)forbiddenVars).next()));
        Op tmp = NodeTransformLib.transform(n -> n.isVariable() ? (Node)map.getOrDefault(n, (Var)n) : n, (Op)op);
        VarExprList vel = new VarExprList();
        for (Var v2 : visibleVars) {
            vel.add(v2, ExprTransformVirtualBnodeUris.subst(this.forceBnodeUriFnUri, new Expr[]{new ExprVar(map.get(v2))}));
        }
        OpExtend result = OpExtend.create((Op)tmp, (VarExprList)vel);
        return result;
    }
}

