/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jena_sparql_api.utils.TripleUtils;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.walker.Walker;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprVar;

public class TransformExprToBasicPattern
extends TransformCopy {
    protected Generator<Var> varGen;
    protected Function<Expr, Map.Entry<String, Boolean>> testSubst;

    public static Op transform(Op op, Function<Expr, Map.Entry<String, Boolean>> testSubstitution) {
        HashSet mentionedVars = new HashSet(OpVars.mentionedVars((Op)op));
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create(mentionedVars);
        TransformExprToBasicPattern xform = new TransformExprToBasicPattern((Generator<Var>)varGen, testSubstitution);
        Op result = Transformer.transform((Transform)xform, (Op)op);
        return result;
    }

    public TransformExprToBasicPattern(Generator<Var> varGen, Function<Expr, Map.Entry<String, Boolean>> testSubst) {
        this.varGen = varGen;
        this.testSubst = testSubst;
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList els = opFilter.getExprs();
        HashMap<Expr, Var> substitutions = new HashMap<Expr, Var>();
        BasicPattern triples = new BasicPattern();
        ExprList newExprs = new ExprList();
        for (Expr expr : els) {
            ExprTransformFindLeafFunctions xform = new ExprTransformFindLeafFunctions(this.varGen, this.testSubst, substitutions, triples);
            Expr x = Walker.transform((Expr)expr, (ExprTransform)xform);
            newExprs.add(x);
        }
        Op result = newExprs.equals((Object)els) ? super.transform(opFilter, subOp) : OpFilter.filterBy((ExprList)newExprs, (Op)OpJoin.create((Op)subOp, (Op)new OpBGP(triples)));
        return result;
    }

    public static class ExprTransformFindLeafFunctions
    extends ExprTransformCopy {
        protected Generator<Var> varGen;
        protected Function<Expr, Map.Entry<String, Boolean>> testSubstitution;
        protected Map<Expr, Var> substitutions = new HashMap<Expr, Var>();
        protected BasicPattern triples = new BasicPattern();

        public ExprTransformFindLeafFunctions(Generator<Var> varGen, Function<Expr, Map.Entry<String, Boolean>> testSubstitution, Map<Expr, Var> substitutions, BasicPattern triples) {
            this.varGen = varGen;
            this.testSubstitution = testSubstitution;
            this.substitutions = substitutions;
            this.triples = triples;
        }

        public Expr transform(ExprFunction1 func, Expr arg) {
            Map.Entry<String, Boolean> substInfo;
            Var argNode = arg.isVariable() ? arg.asVar() : (arg.isConstant() ? arg.getConstant().asNode() : null);
            Expr result = null;
            if (argNode != null && (substInfo = this.testSubstitution.apply((Expr)func)) != null) {
                Var v = this.substitutions.computeIfAbsent((Expr)func, f -> (Var)this.varGen.next());
                Node p = NodeFactory.createURI((String)substInfo.getKey());
                boolean subjectAsOutput = substInfo.getValue();
                Triple t = TripleUtils.create((Node)argNode, (Node)p, (Node)v, (boolean)subjectAsOutput);
                this.triples.add(t);
                result = new ExprVar(v);
            }
            if (result == null) {
                result = super.transform(func, arg);
            }
            return result;
        }
    }
}

