/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.commons.collections.tagmap.TagMap;
import org.aksw.commons.collections.tagmap.TagMapSimple;
import org.aksw.commons.collections.tagmap.TagSet;
import org.aksw.commons.collections.tagmap.TagSetImpl;
import org.aksw.jena_sparql_api.algebra.expr.transform.ExprTransformNormalizeVarConstant;
import org.aksw.jena_sparql_api.utils.BindingUtils;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.optimize.TransformExpandOneOf;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprSystem;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.ExprUtils;

public class TransformFilterSimplify
extends TransformCopy {
    public static Op transform(Op op) {
        TransformFilterSimplify transform = new TransformFilterSimplify();
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public static Expr partialEvalCnf(Expr expr, Map<Var, Node> map) {
        Expr result;
        Set vars = expr.getVarsMentioned();
        Set<Var> boundVars = map.keySet();
        if (!(expr instanceof ExprSystem) && boundVars.containsAll(vars)) {
            Binding binding = BindingUtils.fromMap(map);
            result = ExprUtils.eval((Expr)expr, (Binding)binding);
        } else {
            result = expr;
        }
        return result;
    }

    public static Set<Set<Expr>> processClausesInPlace(Set<Set<Expr>> nf, Consumer<? super Set<Expr>> inPlaceTransform) {
        ArrayList<Set<Expr>> copy = new ArrayList<Set<Expr>>(nf);
        nf.clear();
        for (Set set : copy) {
            inPlaceTransform.accept(set);
            nf.add(set);
        }
        return nf;
    }

    public static Set<Set<Expr>> applyExprTransform(Set<Set<Expr>> nf, ExprTransform exprTransform) {
        TransformFilterSimplify.processClausesInPlace(nf, c -> TransformFilterSimplify.applyExprTransformC(exprTransform, c));
        return nf;
    }

    public static <T, D extends Collection<T>, C extends Collection<D>> C applyExprTransform2(C nested, Function<? super T, ? extends T> fn) {
        ArrayList copy = new ArrayList(nested);
        nested.clear();
        for (Collection clause : copy) {
            TransformFilterSimplify.mapItems(clause, fn);
            nested.add((Collection)clause);
        }
        return nested;
    }

    public static <C extends Collection<Expr>> C applyExprTransformC(ExprTransform transform, C clause) {
        return TransformFilterSimplify.mapItems(clause, e -> ExprTransformer.transform((ExprTransform)transform, (Expr)e));
    }

    public static <T, C extends Collection<T>> C mapItems(C collection, Function<? super T, ? extends T> fn) {
        ArrayList copy = new ArrayList(collection);
        collection.clear();
        for (Object item : copy) {
            T mapped = fn.apply(item);
            collection.add(mapped);
        }
        return collection;
    }

    public static Set<Expr> subsitutePositiveNegativeLiteralTrue(Set<Expr> clause) {
        return TransformFilterSimplify.subsitutePositiveNegativeLiteral(clause, (Expr)NodeValue.TRUE);
    }

    public static Set<Expr> subsitutePositiveNegativeLiteral(Set<Expr> clause, Expr value) {
        for (Expr expr : new ArrayList<Expr>(clause)) {
            E_LogicalNot neg;
            Expr pos;
            if (!(expr instanceof E_LogicalNot) || !clause.contains(pos = (neg = (E_LogicalNot)expr).getArg())) continue;
            clause.remove(neg);
            clause.remove(pos);
            clause.add(value);
        }
        return clause;
    }

    public static Set<Set<Expr>> tidyBooleanConstants(Set<Set<Expr>> cnf) {
        ArrayList<Set<Expr>> copy = new ArrayList<Set<Expr>>(cnf);
        cnf.clear();
        for (Set<Expr> clause : copy) {
            if (clause.contains(NodeValue.TRUE)) {
                clause.clear();
                clause.add((Expr)NodeValue.TRUE);
            } else if (clause.contains(NodeValue.FALSE) && clause.size() > 1) {
                clause.remove(NodeValue.FALSE);
            }
            cnf.add(clause);
        }
        if (cnf.contains(ClauseUtils.FALSE)) {
            cnf.clear();
            cnf.add(ClauseUtils.newFalse());
        }
        return cnf;
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        OpFilter tmp = OpFilter.tidy((OpFilter)opFilter);
        TransformExpandOneOf expander = new TransformExpandOneOf();
        Op op = expander.transform(tmp, tmp.getSubOp());
        tmp = (OpFilter)op;
        Set cnf = CnfUtils.toSetCnf((ExprList)tmp.getExprs());
        TransformFilterSimplify.tidyBooleanConstants(cnf);
        TransformFilterSimplify.applyExprTransform(cnf, (ExprTransform)new ExprTransformNormalizeVarConstant());
        TransformFilterSimplify.processClausesInPlace(cnf, TransformFilterSimplify::subsitutePositiveNegativeLiteralTrue);
        Map varMap = CnfUtils.getConstants((Iterable)cnf, (boolean)false);
        TransformFilterSimplify.applyExprTransform2(cnf, e -> TransformFilterSimplify.partialEvalCnf(e, varMap));
        TransformFilterSimplify.tidyBooleanConstants(cnf);
        for (Map.Entry e2 : varMap.entrySet()) {
            cnf.add(new LinkedHashSet<E_Equals>(Collections.singleton(new E_Equals((Expr)new ExprVar((Var)e2.getKey()), (Expr)NodeValue.makeNode((Node)((Node)e2.getValue()))))));
        }
        TransformFilterSimplify.removeSubsumedCnfClause(cnf);
        ExprList exprs = CnfUtils.toExprList((Iterable)cnf);
        Op result = OpFilter.filterBy((ExprList)exprs, (Op)tmp.getSubOp());
        return result;
    }

    public static Set<Set<Expr>> removeSubsumedCnfClause(Set<Set<Expr>> cnf) {
        TagSetImpl tagSet = new TagSetImpl((TagMap)new TagMapSimple(), x -> x);
        for (Set<Expr> clause : cnf) {
            tagSet.add(clause);
        }
        Iterator<Set<Expr>> it = cnf.iterator();
        while (it.hasNext()) {
            Set<Expr> clause;
            clause = it.next();
            TagSet found = tagSet.getSubItemsOf(clause, true);
            if (found.isEmpty()) continue;
            it.remove();
        }
        return cnf;
    }
}

