/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.transform;

import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.optimize.TransformPromoteTableEmpty;

public class TransformPromoteTableEmptyVarPreserving
extends TransformPromoteTableEmpty {
    public static Op transform(Op op) {
        TransformPromoteTableEmptyVarPreserving transform = new TransformPromoteTableEmptyVarPreserving();
        Op result = Transformer.transform((Transform)transform, (Op)op);
        return result;
    }

    public Op transform(OpJoin opJoin, Op left, Op right) {
        if (this.isTableEmpty(left) || this.isTableEmpty(right)) {
            return OpUtils.createEmptyTableUnionVars(left, right);
        }
        return super.transform(opJoin, left, right);
    }

    public Op transform(OpLeftJoin opLeftJoin, Op left, Op right) {
        if (this.isTableEmpty(left)) {
            return OpUtils.createEmptyTableUnionVars(left, right);
        }
        if (this.isTableEmpty(right)) {
            return OpUtils.createEmptyTableUnionVars(left, right);
        }
        return super.transform(opLeftJoin, left, right);
    }

    public Op transform(OpMinus opMinus, Op left, Op right) {
        if (this.isTableEmpty(left)) {
            return left;
        }
        if (this.isTableEmpty(right)) {
            return left;
        }
        return super.transform(opMinus, left, right);
    }

    public Op transform(OpUnion opUnion, Op left, Op right) {
        if (this.isTableEmpty(left)) {
            if (this.isTableEmpty(right)) {
                return OpUtils.createEmptyTableUnionVars(left, right);
            }
            return right;
        }
        if (this.isTableEmpty(right)) {
            return left;
        }
        return super.transform(opUnion, left, right);
    }

    public boolean isTableEmpty(Op op) {
        if (op instanceof OpTable) {
            return ((OpTable)op).getTable().isEmpty();
        }
        return false;
    }
}

