/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import java.util.ArrayList;
import org.aksw.jena_sparql_api.algebra.analysis.VarInfo;
import org.aksw.jena_sparql_api.algebra.utils.QuadFilterPatternCanonical;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.core.Var;

public class ConjunctiveQuery {
    protected VarInfo projection;
    protected QuadFilterPatternCanonical qfpc;

    public ConjunctiveQuery(VarInfo projection, QuadFilterPatternCanonical qfpc) {
        this.projection = projection;
        this.qfpc = qfpc;
    }

    public VarInfo getProjection() {
        return this.projection;
    }

    public QuadFilterPatternCanonical getPattern() {
        return this.qfpc;
    }

    public Op toOp() {
        Op result = this.qfpc.toOp();
        result = new OpProject(result, new ArrayList<Var>(this.projection.getProjectVars()));
        if (this.projection.getDistinctLevel() > 0) {
            result = new OpDistinct(result);
        }
        return result;
    }

    public String toString() {
        return "ConjunctiveQuery [projection=" + this.projection + ", qfpc=" + this.qfpc + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.projection == null ? 0 : this.projection.hashCode());
        result = 31 * result + (this.qfpc == null ? 0 : this.qfpc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConjunctiveQuery other = (ConjunctiveQuery)obj;
        if (this.projection == null ? other.projection != null : !this.projection.equals(other.projection)) {
            return false;
        }
        return !(this.qfpc == null ? other.qfpc != null : !this.qfpc.equals(other.qfpc));
    }
}

