/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import java.util.Set;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.aksw.jena_sparql_api.utils.DnfUtils;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;

public class ExprHolder {
    protected Expr expr;
    private Set<Set<Expr>> cnf;
    private Set<Set<Expr>> dnf;

    public ExprHolder(Expr expr, Set<Set<Expr>> cnf, Set<Set<Expr>> dnf) {
        this.expr = expr;
        this.cnf = cnf;
        this.dnf = dnf;
    }

    public Expr getExpr() {
        this.expr = this.expr == null ? (this.cnf != null ? CnfUtils.toExpr(this.cnf) : (this.dnf != null ? DnfUtils.toExpr(this.dnf) : null)) : this.expr;
        this.expr = this.expr == null ? NodeValue.TRUE : this.expr;
        return this.expr;
    }

    public Set<Set<Expr>> getCnf() {
        this.cnf = this.cnf == null ? CnfUtils.toSetCnf((Expr)this.getExpr()) : this.cnf;
        return this.cnf;
    }

    public Set<Set<Expr>> getDnf() {
        this.dnf = this.dnf == null ? DnfUtils.toSetDnf((Expr)this.getExpr()) : this.dnf;
        return this.dnf;
    }

    public static ExprHolder from(Expr expr) {
        return new ExprHolder(expr, null, null);
    }

    public static ExprHolder fromCnf(Set<Set<Expr>> cnf) {
        return new ExprHolder(null, cnf, null);
    }

    public static ExprHolder fromDnf(Set<Set<Expr>> dnf) {
        return new ExprHolder(null, null, dnf);
    }

    boolean isEmpty() {
        boolean result = this.getCnf().isEmpty();
        return result;
    }

    public String toString() {
        String result = "" + this.getExpr();
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getExpr() == null ? 0 : this.getExpr().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExprHolder other = (ExprHolder)obj;
        return !(this.getExpr() == null ? other.getExpr() != null : !this.getExpr().equals((Object)other.getExpr()));
    }
}

