/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixpointIteration {
    private static Logger logger = LoggerFactory.getLogger(FixpointIteration.class);

    public static <T> T apply(T op, Function<? super T, ? extends T> transform) {
        T current;
        while (!(current = op).equals(op = transform.apply(current))) {
        }
        return current;
    }

    public static <T> T fixpointIteration(int max, T init, Function<? super T, ? extends T> fn) {
        T tmp;
        int i;
        T result = init;
        for (i = 0; i < max && !Objects.equals(tmp = fn.apply(result), result); ++i) {
            result = tmp;
        }
        if (i >= max) {
            logger.warn("Fixpoint iteration reached iteration threshold");
        }
        return result;
    }
}

