/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.commons.collections.trees.TreeImpl;
import org.aksw.commons.collections.trees.TreeUtils;
import org.aksw.jena_sparql_api.algebra.analysis.VarUsage;
import org.aksw.jena_sparql_api.algebra.analysis.VarUsageAnalyzerVisitor;
import org.aksw.jena_sparql_api.algebra.utils.OpCopyable;
import org.aksw.jena_sparql_api.algebra.utils.OpTreeOps;
import org.aksw.jena_sparql_api.algebra.utils.ProjectedQuadFilterPattern;
import org.aksw.jena_sparql_api.algebra.utils.QuadFilterPattern;
import org.aksw.jena_sparql_api.algebra.utils.QuadFilterPatternCanonical;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.aksw.jena_sparql_api.utils.VarExprListUtils;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.VarGeneratorImpl2;
import org.apache.jena.ext.com.google.common.collect.Sets;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.table.TableData;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;

public class OpUtils {
    public static OpTable createEmptyTableUnionVars(Op ... subOps) {
        List vars = Arrays.asList(subOps).stream().flatMap(op -> OpVars.visibleVars((Op)op).stream()).distinct().collect(Collectors.toList());
        TableData table = new TableData(vars, Collections.emptyList());
        OpTable result = OpTable.create((Table)table);
        return result;
    }

    public static Set<Var> visibleNamedVars(Op op) {
        Set result = OpVars.visibleVars((Op)op).stream().filter(x -> x.isNamedVar()).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        return result;
    }

    public static List<Op> getUnionMembers(Op op) {
        List<Op> result;
        if (op instanceof OpUnion) {
            OpUnion o = (OpUnion)op;
            result = Arrays.asList(o.getLeft(), o.getRight());
        } else if (op instanceof OpDisjunction) {
            OpDisjunction o = (OpDisjunction)op;
            result = o.getElements();
        } else {
            result = Collections.singletonList(op);
        }
        return result;
    }

    public static Op extendWithVarMap(Op subOp, Map<Var, Var> oldToNew) {
        VarExprList vel = VarExprListUtils.createFromVarMap(oldToNew);
        OpExtend opExtend = OpExtend.create((Op)subOp, (VarExprList)vel);
        OpProject result = new OpProject((Op)opExtend, vel.getVars());
        return result;
    }

    public static Op wrapWithProjection(Op subOp, Map<Var, Var> oldToNew) {
        if (!oldToNew.isEmpty()) {
            HashSet<Var> tgtVars = new HashSet<Var>(oldToNew.values());
            Set<Var> mapVars = oldToNew.keySet();
            Set srcVars = OpVars.visibleVars((Op)subOp);
            srcVars.addAll(mapVars);
            Sets.SetView collisions = Sets.intersection(tgtVars, (Set)srcVars);
            Sets.SetView blacklist = Sets.union(tgtVars, (Set)srcVars);
            VarGeneratorBlacklist gen = VarGeneratorBlacklist.create((Collection)blacklist);
            LinkedHashMap<Var, Var> newOldToNew = new LinkedHashMap<Var, Var>();
            LinkedHashMap<Var, Var> conflictResolution = new LinkedHashMap<Var, Var>();
            for (Map.Entry<Var, Var> e : oldToNew.entrySet()) {
                Var t;
                Var w;
                boolean isConflict;
                Var v = e.getKey();
                boolean bl = isConflict = !v.equals((Object)(w = e.getValue())) && collisions.contains(w);
                if (isConflict) {
                    t = (Var)gen.next();
                    conflictResolution.put(v, t);
                } else {
                    t = v;
                    conflictResolution.put(v, v);
                }
                newOldToNew.put(t, w);
            }
            if (!newOldToNew.equals(oldToNew)) {
                subOp = OpUtils.extendWithVarMap(subOp, conflictResolution);
                oldToNew = newOldToNew;
            }
            subOp = OpUtils.extendWithVarMap(subOp, oldToNew);
        }
        return subOp;
    }

    public static Op applyExtendProject(Op result, Map<Var, Expr> map) {
        Set visibleVars = OpVars.visibleVars((Op)result);
        Map<Var, Var> identityMappings = map.entrySet().stream().filter(e -> ((Expr)e.getValue()).isVariable() && ((Var)e.getKey()).equals((Object)((Expr)e.getValue()).asVar())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Expr)e.getValue()).asVar()));
        Map<Var, Expr> extensions = map.entrySet().stream().filter(e -> !identityMappings.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!extensions.isEmpty()) {
            VarExprList vel = VarExprListUtils.createFromMap(extensions);
            result = OpExtend.extend((Op)result, (VarExprList)vel);
        }
        if (!visibleVars.equals(map.keySet())) {
            result = new OpProject(result, new ArrayList<Var>(map.keySet()));
        }
        return result;
    }

    public long size(Op op) {
        System.out.println("OpUtils::size: This is a hack; it does not return the exact number of nodes in an op expression");
        return OpUtils.linearizePrefix(op).count();
    }

    public static Stream<Op> linearizePrefix(Op op) {
        Stream result = ExprUtils.linearizePrefix((Object)op, Collections.singleton(null), OpUtils::getSubOps);
        return result;
    }

    public static Generator<Var> freshVars(Op op) {
        Collection blacklistVars = OpVars.mentionedVars((Op)op);
        VarGeneratorImpl2 gen = VarGeneratorImpl2.create((String)"v");
        VarGeneratorBlacklist result = new VarGeneratorBlacklist((Generator)gen, blacklistVars);
        return result;
    }

    public static Op substitute(Op op, boolean descendIntoSubst, Function<? super Op, ? extends Op> transformFn) {
        Op result = (Op)TreeUtils.substitute((Object)op, (boolean)descendIntoSubst, OpTreeOps.get(), transformFn);
        return result;
    }

    public static Op substitute(Op op, Op searchNode, Op newNode) {
        Op result = (Op)TreeUtils.substitute((Object)op, (boolean)false, OpTreeOps.get(), o -> o == searchNode ? newNode : null);
        return result;
    }

    public static String getClassLabel(Object o) {
        String result = o == null ? "(null)" : o.getClass().getSimpleName();
        return result;
    }

    public static boolean isEquivalent(Op a, Op b) {
        String clb;
        boolean result = true;
        String cla = OpUtils.getClassLabel(a);
        if (cla.equals(clb = OpUtils.getClassLabel(b))) {
            List<Op> sas = OpUtils.getSubOps(a);
            List<Op> sbs = OpUtils.getSubOps(b);
            int n = sas.size();
            if (n == sbs.size()) {
                for (int i = 0; i < n; ++i) {
                    Op sb;
                    Op sa = sas.get(i);
                    boolean subResult = OpUtils.isEquivalent(sa, sb = sbs.get(i));
                    if (subResult) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    public static Map<Op, Op> parentMap(Op rootOp) {
        Map result = TreeUtils.parentMap((Object)rootOp, OpUtils::getSubOps);
        return result;
    }

    public static Tree<Op> createTree(Op rootOp) {
        TreeImpl result = TreeImpl.create((Object)rootOp, OpUtils::getSubOps);
        return result;
    }

    public static Op copyOnChange(Op op, List<Op> subOps) {
        List<Op> origSubOps = OpUtils.getSubOps(op);
        Op result = origSubOps.equals(subOps) ? op : OpUtils.copy(op, subOps);
        return result;
    }

    public static Op copy(Op op, List<Op> subOps) {
        Op0 result;
        int l = subOps.size();
        if (op instanceof Op0) {
            Op0 o = (Op0)op;
            result = o.copy();
        } else if (op instanceof Op1) {
            Op1 o = (Op1)op;
            result = o.copy(subOps.get(0));
        } else if (op instanceof Op2) {
            Op2 o = (Op2)op;
            result = o.copy(subOps.get(0), subOps.get(1));
        } else if (op instanceof OpN) {
            OpN o = (OpN)op;
            result = o.copy(subOps);
        } else if (op instanceof OpCopyable) {
            OpCopyable o = (OpCopyable)op;
            result = o.copy(subOps);
        } else {
            throw new RuntimeException("Should not happen: Could not copy: " + op);
        }
        return result;
    }

    public static List<Op> getSubOps(Op op) {
        List<Object> result;
        if (op instanceof Op0) {
            result = Collections.emptyList();
        } else if (op instanceof Op1) {
            result = Collections.singletonList(((Op1)op).getSubOp());
        } else if (op instanceof Op2) {
            Op2 tmp = (Op2)op;
            result = Arrays.asList(tmp.getLeft(), tmp.getRight());
        } else if (op instanceof OpN) {
            result = ((OpN)op).getElements();
        } else if (op instanceof OpCopyable) {
            result = ((OpCopyable)op).getElements();
        } else if (op instanceof OpExt) {
            result = Collections.emptyList();
        } else {
            throw new RuntimeException("Should not happen: " + op);
        }
        return result;
    }

    public static boolean isPatternFree(Op op) {
        boolean result;
        boolean isPattern;
        boolean bl = isPattern = op instanceof OpQuadPattern || op instanceof OpQuadBlock || op instanceof OpTriple || op instanceof OpBGP;
        if (isPattern) {
            result = false;
        } else {
            List<Op> subOps = OpUtils.getSubOps(op);
            result = true;
            for (Op subOp : subOps) {
                boolean tmp = OpUtils.isPatternFree(subOp);
                if (tmp) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static Stream<Op> inOrderSearch(Op op, Predicate<Op> predicate) {
        Stream<Op> result = TreeUtils.inOrderSearch((Object)op, OpUtils::getSubOps, x -> x, (a, b) -> true).map(e -> (Op)e.getKey()).filter(predicate);
        return result;
    }

    public static boolean isServiceFree(Op op) {
        boolean result = OpUtils.inOrderSearch(op, o -> !(o instanceof OpService)).count() == 0L;
        return result;
    }

    public static VarUsage analyzeVarUsage(Tree<Op> tree, Op current, VarUsageAnalyzerVisitor visitor) {
        Op parent;
        while ((parent = (Op)tree.getParent((Object)current)) != null) {
            visitor.setCurrent(current);
            parent.visit((OpVisitor)visitor);
            current = parent;
        }
        VarUsage result = visitor.getResult();
        return result;
    }

    public static VarUsage analyzeVarUsage(Tree<Op> tree, Op current) {
        VarUsageAnalyzerVisitor visitor = new VarUsageAnalyzerVisitor(tree, current);
        VarUsage result = OpUtils.analyzeVarUsage(tree, current, visitor);
        return result;
    }

    public static VarUsage analyzeVarUsage(Tree<Op> tree, Op current, Set<Var> availableVars) {
        VarUsageAnalyzerVisitor visitor = new VarUsageAnalyzerVisitor(tree, current, availableVars);
        VarUsage result = OpUtils.analyzeVarUsage(tree, current, visitor);
        return result;
    }

    public static Op toOp(QuadFilterPattern qfp) {
        List<Quad> quads = qfp.getQuads();
        ExprList exprs = new ExprList(qfp.getExpr());
        Op result = OpUtils.toOp(quads, OpQuadPattern::new);
        result = OpFilter.filterBy((ExprList)exprs, (Op)result);
        return result;
    }

    public static Op toOp(QuadFilterPatternCanonical qfpc) {
        ExprList exprs = CnfUtils.toExprList(qfpc.getFilterCnf());
        Op result = OpUtils.toOp(qfpc.getQuads(), OpQuadPattern::new);
        result = OpFilter.filterBy((ExprList)exprs, (Op)result);
        return result;
    }

    public static Op project(Op op, Iterable<Var> vars) {
        ArrayList varList = Lists.newArrayList(vars);
        OpProject result = new OpProject(op, (List)varList);
        return result;
    }

    public static Op toOp(ProjectedQuadFilterPattern pqfp) {
        QuadFilterPattern qfp = pqfp.getQuadFilterPattern();
        Op op = OpUtils.toOp(qfp);
        Op result = OpUtils.project(op, pqfp.getProjectVars());
        return result;
    }

    public static Op toOpGraphTriples(Node graphNode, BasicPattern bgp) {
        OpBGP result = new OpBGP(bgp);
        result = Quad.defaultGraphNodeGenerated.equals((Object)graphNode) ? result : new OpGraph(graphNode, (Op)result);
        return result;
    }

    public static Op toOp(Map<Node, BasicPattern> map, BiFunction<Node, BasicPattern, Op> opFactory) {
        OpNull result;
        ArrayList<Op> opqs = new ArrayList<Op>();
        for (Map.Entry<Node, BasicPattern> entry : map.entrySet()) {
            Op oqp = opFactory.apply(entry.getKey(), entry.getValue());
            opqs.add(oqp);
        }
        if (opqs.isEmpty()) {
            result = OpNull.create();
        } else if (opqs.size() == 1) {
            result = (Op)opqs.iterator().next();
        } else {
            OpSequence op = OpSequence.create();
            for (Op item : opqs) {
                op.add(item);
            }
            result = op;
        }
        return result;
    }

    public static Op toOp(Iterable<Quad> quads, BiFunction<Node, BasicPattern, Op> opFactory) {
        Map index = QuadPatternUtils.indexBasicPattern(quads);
        Op result = OpUtils.toOp(index, opFactory);
        return result;
    }
}

