/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.jena_sparql_api.algebra.utils.QuadFilterPattern;
import org.aksw.jena_sparql_api.algebra.utils.QuadFilterPatternCanonical;
import org.aksw.jena_sparql_api.algebra.utils.VarOccurrence;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class PatternSummary {
    private QuadFilterPattern originalPattern;
    private QuadFilterPatternCanonical canonicalPattern;
    private IBiSetMultimap<Quad, Set<Set<Expr>>> quadToCnf;
    private IBiSetMultimap<Var, VarOccurrence> varOccurrences;

    public PatternSummary(QuadFilterPattern originalPattern, QuadFilterPatternCanonical canonicalPattern, IBiSetMultimap<Quad, Set<Set<Expr>>> quadToCnf, IBiSetMultimap<Var, VarOccurrence> varOccurrences) {
        this.originalPattern = originalPattern;
        this.canonicalPattern = canonicalPattern;
        this.quadToCnf = quadToCnf;
        this.varOccurrences = varOccurrences;
    }

    public QuadFilterPattern getOriginalPattern() {
        return this.originalPattern;
    }

    public QuadFilterPatternCanonical getCanonicalPattern() {
        return this.canonicalPattern;
    }

    public IBiSetMultimap<Quad, Set<Set<Expr>>> getQuadToCnf() {
        return this.quadToCnf;
    }

    public IBiSetMultimap<Var, VarOccurrence> getVarOccurrences() {
        return this.varOccurrences;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canonicalPattern == null ? 0 : this.canonicalPattern.hashCode());
        result = 31 * result + (this.originalPattern == null ? 0 : this.originalPattern.hashCode());
        result = 31 * result + (this.quadToCnf == null ? 0 : this.quadToCnf.hashCode());
        result = 31 * result + (this.varOccurrences == null ? 0 : this.varOccurrences.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternSummary other = (PatternSummary)obj;
        if (this.canonicalPattern == null ? other.canonicalPattern != null : !this.canonicalPattern.equals(other.canonicalPattern)) {
            return false;
        }
        if (this.originalPattern == null ? other.originalPattern != null : !this.originalPattern.equals(other.originalPattern)) {
            return false;
        }
        if (this.quadToCnf == null ? other.quadToCnf != null : !this.quadToCnf.equals(other.quadToCnf)) {
            return false;
        }
        return !(this.varOccurrences == null ? other.varOccurrences != null : !this.varOccurrences.equals(other.varOccurrences));
    }

    public String toString() {
        return "PatternSummary [originalPattern=" + this.originalPattern + ", canonicalPattern=" + this.canonicalPattern + ", quadToCnf=" + this.quadToCnf + ", varOccurrences=" + this.varOccurrences + "]";
    }
}

