/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.algebra.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.algebra.utils.ExprHolder;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jena_sparql_api.algebra.utils.QuadFilterPattern;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.aksw.jena_sparql_api.utils.DnfUtils;
import org.aksw.jena_sparql_api.utils.NfUtils;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeTransform;

public class QuadFilterPatternCanonical {
    protected Set<Quad> quads;
    protected ExprHolder exprHolder;

    public QuadFilterPatternCanonical(Set<Quad> quads, ExprHolder exprHolder) {
        this.quads = quads;
        this.exprHolder = exprHolder;
    }

    public boolean isEmpty() {
        boolean result = this.quads.isEmpty() && this.exprHolder.isEmpty();
        return result;
    }

    public QuadFilterPattern toQfp() {
        Expr expr = DnfUtils.toExpr(this.exprHolder.getCnf());
        QuadFilterPattern result = new QuadFilterPattern(new ArrayList<Quad>(this.quads), expr);
        return result;
    }

    public Op toOp() {
        ExprList exprs = CnfUtils.toExprList(this.exprHolder.getCnf());
        Op result = OpUtils.toOp(this.quads, OpQuadPattern::new);
        result = OpFilter.filterBy((ExprList)exprs, (Op)result);
        return result;
    }

    public Set<Quad> getQuads() {
        return this.quads;
    }

    public ExprHolder getExprHolder() {
        return this.exprHolder;
    }

    public Set<Set<Expr>> getFilterCnf() {
        return this.exprHolder.getCnf();
    }

    public Set<Set<Expr>> getFilterDnf() {
        return this.exprHolder.getDnf();
    }

    public Set<Var> getVarsMentioned() {
        Set result = QuadPatternUtils.getVarsMentioned(this.quads);
        Set extra = NfUtils.getVarsMentioned(this.exprHolder.getCnf());
        result.addAll(extra);
        return result;
    }

    public static QuadFilterPatternCanonical applyVarMapping(QuadFilterPatternCanonical qfpc, Map<Var, Var> varMap) {
        NodeTransformRenameMap nodeTransform = new NodeTransformRenameMap(varMap);
        QuadFilterPatternCanonical result = qfpc.applyNodeTransform((NodeTransform)nodeTransform);
        return result;
    }

    public QuadFilterPatternCanonical applyNodeTransform(NodeTransform nodeTransform) {
        Set newQuads = QuadUtils.applyNodeTransform(this.quads, (NodeTransform)nodeTransform);
        Set newExprs = ClauseUtils.applyNodeTransformSet(this.exprHolder.getCnf(), (NodeTransform)nodeTransform);
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(newQuads, ExprHolder.fromCnf(newExprs));
        return result;
    }

    public QuadFilterPatternCanonical diff(QuadFilterPatternCanonical other) {
        HashSet<Quad> newQuads = new HashSet<Quad>((Collection<Quad>)Sets.difference(this.quads, other.quads));
        HashSet<Set<Expr>> newCnf = new HashSet<Set<Expr>>((Collection<Set<Expr>>)Sets.difference(this.exprHolder.getCnf(), other.exprHolder.getCnf()));
        QuadFilterPatternCanonical result = new QuadFilterPatternCanonical(newQuads, ExprHolder.fromCnf(newCnf));
        return result;
    }

    public boolean isSubsumedBy(QuadFilterPatternCanonical other) {
        boolean containsAllQuads = other.getQuads().containsAll(this.quads);
        boolean result = containsAllQuads ? CnfUtils.isSubsumedBy(other.getFilterCnf(), this.getFilterCnf()) : false;
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exprHolder == null ? 0 : this.exprHolder.hashCode());
        result = 31 * result + (this.quads == null ? 0 : this.quads.hashCode());
        return result;
    }

    public String toString() {
        return "<quads=" + this.quads + ", filterDnf=" + this.exprHolder.getDnf() + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuadFilterPatternCanonical other = (QuadFilterPatternCanonical)obj;
        if (this.exprHolder == null ? other.exprHolder != null : !this.exprHolder.equals(other.exprHolder)) {
            return false;
        }
        return !(this.quads == null ? other.quads != null : !this.quads.equals(other.quads));
    }

    public static void addFilter(QuadFilterPatternCanonical qfpc, ExprList exprs) {
    }
}

