/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinished;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskFinishedEvent
implements HistoryEvent {
    private TaskFinished datum = null;
    private TaskID taskid;
    private TaskAttemptID successfulAttemptId;
    private long finishTime;
    private TaskType taskType;
    private String status;
    private Counters counters;

    public TaskFinishedEvent(TaskID id, TaskAttemptID attemptId, long finishTime, TaskType taskType, String status, Counters counters) {
        this.taskid = id;
        this.successfulAttemptId = attemptId;
        this.finishTime = finishTime;
        this.taskType = taskType;
        this.status = status;
        this.counters = counters;
    }

    TaskFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskFinished();
            this.datum.setTaskid((CharSequence)new Utf8(this.taskid.toString()));
            if (this.successfulAttemptId != null) {
                this.datum.setSuccessfulAttemptId((CharSequence)new Utf8(this.successfulAttemptId.toString()));
            }
            this.datum.setFinishTime(this.finishTime);
            this.datum.setCounters(EventWriter.toAvro(this.counters));
            this.datum.setTaskType((CharSequence)new Utf8(this.taskType.name()));
            this.datum.setStatus((CharSequence)new Utf8(this.status));
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object oDatum) {
        this.datum = (TaskFinished)((Object)oDatum);
        this.taskid = TaskID.forName(this.datum.getTaskid().toString());
        if (this.datum.getSuccessfulAttemptId() != null) {
            this.successfulAttemptId = TaskAttemptID.forName(this.datum.getSuccessfulAttemptId().toString());
        }
        this.finishTime = this.datum.getFinishTime();
        this.taskType = TaskType.valueOf(this.datum.getTaskType().toString());
        this.status = this.datum.getStatus().toString();
        this.counters = EventReader.fromAvro(this.datum.getCounters());
    }

    public TaskID getTaskId() {
        return this.taskid;
    }

    public TaskAttemptID getSuccessfulTaskAttemptId() {
        return this.successfulAttemptId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getTaskStatus() {
        return this.status.toString();
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_FINISHED;
    }
}

