/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.DFSCIOTest;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.junit.Ignore;

/*
 * Exception performing whole class analysis ignored.
 */
@Ignore
public class DFSCIOTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(DFSCIOTest.class);
    private static final int TEST_TYPE_READ = 0;
    private static final int TEST_TYPE_WRITE = 1;
    private static final int TEST_TYPE_CLEANUP = 2;
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final String BASE_FILE_NAME = "test_io_";
    private static final String DEFAULT_RES_FILE_NAME = "DFSCIOTest_results.log";
    private static Configuration fsConfig = new Configuration();
    private static final long MEGA = 0x100000L;
    private static String TEST_ROOT_DIR = System.getProperty("test.build.data", "/benchmarks/DFSCIOTest");
    private static Path CONTROL_DIR = new Path(TEST_ROOT_DIR, "io_control");
    private static Path WRITE_DIR = new Path(TEST_ROOT_DIR, "io_write");
    private static Path READ_DIR = new Path(TEST_ROOT_DIR, "io_read");
    private static Path DATA_DIR = new Path(TEST_ROOT_DIR, "io_data");
    private static Path HDFS_TEST_DIR = new Path("/tmp/DFSCIOTest");
    private static String HDFS_LIB_VERSION = System.getProperty("libhdfs.version", "1");
    private static String CHMOD = new String("chmod");
    private static Path HDFS_SHLIB = new Path(HDFS_TEST_DIR + "/libhdfs.so." + HDFS_LIB_VERSION);
    private static Path HDFS_READ = new Path(HDFS_TEST_DIR + "/hdfs_read");
    private static Path HDFS_WRITE = new Path(HDFS_TEST_DIR + "/hdfs_write");

    public void testIOs() throws Exception {
        DFSCIOTest.testIOs((int)10, (int)10);
    }

    public static void testIOs(int fileSize, int nrFiles) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)fsConfig);
        DFSCIOTest.createControlFile((FileSystem)fs, (int)fileSize, (int)nrFiles);
        DFSCIOTest.writeTest((FileSystem)fs);
        DFSCIOTest.readTest((FileSystem)fs);
    }

    private static void createControlFile(FileSystem fs, int fileSize, int nrFiles) throws IOException {
        LOG.info((Object)("creating control file: " + fileSize + " mega bytes, " + nrFiles + " files"));
        fs.delete(CONTROL_DIR, true);
        for (int i = 0; i < nrFiles; ++i) {
            String name = DFSCIOTest.getFileName((int)i);
            Path controlFile = new Path(CONTROL_DIR, "in_file_" + name);
            SequenceFile.Writer writer = null;
            try {
                writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)fsConfig, (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                writer.append((Writable)new Text(name), (Writable)new LongWritable((long)fileSize));
                continue;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                writer = null;
            }
        }
        LOG.info((Object)("created control files for: " + nrFiles + " files"));
    }

    private static String getFileName(int fIdx) {
        return "test_io_" + Integer.toString(fIdx);
    }

    private static void writeTest(FileSystem fs) throws IOException {
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        DFSCIOTest.runIOTest(WriteMapper.class, (Path)WRITE_DIR);
    }

    private static void runIOTest(Class<? extends Mapper> mapperClass, Path outputDir) throws IOException {
        JobConf job = new JobConf(fsConfig, DFSCIOTest.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    private static void readTest(FileSystem fs) throws IOException {
        fs.delete(READ_DIR, true);
        DFSCIOTest.runIOTest(ReadMapper.class, (Path)READ_DIR);
    }

    private static void sequentialTest(FileSystem fs, int testType, int fileSize, int nrFiles) throws Exception {
        ReadMapper ioer = null;
        if (testType == 0) {
            ioer = new ReadMapper();
        } else if (testType == 1) {
            ioer = new WriteMapper();
        } else {
            return;
        }
        for (int i = 0; i < nrFiles; ++i) {
            ioer.doIO(Reporter.NULL, "test_io_" + Integer.toString(i), 0x100000L * (long)fileSize);
        }
    }

    public static void main(String[] args) {
        int testType = 0;
        int bufferSize = 1000000;
        int fileSize = 1;
        int nrFiles = 1;
        String resFileName = "DFSCIOTest_results.log";
        boolean isSequential = false;
        String version = "DFSCIOTest.0.0.1";
        String usage = "Usage: DFSCIOTest -read | -write | -clean [-nrFiles N] [-fileSize MB] [-resFile resultFileName] [-bufferSize Bytes] ";
        System.out.println(version);
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-r")) {
                testType = 0;
                continue;
            }
            if (args[i].startsWith("-w")) {
                testType = 1;
                continue;
            }
            if (args[i].startsWith("-clean")) {
                testType = 2;
                continue;
            }
            if (args[i].startsWith("-seq")) {
                isSequential = true;
                continue;
            }
            if (args[i].equals("-nrFiles")) {
                nrFiles = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-fileSize")) {
                fileSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-bufferSize")) {
                bufferSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (!args[i].equals("-resFile")) continue;
            resFileName = args[++i];
        }
        LOG.info((Object)("nrFiles = " + nrFiles));
        LOG.info((Object)("fileSize (MB) = " + fileSize));
        LOG.info((Object)("bufferSize = " + bufferSize));
        try {
            fsConfig.setInt("test.io.file.buffer.size", bufferSize);
            FileSystem fs = FileSystem.get((Configuration)fsConfig);
            if (testType != 2) {
                fs.delete(HDFS_TEST_DIR, true);
                if (!fs.mkdirs(HDFS_TEST_DIR)) {
                    throw new IOException("Mkdirs failed to create " + HDFS_TEST_DIR.toString());
                }
                String hadoopHome = System.getenv("HADOOP_PREFIX");
                fs.copyFromLocalFile(new Path(hadoopHome + "/libhdfs/libhdfs.so." + HDFS_LIB_VERSION), HDFS_SHLIB);
                fs.copyFromLocalFile(new Path(hadoopHome + "/libhdfs/hdfs_read"), HDFS_READ);
                fs.copyFromLocalFile(new Path(hadoopHome + "/libhdfs/hdfs_write"), HDFS_WRITE);
            }
            if (isSequential) {
                long tStart = System.currentTimeMillis();
                DFSCIOTest.sequentialTest((FileSystem)fs, (int)testType, (int)fileSize, (int)nrFiles);
                long execTime = System.currentTimeMillis() - tStart;
                String resultLine = "Seq Test exec time sec: " + (float)execTime / 1000.0f;
                LOG.info((Object)resultLine);
                return;
            }
            if (testType == 2) {
                DFSCIOTest.cleanup((FileSystem)fs);
                return;
            }
            DFSCIOTest.createControlFile((FileSystem)fs, (int)fileSize, (int)nrFiles);
            long tStart = System.currentTimeMillis();
            if (testType == 1) {
                DFSCIOTest.writeTest((FileSystem)fs);
            }
            if (testType == 0) {
                DFSCIOTest.readTest((FileSystem)fs);
            }
            long execTime = System.currentTimeMillis() - tStart;
            DFSCIOTest.analyzeResult((FileSystem)fs, (int)testType, (long)execTime, (String)resFileName);
        }
        catch (Exception e) {
            System.err.print(e.getLocalizedMessage());
            System.exit(-1);
        }
    }

    private static void analyzeResult(FileSystem fs, int testType, long execTime, String resFileName) throws IOException {
        String line;
        Path reduceFile = testType == 1 ? new Path(WRITE_DIR, "part-00000") : new Path(READ_DIR, "part-00000");
        DataInputStream in = new DataInputStream((InputStream)fs.open(reduceFile));
        BufferedReader lines = new BufferedReader(new InputStreamReader(in));
        long tasks = 0L;
        long size = 0L;
        long time = 0L;
        float rate = 0.0f;
        float sqrate = 0.0f;
        while ((line = lines.readLine()) != null) {
            StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
            String attr = tokens.nextToken();
            if (attr.endsWith(":tasks")) {
                tasks = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":size")) {
                size = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":time")) {
                time = Long.parseLong(tokens.nextToken());
                continue;
            }
            if (attr.endsWith(":rate")) {
                rate = Float.parseFloat(tokens.nextToken());
                continue;
            }
            if (!attr.endsWith(":sqrate")) continue;
            sqrate = Float.parseFloat(tokens.nextToken());
        }
        double med = rate / 1000.0f / (float)tasks;
        double stdDev = Math.sqrt(Math.abs((double)(sqrate / 1000.0f / (float)tasks) - med * med));
        String[] resultLines = new String[]{"----- DFSCIOTest ----- : " + (testType == 1 ? "write" : (testType == 0 ? "read" : "unknown")), "           Date & time: " + new Date(System.currentTimeMillis()), "       Number of files: " + tasks, "Total MBytes processed: " + size / 0x100000L, "     Throughput mb/sec: " + (double)size * 1000.0 / (double)(time * 0x100000L), "Average IO rate mb/sec: " + med, " Std IO rate deviation: " + stdDev, "    Test exec time sec: " + (float)execTime / 1000.0f, ""};
        PrintStream res = new PrintStream(new FileOutputStream(new File(resFileName), true));
        for (int i = 0; i < resultLines.length; ++i) {
            LOG.info((Object)resultLines[i]);
            res.println(resultLines[i]);
        }
    }

    private static void cleanup(FileSystem fs) throws Exception {
        LOG.info((Object)"Cleaning up test files");
        fs.delete(new Path(TEST_ROOT_DIR), true);
        fs.delete(HDFS_TEST_DIR, true);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ Configuration access$100() {
        return fsConfig;
    }

    static /* synthetic */ Path access$200() {
        return HDFS_TEST_DIR;
    }

    static /* synthetic */ Path access$300() {
        return HDFS_SHLIB;
    }

    static /* synthetic */ String access$400() {
        return CHMOD;
    }

    static /* synthetic */ Path access$500() {
        return HDFS_WRITE;
    }

    static /* synthetic */ Path access$600() {
        return DATA_DIR;
    }

    static /* synthetic */ Path access$700() {
        return HDFS_READ;
    }
}

