/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestFileSystem;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.security.UserGroupInformation;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestFileSystem
extends TestCase {
    private static final Log LOG = FileSystem.LOG;
    private static Configuration conf = new Configuration();
    private static int BUFFER_SIZE = conf.getInt("io.file.buffer.size", 4096);
    private static final long MEGA = 0x100000L;
    private static final int SEEKS_PER_FILE = 4;
    private static String ROOT = System.getProperty("test.build.data", "fs_test");
    private static Path CONTROL_DIR = new Path(ROOT, "fs_control");
    private static Path WRITE_DIR = new Path(ROOT, "fs_write");
    private static Path READ_DIR = new Path(ROOT, "fs_read");
    private static Path DATA_DIR = new Path(ROOT, "fs_data");

    public void testFs() throws Exception {
        TestFileSystem.testFs((long)0xA00000L, (int)100, (long)0L);
    }

    public static void testFs(long megaBytes, int numFiles, long seed) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (seed == 0L) {
            seed = new Random().nextLong();
        }
        LOG.info((Object)("seed = " + seed));
        TestFileSystem.createControlFile((FileSystem)fs, (long)megaBytes, (int)numFiles, (long)seed);
        TestFileSystem.writeTest((FileSystem)fs, (boolean)false);
        TestFileSystem.readTest((FileSystem)fs, (boolean)false);
        TestFileSystem.seekTest((FileSystem)fs, (boolean)false);
        fs.delete(CONTROL_DIR, true);
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        fs.delete(READ_DIR, true);
    }

    public static void testCommandFormat() throws Exception {
        CommandFormat cf = new CommandFormat("copyToLocal", 2, 2, new String[]{"crc", "ignoreCrc"});
        TestFileSystem.assertEquals((String)((String)cf.parse(new String[]{"-get", "file", "-"}, 1).get(1)), (String)"-");
        try {
            cf.parse(new String[]{"-get", "file", "-ignoreCrc", "/foo"}, 1);
            TestFileSystem.fail((String)"Expected parsing to fail as it should stop at first non-option");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cf = new CommandFormat("tail", 1, 1, new String[]{"f"});
        TestFileSystem.assertEquals((String)((String)cf.parse(new String[]{"-tail", "fileName"}, 1).get(0)), (String)"fileName");
        TestFileSystem.assertEquals((String)((String)cf.parse(new String[]{"-tail", "-f", "fileName"}, 1).get(0)), (String)"fileName");
        cf = new CommandFormat("setrep", 2, 2, new String[]{"R", "w"});
        TestFileSystem.assertEquals((String)((String)cf.parse(new String[]{"-setrep", "-R", "2", "/foo/bar"}, 1).get(1)), (String)"/foo/bar");
        cf = new CommandFormat("put", 2, 10000, new String[0]);
        TestFileSystem.assertEquals((String)((String)cf.parse(new String[]{"-put", "-", "dest"}, 1).get(1)), (String)"dest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createControlFile(FileSystem fs, long megaBytes, int numFiles, long seed) throws Exception {
        long totalSize;
        LOG.info((Object)("creating control file: " + megaBytes + " bytes, " + numFiles + " files"));
        Path controlFile = new Path(CONTROL_DIR, "files");
        fs.delete(controlFile, true);
        Random random = new Random(seed);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        long maxSize = megaBytes / (long)numFiles * 2L + 1L;
        try {
            long size;
            for (totalSize = 0L; totalSize < megaBytes; totalSize += size) {
                Text name = new Text(Long.toString(random.nextLong()));
                size = random.nextLong();
                if (size < 0L) {
                    size = -size;
                }
                writer.append((Writable)name, (Writable)new LongWritable(size %= maxSize));
            }
        }
        finally {
            writer.close();
        }
        LOG.info((Object)("created control file for: " + totalSize + " bytes"));
    }

    public static void writeTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(WriteMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)WRITE_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    public static void readTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(READ_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(ReadMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)READ_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    public static void seekTest(FileSystem fs, boolean fastCheck) throws Exception {
        fs.delete(READ_DIR, true);
        JobConf job = new JobConf(conf, TestFileSystem.class);
        job.setBoolean("fs.test.fastCheck", fastCheck);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(SeekMapper.class);
        job.setReducerClass(LongSumReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)READ_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    public static void main(String[] args) throws Exception {
        int megaBytes = 10;
        int files = 100;
        boolean noRead = false;
        boolean noWrite = false;
        boolean noSeek = false;
        boolean fastCheck = false;
        long seed = new Random().nextLong();
        String usage = "Usage: TestFileSystem -files N -megaBytes M [-noread] [-nowrite] [-noseek] [-fastcheck]";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-files")) {
                files = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-megaBytes")) {
                megaBytes = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-noread")) {
                noRead = true;
                continue;
            }
            if (args[i].equals("-nowrite")) {
                noWrite = true;
                continue;
            }
            if (args[i].equals("-noseek")) {
                noSeek = true;
                continue;
            }
            if (!args[i].equals("-fastcheck")) continue;
            fastCheck = true;
        }
        LOG.info((Object)("seed = " + seed));
        LOG.info((Object)("files = " + files));
        LOG.info((Object)("megaBytes = " + megaBytes));
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!noWrite) {
            TestFileSystem.createControlFile((FileSystem)fs, (long)((long)megaBytes * 0x100000L), (int)files, (long)seed);
            TestFileSystem.writeTest((FileSystem)fs, (boolean)fastCheck);
        }
        if (!noRead) {
            TestFileSystem.readTest((FileSystem)fs, (boolean)fastCheck);
        }
        if (!noSeek) {
            TestFileSystem.seekTest((FileSystem)fs, (boolean)fastCheck);
        }
    }

    public void testFsCache() throws Exception {
        long now = System.currentTimeMillis();
        String[] users = new String[]{"foo", "bar"};
        Configuration conf = new Configuration();
        FileSystem[] fs = new FileSystem[users.length];
        for (int i = 0; i < users.length; ++i) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)users[i]);
            fs[i] = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            for (int j = 0; j < i; ++j) {
                TestFileSystem.assertFalse((fs[j] == fs[i] ? 1 : 0) != 0);
            }
        }
        FileSystem.closeAll();
        try {
            TestFileSystem.runTestCache((int)8020);
        }
        catch (BindException be) {
            LOG.warn((Object)"Cannot test NameNode.DEFAULT_PORT (=8020)", (Throwable)be);
        }
        TestFileSystem.runTestCache((int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runTestCache(int port) throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).nameNodePort(port).numDataNodes(2).build();
            URI uri = cluster.getFileSystem().getUri();
            LOG.info((Object)("uri=" + uri));
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)new Configuration());
            TestFileSystem.checkPath((MiniDFSCluster)cluster, (FileSystem)fs);
            for (int i = 0; i < 100; ++i) {
                TestFileSystem.assertTrue((fs == FileSystem.get((URI)uri, (Configuration)new Configuration()) ? 1 : 0) != 0);
            }
            if (port == 8020) {
                URI uri2 = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 8020, uri.getPath(), uri.getQuery(), uri.getFragment());
                LOG.info((Object)("uri2=" + uri2));
                FileSystem fs2 = FileSystem.get((URI)uri2, (Configuration)conf);
                TestFileSystem.checkPath((MiniDFSCluster)cluster, (FileSystem)fs2);
                for (int i = 0; i < 100; ++i) {
                    TestFileSystem.assertTrue((fs2 == FileSystem.get((URI)uri2, (Configuration)new Configuration()) ? 1 : 0) != 0);
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void checkPath(MiniDFSCluster cluster, FileSystem fileSys) throws IOException {
        InetSocketAddress add = cluster.getNameNode().getNameNodeAddress();
        fileSys.checkPath(new Path("hdfs://" + add.getHostName().toUpperCase() + ":" + add.getPort()));
    }

    public void testFsClose() throws Exception {
        Configuration conf = new Configuration();
        new Path("file:///").getFileSystem(conf);
        FileSystem.closeAll();
        conf = new Configuration();
        new Path("hftp://localhost:12345/").getFileSystem(conf);
        FileSystem.closeAll();
        conf = new Configuration();
        FileSystem fs = new Path("hftp://localhost:12345/").getFileSystem(conf);
        FileSystem.closeAll();
    }

    public void testFsShutdownHook() throws Exception {
        Set closed = Collections.synchronizedSet(new HashSet());
        Configuration conf = new Configuration();
        Configuration confNoAuto = new Configuration();
        conf.setClass("fs.test.impl", TestShutdownFileSystem.class, FileSystem.class);
        confNoAuto.setClass("fs.test.impl", TestShutdownFileSystem.class, FileSystem.class);
        confNoAuto.setBoolean("fs.automatic.close", false);
        TestShutdownFileSystem fsWithAuto = (TestShutdownFileSystem)new Path("test://a/").getFileSystem(conf);
        TestShutdownFileSystem fsWithoutAuto = (TestShutdownFileSystem)new Path("test://b/").getFileSystem(confNoAuto);
        fsWithAuto.setClosedSet(closed);
        fsWithoutAuto.setClosedSet(closed);
        TestFileSystem.assertNotSame((Object)fsWithAuto, (Object)fsWithoutAuto);
        FileSystem.CACHE.closeAll(true);
        TestFileSystem.assertEquals((int)1, (int)closed.size());
        TestFileSystem.assertTrue((boolean)closed.contains(fsWithAuto));
        closed.clear();
        FileSystem.closeAll();
        TestFileSystem.assertEquals((int)1, (int)closed.size());
        TestFileSystem.assertTrue((boolean)closed.contains(fsWithoutAuto));
    }

    public void testCacheKeysAreCaseInsensitive() throws Exception {
        Configuration conf = new Configuration();
        FileSystem.Cache.Key lowercaseCachekey1 = new FileSystem.Cache.Key(new URI("hftp://localhost:12345/"), conf);
        FileSystem.Cache.Key lowercaseCachekey2 = new FileSystem.Cache.Key(new URI("hftp://localhost:12345/"), conf);
        TestFileSystem.assertEquals((Object)lowercaseCachekey1, (Object)lowercaseCachekey2);
        FileSystem.Cache.Key uppercaseCachekey = new FileSystem.Cache.Key(new URI("HFTP://Localhost:12345/"), conf);
        TestFileSystem.assertEquals((Object)lowercaseCachekey2, (Object)uppercaseCachekey);
        ArrayList<FileSystem.Cache.Key> list = new ArrayList<FileSystem.Cache.Key>();
        list.add(uppercaseCachekey);
        TestFileSystem.assertTrue((boolean)list.contains(uppercaseCachekey));
        TestFileSystem.assertTrue((boolean)list.contains(lowercaseCachekey2));
        HashSet<FileSystem.Cache.Key> set = new HashSet<FileSystem.Cache.Key>();
        set.add(uppercaseCachekey);
        TestFileSystem.assertTrue((boolean)set.contains(uppercaseCachekey));
        TestFileSystem.assertTrue((boolean)set.contains(lowercaseCachekey2));
        HashMap<FileSystem.Cache.Key, String> map = new HashMap<FileSystem.Cache.Key, String>();
        map.put(uppercaseCachekey, "");
        TestFileSystem.assertTrue((boolean)map.containsKey(uppercaseCachekey));
        TestFileSystem.assertTrue((boolean)map.containsKey(lowercaseCachekey2));
    }

    public static void testFsUniqueness(long megaBytes, int numFiles, long seed) throws Exception {
        FileSystem fs2;
        FileSystem fs1 = FileSystem.get((Configuration)conf);
        TestFileSystem.assertTrue((fs1 == (fs2 = FileSystem.get((Configuration)conf)) ? 1 : 0) != 0);
        fs1 = FileSystem.newInstance((Configuration)conf);
        fs2 = FileSystem.newInstance((Configuration)conf);
        TestFileSystem.assertTrue((fs1 != fs2 && !fs1.equals(fs2) ? 1 : 0) != 0);
        fs1.close();
        fs2.close();
    }

    static /* synthetic */ int access$000() {
        return BUFFER_SIZE;
    }

    static /* synthetic */ Configuration access$100() {
        return conf;
    }

    static /* synthetic */ Path access$200() {
        return DATA_DIR;
    }
}

