/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.DataWriter;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;

class CreateOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(CreateOp.class);
    private static int DEF_IO_BUFFER_SIZE = 4096;
    private static final String IO_BUF_CONFIG = "io.file.buffer.size";

    CreateOp(ConfigExtractor cfg, Random rnd) {
        super(CreateOp.class.getSimpleName(), cfg, rnd);
    }

    private long determineBlockSize() {
        Range blockSizeRange = this.getConfig().getBlockSize();
        long blockSize = Range.betweenPositive((Random)this.getRandom(), (Range)blockSizeRange);
        Long byteChecksum = this.getConfig().getByteCheckSum();
        if (byteChecksum == null) {
            return blockSize;
        }
        long full = blockSize / byteChecksum * byteChecksum;
        long toFull = blockSize - full;
        if (toFull >= byteChecksum / 2L) {
            full += byteChecksum.longValue();
        }
        if (full > (Long)blockSizeRange.getUpper()) {
            full = (Long)blockSizeRange.getUpper();
        }
        if (full < (Long)blockSizeRange.getLower()) {
            full = (Long)blockSizeRange.getLower();
        }
        return full;
    }

    private short determineReplication() {
        Range replicationAmountRange = this.getConfig().getReplication();
        Range repRange = new Range((Number)((Short)replicationAmountRange.getLower()).longValue(), (Number)((Short)replicationAmountRange.getUpper()).longValue());
        short replicationAmount = (short)Range.betweenPositive((Random)this.getRandom(), (Range)repRange);
        return replicationAmount;
    }

    private int getBufferSize() {
        return this.getConfig().getConfig().getInt(IO_BUF_CONFIG, DEF_IO_BUFFER_SIZE);
    }

    protected Path getCreateFile() {
        Path fn = this.getFinder().getFile();
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<OperationOutput> run(FileSystem fs) {
        List out = super.run(fs);
        FSDataOutputStream os = null;
        try {
            Path fn = this.getCreateFile();
            Range writeSizeRange = this.getConfig().getWriteSize();
            long writeSize = 0L;
            long blockSize = this.determineBlockSize();
            short replicationAmount = this.determineReplication();
            if (this.getConfig().shouldWriteUseBlockSize()) {
                writeSizeRange = this.getConfig().getBlockSize();
            }
            writeSize = Range.betweenPositive((Random)this.getRandom(), (Range)writeSizeRange);
            long bytesWritten = 0L;
            long timeTaken = 0L;
            int bufSize = this.getBufferSize();
            boolean overWrite = false;
            DataWriter writer = new DataWriter(this.getRandom());
            LOG.info((Object)("Attempting to create file at " + fn + " of size " + Helper.toByteInfo((long)writeSize) + " using blocksize " + Helper.toByteInfo((long)blockSize) + " and replication amount " + replicationAmount));
            long startTime = Timer.now();
            os = fs.create(fn, overWrite, bufSize, replicationAmount, blockSize);
            timeTaken += Timer.elapsed((long)startTime);
            DataWriter.GenerateOutput stats = writer.writeSegment(writeSize, (OutputStream)os);
            timeTaken += stats.getTimeTaken();
            startTime = Timer.now();
            os.close();
            os = null;
            LOG.info((Object)("Created file at " + fn + " of size " + Helper.toByteInfo((long)(bytesWritten += stats.getBytesWritten())) + " bytes using blocksize " + Helper.toByteInfo((long)blockSize) + " and replication amount " + replicationAmount + " in " + (timeTaken += Timer.elapsed((long)startTime)) + " milliseconds"));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", (Object)timeTaken));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "bytes_written", (Object)bytesWritten));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", (Object)1L));
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", (Object)1L));
            LOG.warn((Object)"Error with creating", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Error closing create stream", (Throwable)e);
                }
            }
        }
        return out;
    }
}

