/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.fs.slive.AppendOp;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.fs.slive.CreateOp;
import org.apache.hadoop.fs.slive.DeleteOp;
import org.apache.hadoop.fs.slive.ListOp;
import org.apache.hadoop.fs.slive.MkdirOp;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationFactory;
import org.apache.hadoop.fs.slive.ReadOp;
import org.apache.hadoop.fs.slive.RenameOp;

class OperationFactory {
    private Map<Constants.OperationType, Operation> typedOperations = new HashMap();
    private ConfigExtractor config;
    private Random rnd;

    OperationFactory(ConfigExtractor cfg, Random rnd) {
        this.config = cfg;
        this.rnd = rnd;
    }

    Operation getOperation(Constants.OperationType type) {
        Operation op = (Operation)this.typedOperations.get(type);
        if (op != null) {
            return op;
        }
        switch (1.$SwitchMap$org$apache$hadoop$fs$slive$Constants$OperationType[type.ordinal()]) {
            case 1: {
                op = new ReadOp(this.config, this.rnd);
                break;
            }
            case 2: {
                op = new ListOp(this.config, this.rnd);
                break;
            }
            case 3: {
                op = new MkdirOp(this.config, this.rnd);
                break;
            }
            case 4: {
                op = new AppendOp(this.config, this.rnd);
                break;
            }
            case 5: {
                op = new RenameOp(this.config, this.rnd);
                break;
            }
            case 6: {
                op = new DeleteOp(this.config, this.rnd);
                break;
            }
            case 7: {
                op = new CreateOp(this.config, this.rnd);
            }
        }
        this.typedOperations.put(type, op);
        return op;
    }
}

