/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.text.NumberFormat;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.FieldSelectionMapReduce;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.lib.fieldsel.TestMRFieldSelection;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestFieldSelection
extends TestCase {
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public void testFieldSelection() throws Exception {
        TestFieldSelection.launch();
    }

    public static void launch() throws Exception {
        JobConf conf = new JobConf(TestFieldSelection.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numOfInputLines = 10;
        Path OUTPUT_DIR = new Path("build/test/output_for_field_selection_test");
        Path INPUT_DIR = new Path("build/test/input_for_field_selection_test");
        String inputFile = "input.txt";
        fs.delete(INPUT_DIR, true);
        fs.mkdirs(INPUT_DIR);
        fs.delete(OUTPUT_DIR, true);
        StringBuffer inputData = new StringBuffer();
        StringBuffer expectedOutput = new StringBuffer();
        TestMRFieldSelection.constructInputOutputData((StringBuffer)inputData, (StringBuffer)expectedOutput, (int)numOfInputLines);
        FSDataOutputStream fileOut = fs.create(new Path(INPUT_DIR, inputFile));
        fileOut.write(inputData.toString().getBytes("utf-8"));
        fileOut.close();
        System.out.println("inputData:");
        System.out.println(inputData.toString());
        JobConf job = new JobConf((Configuration)conf, TestFieldSelection.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{INPUT_DIR});
        job.setInputFormat(TextInputFormat.class);
        job.setMapperClass(FieldSelectionMapReduce.class);
        job.setReducerClass(FieldSelectionMapReduce.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)OUTPUT_DIR);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormat(TextOutputFormat.class);
        job.setNumReduceTasks(1);
        job.set("mapreduce.fieldsel.data.field.separator", "-");
        job.set("mapreduce.fieldsel.map.output.key.value.fields.spec", "6,5,1-3:0-");
        job.set("mapreduce.fieldsel.reduce.output.key.value.fields.spec", ":4,3,2,1,0,0-");
        JobClient.runJob((JobConf)job);
        boolean success = true;
        Path outPath = new Path(OUTPUT_DIR, "part-00000");
        String outdata = MapReduceTestUtil.readOutput((Path)outPath, (Configuration)job);
        TestFieldSelection.assertEquals((String)expectedOutput.toString(), (String)outdata);
        fs.delete(OUTPUT_DIR, true);
        fs.delete(INPUT_DIR, true);
    }

    public static void main(String[] argv) throws Exception {
        TestFieldSelection.launch();
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
    }
}

