/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestOldCombinerGrouping;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestOldCombinerGrouping {
    private static String TEST_ROOT_DIR = new File("build", UUID.randomUUID().toString()).getAbsolutePath();

    @Test
    public void testCombiner() throws Exception {
        if (!new File(TEST_ROOT_DIR).mkdirs()) {
            throw new RuntimeException("Could not create test dir: " + TEST_ROOT_DIR);
        }
        File in = new File(TEST_ROOT_DIR, "input");
        if (!in.mkdirs()) {
            throw new RuntimeException("Could not create test dir: " + in);
        }
        File out = new File(TEST_ROOT_DIR, "output");
        PrintWriter pw = new PrintWriter(new FileWriter(new File(in, "data.txt")));
        pw.println("A|a,1");
        pw.println("A|b,2");
        pw.println("B|a,3");
        pw.println("B|b,4");
        pw.println("B|c,5");
        pw.close();
        JobConf job = new JobConf();
        job.set("mapreduce.framework.name", "local");
        TextInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(in.getPath())});
        TextOutputFormat.setOutputPath((JobConf)job, (Path)new Path(out.getPath()));
        job.setMapperClass(Map.class);
        job.setReducerClass(Reduce.class);
        job.setInputFormat(TextInputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setOutputFormat(TextOutputFormat.class);
        job.setOutputValueGroupingComparator(GroupComparator.class);
        job.setCombinerClass(Combiner.class);
        job.setCombinerKeyGroupingComparator(GroupComparator.class);
        job.setInt("min.num.spills.for.combine", 0);
        JobClient client = new JobClient(job);
        RunningJob runningJob = client.submitJob(job);
        runningJob.waitForCompletion();
        if (runningJob.isSuccessful()) {
            Counters counters = runningJob.getCounters();
            long combinerInputRecords = counters.getGroup("org.apache.hadoop.mapreduce.TaskCounter").getCounter("COMBINE_INPUT_RECORDS");
            long combinerOutputRecords = counters.getGroup("org.apache.hadoop.mapreduce.TaskCounter").getCounter("COMBINE_OUTPUT_RECORDS");
            Assert.assertTrue((combinerInputRecords > 0L ? 1 : 0) != 0);
            Assert.assertTrue((combinerInputRecords > combinerOutputRecords ? 1 : 0) != 0);
            BufferedReader br = new BufferedReader(new FileReader(new File(out, "part-00000")));
            HashSet<String> output = new HashSet<String>();
            String line = br.readLine();
            Assert.assertNotNull((Object)line);
            output.add(line.substring(0, 1) + line.substring(4, 5));
            line = br.readLine();
            Assert.assertNotNull((Object)line);
            output.add(line.substring(0, 1) + line.substring(4, 5));
            line = br.readLine();
            Assert.assertNull((Object)line);
            br.close();
            HashSet<String> expected = new HashSet<String>();
            expected.add("A2");
            expected.add("B5");
            Assert.assertEquals(expected, output);
        } else {
            Assert.fail((String)"Job failed");
        }
    }
}

