/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.MultithreadedMapRunner;
import org.apache.hadoop.mapred.lib.TestMultithreadedMapRunner;
import org.apache.hadoop.mapreduce.lib.map.MultithreadedMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMultithreadedMapRunner
extends HadoopTestCase {
    public TestMultithreadedMapRunner() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testOKRun() throws Exception {
        this.run(false, false);
    }

    public void testIOExRun() throws Exception {
        this.run(true, false);
    }

    public void testRuntimeExRun() throws Exception {
        this.run(false, true);
    }

    private void run(boolean ioEx, boolean rtEx) throws Exception {
        Path inDir = new Path("testing/mt/input");
        Path outDir = new Path("testing/mt/output");
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            inDir = new Path(localPathRoot, inDir);
            outDir = new Path(localPathRoot, outDir);
        }
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        conf.setJobName("mt");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IDMap.class);
        conf.setReducerClass(IDReduce.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setMapRunnerClass(MultithreadedMapRunner.class);
        conf.setInt(MultithreadedMapper.NUM_THREADS, 2);
        if (ioEx) {
            conf.setBoolean("multithreaded.ioException", true);
        }
        if (rtEx) {
            conf.setBoolean("multithreaded.runtimeException", true);
        }
        JobClient jc = new JobClient(conf);
        RunningJob job = jc.submitJob(conf);
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        if (job.isSuccessful()) {
            TestMultithreadedMapRunner.assertFalse((ioEx || rtEx ? 1 : 0) != 0);
        } else {
            TestMultithreadedMapRunner.assertTrue((ioEx || rtEx ? 1 : 0) != 0);
        }
    }
}

