/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TestMRCJCFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.test.MockitoMaker;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMRCJCFileInputFormat {
    @Test
    public void testAddInputPath() throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///abc/");
        Job j = Job.getInstance((Configuration)conf);
        FileSystem defaultfs = FileSystem.get((Configuration)conf);
        System.out.println("defaultfs.getUri() = " + defaultfs.getUri());
        Path original = new Path("file:/foo");
        System.out.println("original = " + original);
        FileInputFormat.addInputPath((Job)j, (Path)original);
        Path[] results = FileInputFormat.getInputPaths((JobContext)j);
        System.out.println("results = " + Arrays.asList(results));
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((Object)original, (Object)results[0]);
        original = new Path("file:/bar");
        System.out.println("original = " + original);
        FileInputFormat.setInputPaths((Job)j, (Path[])new Path[]{original});
        results = FileInputFormat.getInputPaths((JobContext)j);
        System.out.println("results = " + Arrays.asList(results));
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertEquals((Object)original, (Object)results[0]);
    }

    @Test
    public void testNumInputFiles() throws Exception {
        Configuration conf = (Configuration)Mockito.spy((Object)new Configuration());
        Job job = (Job)MockitoMaker.make((Object)((Job)MockitoMaker.stub(Job.class).returning((Object)conf).from).getConfiguration());
        FileStatus stat = (FileStatus)MockitoMaker.make((Object)((FileStatus)MockitoMaker.stub(FileStatus.class).returning((Object)Long.valueOf((long)0L)).from).getLen());
        TextInputFormat ispy = (TextInputFormat)Mockito.spy((Object)new TextInputFormat());
        ((TextInputFormat)Mockito.doReturn(Arrays.asList(stat)).when((Object)ispy)).listStatus((JobContext)job);
        ispy.getSplits((JobContext)job);
        ((Configuration)Mockito.verify((Object)conf)).setLong("mapreduce.input.fileinputformat.numinputfiles", 1L);
    }

    @Test
    public void testLastInputSplitAtSplitBoundary() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(this, 0x40000000L, 0x8000000L);
        Configuration conf = new Configuration();
        JobContext jobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)jobContext.getConfiguration()).thenReturn((Object)conf);
        List splits = fif.getSplits(jobContext);
        Assert.assertEquals((long)8L, (long)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assert.assertEquals((Object)("host" + i), (Object)split.getLocations()[0]);
        }
    }

    @Test
    public void testLastInputSplitExceedingSplitBoundary() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(this, 0x40300000L, 0x8000000L);
        Configuration conf = new Configuration();
        JobContext jobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)jobContext.getConfiguration()).thenReturn((Object)conf);
        List splits = fif.getSplits(jobContext);
        Assert.assertEquals((long)8L, (long)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assert.assertEquals((Object)("host" + i), (Object)split.getLocations()[0]);
        }
    }

    @Test
    public void testLastInputSplitSingleSplit() throws Exception {
        FileInputFormatForTest fif = new FileInputFormatForTest(this, 0x6400000L, 0x8000000L);
        Configuration conf = new Configuration();
        JobContext jobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)jobContext.getConfiguration()).thenReturn((Object)conf);
        List splits = fif.getSplits(jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assert.assertEquals((Object)("host" + i), (Object)split.getLocations()[0]);
        }
    }

    @Test
    public void testForEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        Path file = new Path("test/file");
        FSDataOutputStream out = fileSys.create(file, true, conf.getInt("io.file.buffer.size", 4096), (short)1, 1024L);
        out.write(new byte[0]);
        out.close();
        DummyInputFormat inFormat = new DummyInputFormat(this, null);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)"test");
        List splits = inFormat.getSplits((JobContext)job);
        Assert.assertEquals((long)1L, (long)splits.size());
        FileSplit fileSplit = (FileSplit)splits.get(0);
        Assert.assertEquals((long)0L, (long)fileSplit.getLocations().length);
        Assert.assertEquals((Object)file.getName(), (Object)fileSplit.getPath().getName());
        Assert.assertEquals((long)0L, (long)fileSplit.getStart());
        Assert.assertEquals((long)0L, (long)fileSplit.getLength());
        fileSys.delete(file.getParent(), true);
    }
}

