/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceUtilizationPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeReportPBImpl
extends NodeReport {
    private YarnProtos.NodeReportProto proto = YarnProtos.NodeReportProto.getDefaultInstance();
    private YarnProtos.NodeReportProto.Builder builder = null;
    private boolean viaProto = false;
    private NodeId nodeId;
    private Resource used;
    private Resource capability;
    private ResourceUtilization containersUtilization = null;
    private ResourceUtilization nodeUtilization = null;
    Set<String> labels;

    public NodeReportPBImpl() {
        this.builder = YarnProtos.NodeReportProto.newBuilder();
    }

    public NodeReportPBImpl(YarnProtos.NodeReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public Resource getCapability() {
        YarnProtos.NodeReportProto p;
        if (this.capability != null) {
            return this.capability;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasCapability()) {
            return null;
        }
        this.capability = this.convertFromProtoFormat(p.getCapability());
        return this.capability;
    }

    public String getHealthReport() {
        YarnProtos.NodeReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getHealthReport();
    }

    public void setHealthReport(String healthReport) {
        this.maybeInitBuilder();
        if (healthReport == null) {
            this.builder.clearHealthReport();
            return;
        }
        this.builder.setHealthReport(healthReport);
    }

    public long getLastHealthReportTime() {
        YarnProtos.NodeReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getLastHealthReportTime();
    }

    public void setLastHealthReportTime(long lastHealthReportTime) {
        this.maybeInitBuilder();
        this.builder.setLastHealthReportTime(lastHealthReportTime);
    }

    public String getHttpAddress() {
        YarnProtos.NodeReportProto p = this.viaProto ? this.proto : this.builder;
        return p.hasHttpAddress() ? p.getHttpAddress() : null;
    }

    public int getNumContainers() {
        YarnProtos.NodeReportProto p = this.viaProto ? this.proto : this.builder;
        return p.hasNumContainers() ? p.getNumContainers() : 0;
    }

    public String getRackName() {
        YarnProtos.NodeReportProto p = this.viaProto ? this.proto : this.builder;
        return p.hasRackName() ? p.getRackName() : null;
    }

    public Resource getUsed() {
        YarnProtos.NodeReportProto p;
        if (this.used != null) {
            return this.used;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasUsed()) {
            return null;
        }
        this.used = this.convertFromProtoFormat(p.getUsed());
        return this.used;
    }

    public NodeId getNodeId() {
        YarnProtos.NodeReportProto p;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    public NodeState getNodeState() {
        YarnProtos.NodeReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeState()) {
            return null;
        }
        return ProtoUtils.convertFromProtoFormat(p.getNodeState());
    }

    public void setNodeState(NodeState nodeState) {
        this.maybeInitBuilder();
        if (nodeState == null) {
            this.builder.clearNodeState();
            return;
        }
        this.builder.setNodeState(ProtoUtils.convertToProtoFormat(nodeState));
    }

    public void setCapability(Resource capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
        }
        this.capability = capability;
    }

    public void setHttpAddress(String httpAddress) {
        this.maybeInitBuilder();
        if (httpAddress == null) {
            this.builder.clearHttpAddress();
            return;
        }
        this.builder.setHttpAddress(httpAddress);
    }

    public void setNumContainers(int numContainers) {
        this.maybeInitBuilder();
        if (numContainers == 0) {
            this.builder.clearNumContainers();
            return;
        }
        this.builder.setNumContainers(numContainers);
    }

    public void setRackName(String rackName) {
        this.maybeInitBuilder();
        if (rackName == null) {
            this.builder.clearRackName();
            return;
        }
        this.builder.setRackName(rackName);
    }

    public void setUsed(Resource used) {
        this.maybeInitBuilder();
        if (used == null) {
            this.builder.clearUsed();
        }
        this.used = used;
    }

    public YarnProtos.NodeReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((NodeReportPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.nodeId != null && !((NodeIdPBImpl)this.nodeId).getProto().equals((Object)this.builder.getNodeId())) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.used != null && !((ResourcePBImpl)this.used).getProto().equals((Object)this.builder.getUsed())) {
            this.builder.setUsed(this.convertToProtoFormat(this.used));
        }
        if (this.capability != null && !((ResourcePBImpl)this.capability).getProto().equals((Object)this.builder.getCapability())) {
            this.builder.setCapability(this.convertToProtoFormat(this.capability));
        }
        if (this.labels != null) {
            this.builder.clearNodeLabels();
            this.builder.addAllNodeLabels(this.labels);
        }
        if (this.nodeUtilization != null && !((ResourceUtilizationPBImpl)this.nodeUtilization).getProto().equals((Object)this.builder.getNodeUtilization())) {
            this.builder.setNodeUtilization(this.convertToProtoFormat(this.nodeUtilization));
        }
        if (this.containersUtilization != null && !((ResourceUtilizationPBImpl)this.containersUtilization).getProto().equals((Object)this.builder.getContainersUtilization())) {
            this.builder.setContainersUtilization(this.convertToProtoFormat(this.containersUtilization));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.NodeReportProto.newBuilder((YarnProtos.NodeReportProto)this.proto);
        }
        this.viaProto = false;
    }

    private NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId nodeId) {
        return ((NodeIdPBImpl)nodeId).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ((ResourcePBImpl)r).getProto();
    }

    private ResourceUtilizationPBImpl convertFromProtoFormat(YarnProtos.ResourceUtilizationProto p) {
        return new ResourceUtilizationPBImpl(p);
    }

    private YarnProtos.ResourceUtilizationProto convertToProtoFormat(ResourceUtilization r) {
        return ((ResourceUtilizationPBImpl)r).getProto();
    }

    public Set<String> getNodeLabels() {
        this.initNodeLabels();
        return this.labels;
    }

    public void setNodeLabels(Set<String> nodeLabels) {
        this.maybeInitBuilder();
        this.builder.clearNodeLabels();
        this.labels = nodeLabels;
    }

    private void initNodeLabels() {
        if (this.labels != null) {
            return;
        }
        YarnProtos.NodeReportProto p = this.viaProto ? this.proto : this.builder;
        this.labels = new HashSet<String>();
        this.labels.addAll(p.getNodeLabelsList());
    }

    public ResourceUtilization getAggregatedContainersUtilization() {
        YarnProtos.NodeReportProto p;
        if (this.containersUtilization != null) {
            return this.containersUtilization;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasContainersUtilization()) {
            return null;
        }
        this.containersUtilization = this.convertFromProtoFormat(p.getContainersUtilization());
        return this.containersUtilization;
    }

    public void setAggregatedContainersUtilization(ResourceUtilization containersResourceUtilization) {
        this.maybeInitBuilder();
        if (containersResourceUtilization == null) {
            this.builder.clearContainersUtilization();
        }
        this.containersUtilization = containersResourceUtilization;
    }

    public ResourceUtilization getNodeUtilization() {
        YarnProtos.NodeReportProto p;
        if (this.nodeUtilization != null) {
            return this.nodeUtilization;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeUtilization()) {
            return null;
        }
        this.nodeUtilization = this.convertFromProtoFormat(p.getNodeUtilization());
        return this.nodeUtilization;
    }

    public void setNodeUtilization(ResourceUtilization nodeResourceUtilization) {
        this.maybeInitBuilder();
        if (nodeResourceUtilization == null) {
            this.builder.clearNodeUtilization();
        }
        this.nodeUtilization = nodeResourceUtilization;
    }
}

