/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerSubState;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationResourceUsageReportPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ExecutionTypeRequestPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.UpdateContainerErrorPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.UpdateContainerRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.api.ContainerType;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ProtoUtils {
    private static final String CONTAINER_STATE_PREFIX = "C_";
    private static final String CONTAINER_SUB_STATE_PREFIX = "CSS_";
    private static final String NODE_STATE_PREFIX = "NS_";
    private static String YARN_APPLICATION_ATTEMPT_STATE_PREFIX = "APP_ATTEMPT_";
    private static String FINAL_APPLICATION_STATUS_PREFIX = "APP_";
    private static String QUEUE_STATE_PREFIX = "Q_";
    private static String QUEUE_ACL_PREFIX = "QACL_";
    private static String APP_ACCESS_TYPE_PREFIX = "APPACCESS_";
    private static String APP_TIMEOUT_TYPE_PREFIX = "APP_TIMEOUT_";
    private static final String LOG_AGGREGATION_STATUS_PREFIX = "LOG_";
    private static final int LOG_AGGREGATION_STATUS_PREFIX_LEN = "LOG_".length();

    public static YarnProtos.ContainerStateProto convertToProtoFormat(ContainerState e) {
        return YarnProtos.ContainerStateProto.valueOf((String)(CONTAINER_STATE_PREFIX + e.name()));
    }

    public static ContainerState convertFromProtoFormat(YarnProtos.ContainerStateProto e) {
        return ContainerState.valueOf((String)e.name().replace(CONTAINER_STATE_PREFIX, ""));
    }

    public static YarnProtos.ContainerSubStateProto convertToProtoFormat(ContainerSubState e) {
        return YarnProtos.ContainerSubStateProto.valueOf((String)(CONTAINER_SUB_STATE_PREFIX + e.name()));
    }

    public static ContainerSubState convertFromProtoFormat(YarnProtos.ContainerSubStateProto e) {
        return ContainerSubState.valueOf((String)e.name().substring(CONTAINER_SUB_STATE_PREFIX.length()));
    }

    public static YarnProtos.NodeStateProto convertToProtoFormat(NodeState e) {
        return YarnProtos.NodeStateProto.valueOf((String)(NODE_STATE_PREFIX + e.name()));
    }

    public static NodeState convertFromProtoFormat(YarnProtos.NodeStateProto e) {
        return NodeState.valueOf((String)e.name().replace(NODE_STATE_PREFIX, ""));
    }

    public static YarnProtos.NodeIdProto convertToProtoFormat(NodeId e) {
        return ((NodeIdPBImpl)e).getProto();
    }

    public static NodeId convertFromProtoFormat(YarnProtos.NodeIdProto e) {
        return new NodeIdPBImpl(e);
    }

    public static YarnProtos.YarnApplicationStateProto convertToProtoFormat(YarnApplicationState e) {
        return YarnProtos.YarnApplicationStateProto.valueOf((String)e.name());
    }

    public static YarnApplicationState convertFromProtoFormat(YarnProtos.YarnApplicationStateProto e) {
        return YarnApplicationState.valueOf((String)e.name());
    }

    public static YarnProtos.YarnApplicationAttemptStateProto convertToProtoFormat(YarnApplicationAttemptState e) {
        return YarnProtos.YarnApplicationAttemptStateProto.valueOf((String)(YARN_APPLICATION_ATTEMPT_STATE_PREFIX + e.name()));
    }

    public static YarnApplicationAttemptState convertFromProtoFormat(YarnProtos.YarnApplicationAttemptStateProto e) {
        return YarnApplicationAttemptState.valueOf((String)e.name().replace(YARN_APPLICATION_ATTEMPT_STATE_PREFIX, ""));
    }

    public static YarnServiceProtos.ApplicationsRequestScopeProto convertToProtoFormat(ApplicationsRequestScope e) {
        return YarnServiceProtos.ApplicationsRequestScopeProto.valueOf((String)e.name());
    }

    public static ApplicationsRequestScope convertFromProtoFormat(YarnServiceProtos.ApplicationsRequestScopeProto e) {
        return ApplicationsRequestScope.valueOf((String)e.name());
    }

    public static YarnProtos.ApplicationResourceUsageReportProto convertToProtoFormat(ApplicationResourceUsageReport e) {
        return ((ApplicationResourceUsageReportPBImpl)e).getProto();
    }

    public static ApplicationResourceUsageReport convertFromProtoFormat(YarnProtos.ApplicationResourceUsageReportProto e) {
        return new ApplicationResourceUsageReportPBImpl(e);
    }

    public static YarnProtos.FinalApplicationStatusProto convertToProtoFormat(FinalApplicationStatus e) {
        return YarnProtos.FinalApplicationStatusProto.valueOf((String)(FINAL_APPLICATION_STATUS_PREFIX + e.name()));
    }

    public static FinalApplicationStatus convertFromProtoFormat(YarnProtos.FinalApplicationStatusProto e) {
        return FinalApplicationStatus.valueOf((String)e.name().replace(FINAL_APPLICATION_STATUS_PREFIX, ""));
    }

    public static YarnProtos.LocalResourceTypeProto convertToProtoFormat(LocalResourceType e) {
        return YarnProtos.LocalResourceTypeProto.valueOf((String)e.name());
    }

    public static LocalResourceType convertFromProtoFormat(YarnProtos.LocalResourceTypeProto e) {
        return LocalResourceType.valueOf((String)e.name());
    }

    public static YarnProtos.LocalResourceVisibilityProto convertToProtoFormat(LocalResourceVisibility e) {
        return YarnProtos.LocalResourceVisibilityProto.valueOf((String)e.name());
    }

    public static LocalResourceVisibility convertFromProtoFormat(YarnProtos.LocalResourceVisibilityProto e) {
        return LocalResourceVisibility.valueOf((String)e.name());
    }

    public static YarnProtos.AMCommandProto convertToProtoFormat(AMCommand e) {
        return YarnProtos.AMCommandProto.valueOf((String)e.name());
    }

    public static AMCommand convertFromProtoFormat(YarnProtos.AMCommandProto e) {
        return AMCommand.valueOf((String)e.name());
    }

    public static ByteBuffer convertFromProtoFormat(ByteString byteString) {
        int capacity = byteString.asReadOnlyByteBuffer().rewind().remaining();
        byte[] b = new byte[capacity];
        byteString.asReadOnlyByteBuffer().get(b, 0, capacity);
        return ByteBuffer.wrap(b);
    }

    public static ByteString convertToProtoFormat(ByteBuffer byteBuffer) {
        int oldPos = byteBuffer.position();
        byteBuffer.rewind();
        ByteString bs = ByteString.copyFrom((ByteBuffer)byteBuffer);
        byteBuffer.position(oldPos);
        return bs;
    }

    public static YarnProtos.QueueStateProto convertToProtoFormat(QueueState e) {
        return YarnProtos.QueueStateProto.valueOf((String)(QUEUE_STATE_PREFIX + e.name()));
    }

    public static QueueState convertFromProtoFormat(YarnProtos.QueueStateProto e) {
        return QueueState.valueOf((String)e.name().replace(QUEUE_STATE_PREFIX, ""));
    }

    public static YarnProtos.QueueACLProto convertToProtoFormat(QueueACL e) {
        return YarnProtos.QueueACLProto.valueOf((String)(QUEUE_ACL_PREFIX + e.name()));
    }

    public static QueueACL convertFromProtoFormat(YarnProtos.QueueACLProto e) {
        return QueueACL.valueOf((String)e.name().replace(QUEUE_ACL_PREFIX, ""));
    }

    public static YarnProtos.ApplicationAccessTypeProto convertToProtoFormat(ApplicationAccessType e) {
        return YarnProtos.ApplicationAccessTypeProto.valueOf((String)(APP_ACCESS_TYPE_PREFIX + e.name()));
    }

    public static ApplicationAccessType convertFromProtoFormat(YarnProtos.ApplicationAccessTypeProto e) {
        return ApplicationAccessType.valueOf((String)e.name().replace(APP_ACCESS_TYPE_PREFIX, ""));
    }

    public static YarnProtos.ApplicationTimeoutTypeProto convertToProtoFormat(ApplicationTimeoutType e) {
        return YarnProtos.ApplicationTimeoutTypeProto.valueOf((String)(APP_TIMEOUT_TYPE_PREFIX + e.name()));
    }

    public static ApplicationTimeoutType convertFromProtoFormat(YarnProtos.ApplicationTimeoutTypeProto e) {
        return ApplicationTimeoutType.valueOf((String)e.name().replace(APP_TIMEOUT_TYPE_PREFIX, ""));
    }

    public static YarnProtos.ReservationRequestInterpreterProto convertToProtoFormat(ReservationRequestInterpreter e) {
        return YarnProtos.ReservationRequestInterpreterProto.valueOf((String)e.name());
    }

    public static ReservationRequestInterpreter convertFromProtoFormat(YarnProtos.ReservationRequestInterpreterProto e) {
        return ReservationRequestInterpreter.valueOf((String)e.name());
    }

    public static YarnProtos.LogAggregationStatusProto convertToProtoFormat(LogAggregationStatus e) {
        return YarnProtos.LogAggregationStatusProto.valueOf((String)(LOG_AGGREGATION_STATUS_PREFIX + e.name()));
    }

    public static LogAggregationStatus convertFromProtoFormat(YarnProtos.LogAggregationStatusProto e) {
        return LogAggregationStatus.valueOf((String)e.name().substring(LOG_AGGREGATION_STATUS_PREFIX_LEN));
    }

    public static YarnProtos.ContainerTypeProto convertToProtoFormat(ContainerType e) {
        return YarnProtos.ContainerTypeProto.valueOf((String)e.name());
    }

    public static ContainerType convertFromProtoFormat(YarnProtos.ContainerTypeProto e) {
        return ContainerType.valueOf((String)e.name());
    }

    public static YarnProtos.ContainerRetryPolicyProto convertToProtoFormat(ContainerRetryPolicy e) {
        return YarnProtos.ContainerRetryPolicyProto.valueOf((String)e.name());
    }

    public static ContainerRetryPolicy convertFromProtoFormat(YarnProtos.ContainerRetryPolicyProto e) {
        return ContainerRetryPolicy.valueOf((String)e.name());
    }

    public static YarnProtos.ExecutionTypeProto convertToProtoFormat(ExecutionType e) {
        return YarnProtos.ExecutionTypeProto.valueOf((String)e.name());
    }

    public static ExecutionType convertFromProtoFormat(YarnProtos.ExecutionTypeProto e) {
        return ExecutionType.valueOf((String)e.name());
    }

    public static YarnServiceProtos.ContainerUpdateTypeProto convertToProtoFormat(ContainerUpdateType e) {
        return YarnServiceProtos.ContainerUpdateTypeProto.valueOf((String)e.name());
    }

    public static ContainerUpdateType convertFromProtoFormat(YarnServiceProtos.ContainerUpdateTypeProto e) {
        return ContainerUpdateType.valueOf((String)e.name());
    }

    public static synchronized YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ResourcePBImpl.getProto(r);
    }

    public static Resource convertFromProtoFormat(YarnProtos.ResourceProto resource) {
        return new ResourcePBImpl(resource);
    }

    public static YarnProtos.ExecutionTypeRequestProto convertToProtoFormat(ExecutionTypeRequest e) {
        return ((ExecutionTypeRequestPBImpl)e).getProto();
    }

    public static ExecutionTypeRequest convertFromProtoFormat(YarnProtos.ExecutionTypeRequestProto e) {
        return new ExecutionTypeRequestPBImpl(e);
    }

    public static YarnProtos.ContainerProto convertToProtoFormat(Container t) {
        return ((ContainerPBImpl)t).getProto();
    }

    public static ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto t) {
        return new ContainerPBImpl(t);
    }

    public static ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto p) {
        return new ContainerStatusPBImpl(p);
    }

    public static ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    public static YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    public static UpdateContainerRequestPBImpl convertFromProtoFormat(YarnServiceProtos.UpdateContainerRequestProto p) {
        return new UpdateContainerRequestPBImpl(p);
    }

    public static YarnServiceProtos.UpdateContainerRequestProto convertToProtoFormat(UpdateContainerRequest t) {
        return ((UpdateContainerRequestPBImpl)t).getProto();
    }

    public static UpdateContainerErrorPBImpl convertFromProtoFormat(YarnServiceProtos.UpdateContainerErrorProto p) {
        return new UpdateContainerErrorPBImpl(p);
    }

    public static YarnServiceProtos.UpdateContainerErrorProto convertToProtoFormat(UpdateContainerError t) {
        return ((UpdateContainerErrorPBImpl)t).getProto();
    }
}

