/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.impl.OntModelImpl;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.riot.lang.ReaderRIOTRDFXML;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.main.StageBuilder;
import org.apache.jena.sparql.engine.main.StageGenerator;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.assembler.AssemblerTDB;
import org.apache.jena.tdb.modify.UpdateEngineTDB;
import org.apache.jena.tdb.setup.DatasetBuilderStd;
import org.apache.jena.tdb.solver.QueryEngineTDB;
import org.apache.jena.tdb.solver.StageGeneratorDirectTDB;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.sys.EnvTDB;
import org.apache.jena.tdb.sys.SystemTDB;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;
import org.apache.jena.util.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDB {
    private static final Object initLock = new Object();
    private static volatile boolean initialized = false;
    public static final String tdbIRI = "http://jena.hpl.hp.com/#tdb";
    public static final String tdbParamNS = "http://jena.hpl.hp.com/TDB#";
    public static final String tdbSymbolPrefix = "tdb";
    private static final Logger log = LoggerFactory.getLogger(TDB.class);
    public static final String logLoaderName = "org.apache.jena.tdb.loader";
    public static final Logger logLoader = LoggerFactory.getLogger((String)"org.apache.jena.tdb.loader");
    public static final String logInfoName = "org.apache.jena.info";
    public static final Logger logInfo = LoggerFactory.getLogger((String)"org.apache.jena.info");
    public static final String namespace = "http://jena.hpl.hp.com/2008/tdb#";
    public static final Symbol symUnionDefaultGraph = SystemTDB.allocSymbol("unionDefaultGraph");
    public static final Symbol transactionJournalWriteBlockMode = SystemTDB.allocSymbol("transactionJournalWriteBlockMode");
    private static String metadataLocation = "org/apache/jena/tdb/tdb-properties.xml";
    private static Metadata metadata = new Metadata(metadataLocation);
    public static final String PATH = "org.apache.jena.tdb";
    public static final String NAME = "TDB";
    public static final String VERSION = metadata.get("org.apache.jena.tdb.version", "DEV");
    public static final String BUILD_DATE = metadata.get("org.apache.jena.tdb.build.datetime", "unset");

    private TDB() {
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    public static void closedown() {
        StoreConnection.reset();
    }

    public static void setOptimizerWarningFlag(boolean b) {
        DatasetBuilderStd.setOptimizerWarningFlag(b);
    }

    public static void sync(Model model) {
        if (model instanceof OntModelImpl) {
            OntModelImpl ontModel = (OntModelImpl)model;
            TDB.sync(ontModel.getBaseGraph());
            return;
        }
        if (model instanceof OntModel) {
            OntModel ontModel = (OntModel)model;
            TDB.sync(ontModel.getBaseModel());
            return;
        }
        TDB.sync(model.getGraph());
    }

    public static void sync(Graph graph) {
        if (graph == null) {
            return;
        }
        if (graph instanceof InfGraph) {
            InfGraph infGraph = (InfGraph)graph;
            TDB.sync(infGraph.getRawGraph());
            return;
        }
        TDB.syncObject(graph);
    }

    public static void sync(Dataset dataset) {
        if (dataset == null) {
            return;
        }
        DatasetGraph ds = dataset.asDatasetGraph();
        TDB.sync(ds);
    }

    public static void sync(DatasetGraph dataset) {
        if (dataset == null) {
            return;
        }
        if (dataset instanceof DatasetGraphTDB) {
            TDB.syncObject(dataset);
            return;
        }
        if (dataset instanceof DatasetGraphTransaction) {
            DatasetGraphTransaction dsgt = (DatasetGraphTransaction)dataset;
            dsgt.syncIfNotTransactional();
            return;
        }
        TDB.sync(dataset.getDefaultGraph());
        Iterator iter = dataset.listGraphNodes();
        for (Node n : Iter.toList((Iterator)iter)) {
            Graph g = dataset.getGraph(n);
            TDB.sync(g);
        }
    }

    private static void syncObject(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Sync) {
            ((Sync)object).sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                JenaSystem.logLifecycle((String)"TDB.init - return", (Object[])new Object[0]);
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle((String)"TDB.init - start", (Object[])new Object[0]);
            ReaderRIOTRDFXML.RiotUniformCompatibility = true;
            EnvTDB.processGlobalSystemProperties();
            MappingRegistry.addPrefixMapping((String)tdbSymbolPrefix, (String)tdbParamNS);
            AssemblerTDB.init();
            QueryEngineTDB.register();
            UpdateEngineTDB.register();
            TDB.wireIntoExecution();
            JenaSystem.logLifecycle((String)"TDB.init - finish", (Object[])new Object[0]);
        }
    }

    private static void wireIntoExecution() {
        Context cxt = ARQ.getContext();
        StageGenerator orig = StageBuilder.chooseStageGenerator((Context)cxt);
        StageGeneratorDirectTDB stageGenerator = new StageGeneratorDirectTDB(orig);
        StageBuilder.setGenerator((Context)ARQ.getContext(), (StageGenerator)stageGenerator);
    }

    private static void initialization2() {
        SystemInfo systemInfo = new SystemInfo(tdbIRI, PATH, VERSION, BUILD_DATE);
        SystemARQ.registerSubSystem((SystemInfo)systemInfo);
    }

    static {
        JenaSystem.init();
        TDB.initialization2();
    }
}

