/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.util.UrlUtils;

public class Classpath {
    private final List elements = new ArrayList();

    public static Classpath join(Classpath firstClasspath, Classpath secondClasspath) {
        Classpath joinedClasspath = new Classpath();
        joinedClasspath.addElementsOfClasspath(firstClasspath);
        joinedClasspath.addElementsOfClasspath(secondClasspath);
        return joinedClasspath;
    }

    public Classpath() {
    }

    public Classpath(List elements) {
        this();
        this.addElements(elements);
    }

    public void addClassPathElementUrl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null is not a valid class path element url.");
        }
        if (!this.elements.contains(path)) {
            this.elements.add(path);
        }
    }

    private void addElements(List additionalElements) {
        Iterator it = additionalElements.iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            this.addClassPathElementUrl(element);
        }
    }

    private void addElementsOfClasspath(Classpath otherClasspath) {
        if (otherClasspath != null) {
            this.addElements(otherClasspath.elements);
        }
    }

    public List getClassPath() {
        return Collections.unmodifiableList(this.elements);
    }

    public List getAsUrlList() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            String url = (String)i.next();
            File f = new File(url);
            urls.add(UrlUtils.getURL((File)f));
        }
        return urls;
    }

    public void writeToSystemProperty(String propertyName) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next()).append(File.pathSeparatorChar);
        }
        System.setProperty(propertyName, sb.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classpath classpath = (Classpath)o;
        return !(this.elements == null ? classpath.elements != null : !((Object)this.elements).equals(classpath.elements));
    }

    public int hashCode() {
        return this.elements != null ? ((Object)this.elements).hashCode() : 0;
    }
}

