/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;

public final class OtherLocales
extends AbstractCollection<Locale> {
    private final Collection<Locale> languages;

    private OtherLocales(Collection<Locale> collection) {
        this.languages = collection;
    }

    public static Collection<Locale> filter(Collection<Locale> collection) {
        return collection != null ? new OtherLocales(collection) : null;
    }

    @Override
    public int size() {
        int n = this.languages.size();
        if (n != 0) {
            --n;
        }
        return n;
    }

    @Override
    public Iterator<Locale> iterator() {
        Iterator<Locale> iterator = this.languages.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public boolean add(Locale locale) {
        ArgumentChecks.ensureNonNull((String)"locale", (Object)locale);
        if (this.languages.isEmpty()) {
            Locale locale2 = Locale.getDefault();
            if (locale2.equals(locale)) {
                locale2 = Locale.ROOT;
            }
            this.languages.add(locale2);
        }
        return this.languages.add(locale);
    }

    public static Collection<Locale> merge(Locale locale, Collection<? extends Locale> collection) {
        Collection<Locale> collection2;
        if (Containers.isNullOrEmpty(collection)) {
            collection2 = LegacyPropertyAdapter.asCollection(locale);
        } else {
            collection2 = new ArrayList<Locale>(collection.size() + 1);
            if (locale == null && collection.contains(locale = Locale.getDefault())) {
                locale = Locale.ROOT;
            }
            collection2.add(locale);
            collection2.addAll(collection);
        }
        return collection2;
    }

    public static <T> Collection<T> setFirst(Collection<T> collection, T t) {
        if (collection == null) {
            return LegacyPropertyAdapter.asCollection(t);
        }
        if (t == null) {
            Iterator<T> iterator = collection.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        } else if (collection.isEmpty()) {
            collection.add(t);
        } else {
            if (!(collection instanceof List)) {
                collection = new ArrayList<T>(collection);
            }
            ((List)collection).set(0, t);
        }
        return collection;
    }
}

