/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sis.internal.jdk8.BiFunction;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.metadata.CacheKey;
import org.apache.sis.metadata.IndexMap;
import org.apache.sis.metadata.InformationMap;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.NameMap;
import org.apache.sis.metadata.ObjectPair;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.RecursivityGuard;
import org.apache.sis.metadata.SpecialCases;
import org.apache.sis.metadata.StandardImplementation;
import org.apache.sis.metadata.TreeTableView;
import org.apache.sis.metadata.TypeMap;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.ValueMap;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.Citation;

public class MetadataStandard
implements Serializable {
    private static final long serialVersionUID = 7549790450195184843L;
    static final boolean IMPLEMENTATION_CAN_ALTER_API = true;
    private static final MetadataStandard[] INSTANCES;
    public static final MetadataStandard ISO_19111;
    public static final MetadataStandard ISO_19115;
    public static final MetadataStandard ISO_19123;
    final Citation citation;
    final String interfacePackage;
    private final MetadataStandard[] dependencies;
    private final transient ConcurrentMap<CacheKey, Object> accessors;

    public MetadataStandard(Citation citation, Package package_, MetadataStandard ... metadataStandardArray) {
        ArgumentChecks.ensureNonNull((String)"citation", (Object)citation);
        ArgumentChecks.ensureNonNull((String)"interfacePackage", (Object)package_);
        ArgumentChecks.ensureNonNull((String)"dependencies", (Object)metadataStandardArray);
        this.citation = citation;
        this.interfacePackage = package_.getName() + '.';
        this.accessors = new ConcurrentHashMap<CacheKey, Object>();
        if (metadataStandardArray.length == 0) {
            this.dependencies = null;
        } else {
            metadataStandardArray = (MetadataStandard[])metadataStandardArray.clone();
            this.dependencies = metadataStandardArray;
            for (int i = 0; i < metadataStandardArray.length; ++i) {
                ArgumentChecks.ensureNonNullElement((String)"dependencies", (int)i, (Object)metadataStandardArray[i]);
            }
        }
    }

    MetadataStandard(String string, String string2, MetadataStandard[] metadataStandardArray) {
        this.citation = new SimpleCitation(string);
        this.interfacePackage = string2;
        this.accessors = new ConcurrentHashMap<CacheKey, Object>();
        this.dependencies = metadataStandardArray;
    }

    final boolean isSupported(String string) {
        return string.startsWith(this.interfacePackage);
    }

    public static MetadataStandard forClass(Class<?> clazz) {
        String string = clazz.getName();
        for (MetadataStandard serializable : INSTANCES) {
            if (!serializable.isSupported(string)) continue;
            return serializable;
        }
        for (Serializable serializable : Classes.getAllInterfaces(clazz)) {
            string = ((Class)serializable).getName();
            for (MetadataStandard metadataStandard : INSTANCES) {
                if (!metadataStandard.isSupported(string)) continue;
                return metadataStandard;
            }
        }
        return null;
    }

    static void clearCache() {
        for (MetadataStandard metadataStandard : INSTANCES) {
            metadataStandard.accessors.clear();
        }
    }

    public Citation getCitation() {
        return this.citation;
    }

    final PropertyAccessor getAccessor(CacheKey cacheKey, boolean bl) {
        Class<?> clazz;
        Object v = this.accessors.get(cacheKey);
        if (v instanceof PropertyAccessor) {
            return (PropertyAccessor)v;
        }
        if (v instanceof Class) {
            clazz = (Class<?>)v;
            assert (clazz == this.findInterface(cacheKey)) : cacheKey;
        } else if (cacheKey.isValid()) {
            clazz = this.findInterface(cacheKey);
            if (clazz == null) {
                if (this.dependencies != null) {
                    for (MetadataStandard metadataStandard : this.dependencies) {
                        PropertyAccessor propertyAccessor = metadataStandard.getAccessor(cacheKey, false);
                        if (propertyAccessor == null) continue;
                        this.accessors.put(cacheKey, propertyAccessor);
                        return propertyAccessor;
                    }
                }
                if (bl) {
                    throw new ClassCastException(cacheKey.unrecognized());
                }
                return null;
            }
        } else {
            throw new ClassCastException(cacheKey.invalid());
        }
        return (PropertyAccessor)JDK8.compute(this.accessors, (Object)cacheKey, (BiFunction)new BiFunction<CacheKey, Object, Object>(){

            public Object apply(CacheKey cacheKey, Object object) {
                if (object instanceof PropertyAccessor) {
                    return object;
                }
                Class clazz2 = MetadataStandard.this.getImplementation(clazz);
                PropertyAccessor propertyAccessor = SpecialCases.isSpecialCase(clazz) ? new SpecialCases(MetadataStandard.this.citation, clazz, cacheKey.type, clazz2) : new PropertyAccessor(MetadataStandard.this.citation, clazz, cacheKey.type, clazz2);
                return propertyAccessor;
            }
        });
    }

    public boolean isMetadata(Class<?> clazz) {
        return clazz != null && !clazz.isPrimitive() && this.isMetadata(new CacheKey(clazz));
    }

    private boolean isMetadata(CacheKey cacheKey) {
        Object object;
        assert (cacheKey.isValid()) : cacheKey;
        if (this.accessors.containsKey(cacheKey)) {
            return true;
        }
        if (this.dependencies != null) {
            object = this.dependencies;
            int n = ((MetadataStandard[])object).length;
            for (int i = 0; i < n; ++i) {
                MetadataStandard metadataStandard = object[i];
                if (!metadataStandard.isMetadata(cacheKey)) continue;
                this.accessors.putIfAbsent(cacheKey, metadataStandard);
                return true;
            }
        }
        if ((object = this.findInterface(cacheKey)) != null) {
            this.accessors.putIfAbsent(cacheKey, object);
            return true;
        }
        return false;
    }

    boolean isPendingAPI(Class<?> clazz) {
        return false;
    }

    private Class<?> findInterface(CacheKey cacheKey) {
        assert (cacheKey.isValid()) : cacheKey;
        if (cacheKey.type.isInterface()) {
            if (this.isSupported(cacheKey.type.getName())) {
                return cacheKey.type;
            }
        } else {
            Class clazz;
            Iterator iterator;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (iterator = cacheKey.type; iterator != null; iterator = ((Class)((Object)iterator)).getSuperclass()) {
                this.getInterfaces((Class<?>)((Object)iterator), cacheKey.propertyType, linkedHashSet);
            }
            iterator = linkedHashSet.iterator();
            block1: while (iterator.hasNext()) {
                clazz = (Class)iterator.next();
                for (Class clazz2 : linkedHashSet) {
                    if (clazz == clazz2 || !clazz.isAssignableFrom(clazz2)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            iterator = linkedHashSet.iterator();
            if (iterator.hasNext()) {
                clazz = (Class)iterator.next();
                if (!iterator.hasNext()) {
                    return clazz;
                }
            } else if (this.isPendingAPI(cacheKey.type)) {
                return cacheKey.type;
            }
        }
        return null;
    }

    private void getInterfaces(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection) {
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            if (!clazz2.isAssignableFrom(clazz3)) continue;
            if (this.isSupported(clazz3.getName())) {
                collection.add(clazz3);
            }
            this.getInterfaces(clazz3, clazz2, collection);
        }
    }

    public <T> Class<? super T> getInterface(Class<T> clazz) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        return this.getInterface(new CacheKey(clazz));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <T> Class<? super T> getInterface(CacheKey cacheKey) throws ClassCastException {
        void var2_7;
        Object v = this.accessors.get(cacheKey);
        if (v instanceof PropertyAccessor) {
            Class<?> clazz = ((PropertyAccessor)v).type;
        } else if (v instanceof Class) {
            Class clazz = (Class)v;
        } else if (v instanceof MetadataStandard) {
            Class<T> clazz = ((MetadataStandard)v).getInterface(cacheKey);
        } else {
            if (!cacheKey.isValid()) throw new ClassCastException(cacheKey.invalid());
            Class<?> clazz = this.findInterface(cacheKey);
            if (clazz != null) {
                this.accessors.putIfAbsent(cacheKey, clazz);
            } else {
                if (this.dependencies == null) throw new ClassCastException(cacheKey.unrecognized());
                for (MetadataStandard metadataStandard : this.dependencies) {
                    if (!metadataStandard.isMetadata(cacheKey)) continue;
                    this.accessors.putIfAbsent(cacheKey, metadataStandard);
                    return metadataStandard.getInterface(cacheKey);
                }
                throw new ClassCastException(cacheKey.unrecognized());
            }
        }
        assert (var2_7.isAssignableFrom(cacheKey.type)) : cacheKey;
        return var2_7;
    }

    public <T> Class<? extends T> getImplementation(Class<T> clazz) {
        return null;
    }

    public Map<String, String> asNameMap(Class<?> clazz, KeyNamePolicy keyNamePolicy, KeyNamePolicy keyNamePolicy2) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"keyPolicy", (Object)((Object)keyNamePolicy));
        ArgumentChecks.ensureNonNull((String)"valuePolicy", (Object)((Object)keyNamePolicy2));
        Class<?> clazz2 = this.getImplementation(clazz);
        if (clazz2 != null) {
            clazz = clazz2;
        }
        return new NameMap(this.getAccessor(new CacheKey(clazz), true), keyNamePolicy, keyNamePolicy2);
    }

    public Map<String, Class<?>> asTypeMap(Class<?> clazz, KeyNamePolicy keyNamePolicy, TypeValuePolicy typeValuePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"keyPolicy", (Object)((Object)keyNamePolicy));
        ArgumentChecks.ensureNonNull((String)"valuePolicy", (Object)((Object)typeValuePolicy));
        Class<?> clazz2 = this.getImplementation(clazz);
        if (clazz2 != null) {
            clazz = clazz2;
        }
        return new TypeMap(this.getAccessor(new CacheKey(clazz), true), keyNamePolicy, typeValuePolicy);
    }

    public Map<String, ExtendedElementInformation> asInformationMap(Class<?> clazz, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"keyNames", (Object)((Object)keyNamePolicy));
        Class<?> clazz2 = this.getImplementation(clazz);
        if (clazz2 != null) {
            clazz = clazz2;
        }
        return new InformationMap(this.getAccessor(new CacheKey(clazz), true), keyNamePolicy);
    }

    public Map<String, Integer> asIndexMap(Class<?> clazz, KeyNamePolicy keyNamePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        ArgumentChecks.ensureNonNull((String)"keyPolicy", (Object)((Object)keyNamePolicy));
        Class<?> clazz2 = this.getImplementation(clazz);
        if (clazz2 != null) {
            clazz = clazz2;
        }
        return new IndexMap(this.getAccessor(new CacheKey(clazz), true), keyNamePolicy);
    }

    public Map<String, Object> asValueMap(Object object, Class<?> clazz, KeyNamePolicy keyNamePolicy, ValueExistencePolicy valueExistencePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"metadata", (Object)object);
        ArgumentChecks.ensureNonNull((String)"keyPolicy", (Object)((Object)keyNamePolicy));
        ArgumentChecks.ensureNonNull((String)"valuePolicy", (Object)((Object)valueExistencePolicy));
        return new ValueMap(object, this.getAccessor(new CacheKey(object.getClass(), clazz), true), keyNamePolicy, valueExistencePolicy);
    }

    @Deprecated
    public Map<String, Object> asValueMap(Object object, KeyNamePolicy keyNamePolicy, ValueExistencePolicy valueExistencePolicy) throws ClassCastException {
        return this.asValueMap(object, null, keyNamePolicy, valueExistencePolicy);
    }

    public TreeTable asTreeTable(Object object, Class<?> clazz, ValueExistencePolicy valueExistencePolicy) throws ClassCastException {
        ArgumentChecks.ensureNonNull((String)"metadata", (Object)object);
        ArgumentChecks.ensureNonNull((String)"valuePolicy", (Object)((Object)valueExistencePolicy));
        if (clazz == null) {
            clazz = this.getInterface(object.getClass());
        }
        return new TreeTableView(this, object, clazz, valueExistencePolicy);
    }

    @Deprecated
    public TreeTable asTreeTable(Object object, ValueExistencePolicy valueExistencePolicy) throws ClassCastException {
        return this.asTreeTable(object, null, valueExistencePolicy);
    }

    final void freeze(Object object) throws ClassCastException {
        this.getAccessor(new CacheKey(object.getClass()), true).freeze(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object, Object object2, ComparisonMode comparisonMode) throws ClassCastException {
        Class<?> clazz;
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz2 != (clazz = object2.getClass()) && comparisonMode == ComparisonMode.STRICT) {
            return false;
        }
        PropertyAccessor propertyAccessor = this.getAccessor(new CacheKey(clazz2), true);
        if (!(clazz2 == clazz || propertyAccessor.type.isAssignableFrom(clazz) && propertyAccessor.type == this.getAccessor((CacheKey)new CacheKey(clazz), (boolean)false).type)) {
            return false;
        }
        ObjectPair objectPair = new ObjectPair(object, object2);
        Set<ObjectPair> set = ObjectPair.CURRENT.get();
        if (set.add(objectPair)) {
            boolean bl = Semaphores.queryAndSet((int)1);
            try {
                boolean bl2 = propertyAccessor.equals(object, object2, comparisonMode);
                return bl2;
            }
            finally {
                set.remove(objectPair);
                if (!bl) {
                    Semaphores.clear((int)1);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode(Object object) throws ClassCastException {
        Map map;
        if (object != null && (map = (Map)RecursivityGuard.HASH_CODES.get()).put(object, Boolean.TRUE) == null) {
            boolean bl = Semaphores.queryAndSet((int)1);
            try {
                int n = this.getAccessor(new CacheKey(object.getClass()), true).hashCode(object);
                return n;
            }
            finally {
                map.remove(object);
                if (!bl) {
                    Semaphores.clear((int)1);
                }
            }
        }
        return 0;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.citation.getTitle() + ']';
    }

    final void setMapForField(Class<?> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            field.set(this, new ConcurrentHashMap());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setMapForField(MetadataStandard.class, "accessors");
    }

    static {
        String[] stringArray = new String[]{"Default", "Abstract"};
        String[] stringArray2 = new String[]{"CoordinateSystem", "CS", "CoordinateReferenceSystem", "CRS"};
        ISO_19115 = new StandardImplementation("ISO 19115", "org.opengis.metadata.", "org.apache.sis.metadata.iso.", stringArray, null, null);
        ISO_19111 = new StandardImplementation("ISO 19111", "org.opengis.referencing.", "org.apache.sis.referencing.", stringArray, stringArray2, new MetadataStandard[]{ISO_19115});
        ISO_19123 = new MetadataStandard("ISO 19123", "org.opengis.coverage.", new MetadataStandard[]{ISO_19111});
        INSTANCES = new MetadataStandard[]{ISO_19111, ISO_19115, ISO_19123};
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.metadata"){

            protected void classpathChanged() {
                MetadataStandard.clearCache();
            }
        });
    }
}

