/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.TreeNode;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;

final class TreeTableView
implements TreeTable,
Serializable {
    private static final long serialVersionUID = 3911016927808764394L;
    static final List<TableColumn<?>> COLUMNS = UnmodifiableArrayList.wrap((Object[])new TableColumn[]{TableColumn.IDENTIFIER, TableColumn.INDEX, TableColumn.NAME, TableColumn.TYPE, TableColumn.VALUE});
    private static Format format;
    private transient TreeNode root;
    final MetadataStandard standard;
    final ValueExistencePolicy valuePolicy;

    TreeTableView(MetadataStandard metadataStandard, Object object, Class<?> clazz, ValueExistencePolicy valueExistencePolicy) {
        this.standard = metadataStandard;
        this.valuePolicy = valueExistencePolicy;
        this.root = new TreeNode(this, object, clazz);
    }

    public List<TableColumn<?>> getColumns() {
        return COLUMNS;
    }

    public TreeTable.Node getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Class<TreeTableView> clazz = TreeTableView.class;
        synchronized (TreeTableView.class) {
            String string;
            block8: {
                if (format == null) {
                    TreeTableFormat treeTableFormat = new TreeTableFormat(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
                    treeTableFormat.setColumns(new TableColumn[]{TableColumn.NAME, TableColumn.VALUE});
                    format = treeTableFormat;
                }
                boolean bl = Semaphores.queryAndSet((int)1);
                try {
                    string = format.format(this);
                    if (bl) break block8;
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        Semaphores.clear((int)1);
                    }
                    throw throwable;
                }
                Semaphores.clear((int)1);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return string;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.root.baseType);
        objectOutputStream.writeObject(this.root.metadata);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Class clazz = (Class)objectInputStream.readObject();
        this.root = new TreeNode(this, objectInputStream.readObject(), clazz);
    }
}

