/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.util.InternationalString;

@XmlType(name="MD_MetadataScope_Type", propOrder={"resourceScope", "name"})
@XmlRootElement(name="MD_MetadataScope")
@UML(identifier="MD_MetadataScope", specification=Specification.ISO_19115)
public class DefaultMetadataScope
extends ISOMetadata {
    private static final long serialVersionUID = -7186722085106176683L;
    private ScopeCode resourceScope;
    private InternationalString name;

    public DefaultMetadataScope() {
    }

    public DefaultMetadataScope(ScopeCode scopeCode, CharSequence charSequence) {
        this.resourceScope = scopeCode;
        this.name = Types.toInternationalString((CharSequence)charSequence);
    }

    public DefaultMetadataScope(DefaultMetadataScope defaultMetadataScope) {
        super(defaultMetadataScope);
        if (defaultMetadataScope != null) {
            this.resourceScope = defaultMetadataScope.getResourceScope();
            this.name = defaultMetadataScope.getName();
        }
    }

    @XmlElement(name="resourceScope", required=true)
    @UML(identifier="resourceScope", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public ScopeCode getResourceScope() {
        return this.resourceScope;
    }

    public void setResourceScope(ScopeCode scopeCode) {
        this.checkWritePermission();
        this.resourceScope = scopeCode;
    }

    @XmlElement(name="name")
    @UML(identifier="name", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString internationalString) {
        this.checkWritePermission();
        this.name = internationalString;
    }
}

