/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.acquisition.EnvironmentalRecord;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.Operation;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.acquisition.Requirement;

@XmlType(name="MI_AcquisitionInformation_Type", propOrder={"acquisitionPlans", "acquisitionRequirements", "environmentalConditions", "instruments", "objectives", "operations", "platforms"})
@XmlRootElement(name="MI_AcquisitionInformation")
public class DefaultAcquisitionInformation
extends ISOMetadata
implements AcquisitionInformation {
    private static final long serialVersionUID = 6115581617356679324L;
    private Collection<Plan> acquisitionPlans;
    private Collection<Requirement> acquisitionRequirements;
    private EnvironmentalRecord environmentalConditions;
    private Collection<Instrument> instruments;
    private Collection<Objective> objectives;
    private Collection<Operation> operations;
    private Collection<Platform> platforms;

    public DefaultAcquisitionInformation() {
    }

    public DefaultAcquisitionInformation(AcquisitionInformation acquisitionInformation) {
        super(acquisitionInformation);
        if (acquisitionInformation != null) {
            this.acquisitionPlans = this.copyCollection(acquisitionInformation.getAcquisitionPlans(), Plan.class);
            this.acquisitionRequirements = this.copyCollection(acquisitionInformation.getAcquisitionRequirements(), Requirement.class);
            this.environmentalConditions = acquisitionInformation.getEnvironmentalConditions();
            this.instruments = this.copyCollection(acquisitionInformation.getInstruments(), Instrument.class);
            this.objectives = this.copyCollection(acquisitionInformation.getObjectives(), Objective.class);
            this.operations = this.copyCollection(acquisitionInformation.getOperations(), Operation.class);
            this.platforms = this.copyCollection(acquisitionInformation.getPlatforms(), Platform.class);
        }
    }

    public static DefaultAcquisitionInformation castOrCopy(AcquisitionInformation acquisitionInformation) {
        if (acquisitionInformation == null || acquisitionInformation instanceof DefaultAcquisitionInformation) {
            return (DefaultAcquisitionInformation)acquisitionInformation;
        }
        return new DefaultAcquisitionInformation(acquisitionInformation);
    }

    @XmlElement(name="acquisitionPlan")
    public Collection<Plan> getAcquisitionPlans() {
        this.acquisitionPlans = this.nonNullCollection(this.acquisitionPlans, Plan.class);
        return this.acquisitionPlans;
    }

    public void setAcquisitionPlans(Collection<? extends Plan> collection) {
        this.acquisitionPlans = this.writeCollection(collection, this.acquisitionPlans, Plan.class);
    }

    @XmlElement(name="acquisitionRequirement")
    public Collection<Requirement> getAcquisitionRequirements() {
        this.acquisitionRequirements = this.nonNullCollection(this.acquisitionRequirements, Requirement.class);
        return this.acquisitionRequirements;
    }

    public void setAcquisitionRequirements(Collection<? extends Requirement> collection) {
        this.acquisitionRequirements = this.writeCollection(collection, this.acquisitionRequirements, Requirement.class);
    }

    @XmlElement(name="environmentalConditions")
    public EnvironmentalRecord getEnvironmentalConditions() {
        return this.environmentalConditions;
    }

    public void setEnvironmentalConditions(EnvironmentalRecord environmentalRecord) {
        this.checkWritePermission();
        this.environmentalConditions = environmentalRecord;
    }

    @XmlElement(name="instrument")
    public Collection<Instrument> getInstruments() {
        this.instruments = this.nonNullCollection(this.instruments, Instrument.class);
        return this.instruments;
    }

    public void setInstruments(Collection<? extends Instrument> collection) {
        this.instruments = this.writeCollection(collection, this.instruments, Instrument.class);
    }

    @XmlElement(name="objective")
    public Collection<Objective> getObjectives() {
        this.objectives = this.nonNullCollection(this.objectives, Objective.class);
        return this.objectives;
    }

    public void setObjectives(Collection<? extends Objective> collection) {
        this.objectives = this.writeCollection(collection, this.objectives, Objective.class);
    }

    @XmlElement(name="operation")
    public Collection<Operation> getOperations() {
        this.operations = this.nonNullCollection(this.operations, Operation.class);
        return this.operations;
    }

    public void setOperations(Collection<? extends Operation> collection) {
        this.operations = this.writeCollection(collection, this.operations, Operation.class);
    }

    @XmlElement(name="platform")
    public Collection<Platform> getPlatforms() {
        this.platforms = this.nonNullCollection(this.platforms, Platform.class);
        return this.platforms;
    }

    public void setPlatforms(Collection<? extends Platform> collection) {
        this.platforms = this.writeCollection(collection, this.platforms, Platform.class);
    }
}

