/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.measure.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultRangeDimension;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="MD_SampleDimension_Type", propOrder={"maxValue", "minValue", "units"})
@XmlRootElement(name="MD_SampleDimension")
@XmlSeeAlso(value={DefaultBand.class, DefaultRangeDimension.class})
@UML(identifier="MD_SampleDimension", specification=Specification.ISO_19115)
public class DefaultSampleDimension
extends DefaultRangeDimension {
    private static final long serialVersionUID = 4517148689016920767L;
    private Integer numberOfValues;
    private Double minValue;
    private Double maxValue;
    private Double meanValue;
    private Double standardDeviation;
    private Unit<?> units;
    private Double scaleFactor;
    private Double offset;
    private TransferFunctionType transferFunctionType;
    private Integer bitsPerValue;
    private Double nominalSpatialResolution;
    private RecordType otherPropertyType;
    private Record otherProperty;

    public DefaultSampleDimension() {
    }

    public DefaultSampleDimension(DefaultSampleDimension defaultSampleDimension) {
        super(defaultSampleDimension);
        if (defaultSampleDimension != null) {
            this.init(defaultSampleDimension);
        }
    }

    private void init(DefaultSampleDimension defaultSampleDimension) {
        this.minValue = defaultSampleDimension.getMinValue();
        this.maxValue = defaultSampleDimension.getMaxValue();
        this.meanValue = defaultSampleDimension.getMeanValue();
        this.numberOfValues = defaultSampleDimension.getNumberOfValues();
        this.standardDeviation = defaultSampleDimension.getStandardDeviation();
        this.units = defaultSampleDimension.getUnits();
        this.scaleFactor = defaultSampleDimension.getScaleFactor();
        this.offset = defaultSampleDimension.getOffset();
        this.transferFunctionType = defaultSampleDimension.getTransferFunctionType();
        this.bitsPerValue = defaultSampleDimension.getBitsPerValue();
        this.nominalSpatialResolution = defaultSampleDimension.getNominalSpatialResolution();
        this.otherPropertyType = defaultSampleDimension.getOtherPropertyType();
        this.otherProperty = defaultSampleDimension.getOtherProperty();
    }

    DefaultSampleDimension(Band band) {
        super((RangeDimension)band);
        if (band != null) {
            if (band instanceof DefaultSampleDimension) {
                this.init((DefaultSampleDimension)band);
            } else {
                this.maxValue = band.getMaxValue();
                this.minValue = band.getMinValue();
                this.units = band.getUnits();
                this.scaleFactor = band.getScaleFactor();
                this.offset = band.getOffset();
                this.bitsPerValue = band.getBitsPerValue();
            }
        }
    }

    @ValueRange(minimum=0.0)
    @UML(identifier="numberOfValues", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Integer getNumberOfValues() {
        return this.numberOfValues;
    }

    public void setNumberOfValues(Integer n) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultSampleDimension.class, "numberOfValues", false, n)) {
            this.numberOfValues = n;
        }
    }

    @XmlElement(name="minValue")
    @UML(identifier="minValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Double d) {
        this.checkWritePermission();
        this.minValue = d;
    }

    @XmlElement(name="maxValue")
    @UML(identifier="maxValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Double d) {
        this.checkWritePermission();
        this.maxValue = d;
    }

    @UML(identifier="meanValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getMeanValue() {
        return this.meanValue;
    }

    public void setMeanValue(Double d) {
        this.checkWritePermission();
        this.meanValue = d;
    }

    @UML(identifier="standardDeviation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(Double d) {
        this.checkWritePermission();
        this.standardDeviation = d;
    }

    @XmlElement(name="units")
    @UML(identifier="units", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Unit<?> getUnits() {
        return this.units;
    }

    public void setUnits(Unit<?> unit) {
        this.checkWritePermission();
        this.units = unit;
    }

    @UML(identifier="scaleFactor", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Double d) {
        this.checkWritePermission();
        this.scaleFactor = d;
    }

    @UML(identifier="offset", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double d) {
        this.checkWritePermission();
        this.offset = d;
    }

    public TransferFunctionType getTransferFunctionType() {
        return this.transferFunctionType;
    }

    public void setTransferFunctionType(TransferFunctionType transferFunctionType) {
        this.checkWritePermission();
        this.transferFunctionType = transferFunctionType;
    }

    @ValueRange(minimum=1.0)
    @UML(identifier="bitsPerValue", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Integer getBitsPerValue() {
        return this.bitsPerValue;
    }

    public void setBitsPerValue(Integer n) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultSampleDimension.class, "bitsPerValue", true, n)) {
            this.bitsPerValue = n;
        }
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getNominalSpatialResolution() {
        return this.nominalSpatialResolution;
    }

    public void setNominalSpatialResolution(Double d) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultSampleDimension.class, "nominalSpatialResolution", true, d)) {
            this.nominalSpatialResolution = d;
        }
    }

    @UML(identifier="otherPropertyType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public RecordType getOtherPropertyType() {
        return this.otherPropertyType;
    }

    public void setOtherPropertyType(RecordType recordType) {
        this.checkWritePermission();
        this.otherPropertyType = recordType;
    }

    @UML(identifier="otherProperty", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Record getOtherProperty() {
        return this.otherProperty;
    }

    public void setOtherProperty(Record record) {
        this.checkWritePermission();
        this.otherProperty = record;
    }
}

