/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u001dg\u0001\u0002%J\u0001YC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005O\")a\u000e\u0001C\u0001_\u001a!1\u000f\u0001\u0003u\u0011!)HA!a\u0001\n\u00031\b\u0002\u0003>\u0005\u0005\u0003\u0007I\u0011A>\t\u0013\u0005\rAA!A!B\u00139\bB\u00028\u0005\t\u0003\t)\u0001C\u0005\u0002\u000e\u0011\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011Q\u0007\u0003!\u0002\u0013\t\tB\u0002\u0004\u00028\u0001!\u0011\u0011\b\u0005\u000b\u0003wY!\u00111A\u0005\u0002\u0005u\u0002BCA#\u0017\t\u0005\r\u0011\"\u0001\u0002H!Q\u00111J\u0006\u0003\u0002\u0003\u0006K!a\u0010\t\r9\\A\u0011AA'\u0011%\t\u0019f\u0003b\u0001\n\u0003\t)\u0006\u0003\u0005\u0002p-\u0001\u000b\u0011BA,\u0011%\t\th\u0003b\u0001\n\u0003\t\u0019\b\u0003\u0005\u0002~-\u0001\u000b\u0011BA;\u0011!Q\u0005A1A\u0005\n\u0005}\u0004\u0002CAB\u0001\u0001\u0006I!!!\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBAP\u0001\u0011%\u0011\u0011\u0015\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\t9\r\u0001C!\u0003\u0013Dq!a5\u0001\t\u0003\n)\u000eC\u0004\u0002b\u0002!\t%a9\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u0011Q\u001e\u0001\u0005B\u0005=\bbBAz\u0001\u0011\u0005\u0013Q\u001f\u0005\b\u0003g\u0004A\u0011IA}\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqA!\u0002\u0001\t\u0003\u00129\u0001C\u0004\u0003\u0010\u0001!\tE!\u0005\t\u000f\tu\u0001\u0001\"\u0011\u0003 !9!1\u0006\u0001\u0005B\t5\u0002b\u0002B\u0019\u0001\u0011\u0005#1\u0007\u0005\b\u0005\u0013\u0002A\u0011\tB&\u0011\u001d\u0011\t\u0007\u0001C!\u0005GBqA!\u001b\u0001\t\u0003\u0012Y\u0007C\u0004\u0003t\u0001!\tE!\u001e\t\u000f\tm\u0004\u0001\"\u0011\u0003~!9!1\u0010\u0001\u0005B\t\u0005\u0005b\u0002BD\u0001\u0011\u0005#\u0011\u0012\u0005\b\u0005\u001f\u0003A\u0011\tBI\u0011\u001d\u0011\u0019\u000b\u0001C!\u0005KCqA!/\u0001\t\u0003\u0012Y\fC\u0004\u0003T\u0002!\tE!6\t\u000f\t\r\b\u0001\"\u0011\u0003f\"9!q\u001f\u0001\u0005B\te\bbBB\u0003\u0001\u0011\u00053q\u0001\u0005\b\u0007\u001f\u0001A\u0011IB\t\u0011\u001d\u0019I\u0002\u0001C!\u00077Aqa!\n\u0001\t\u0003\u001a9\u0003C\u0005\u00044\u0001\t\n\u0011\"\u0001\u00046!911\n\u0001\u0005B\r5\u0003\"CB+\u0001E\u0005I\u0011AB\u001b\u0011\u001d\u00199\u0006\u0001C!\u00073Bqa!\u001e\u0001\t\u0003\u001a9\bC\u0004\u0004\u0000\u0001!\te!!\t\u000f\r%\u0005\u0001\"\u0011\u0004\f\"91\u0011\u0013\u0001\u0005B\rM\u0005bBBN\u0001\u0011\u00053Q\u0014\u0005\b\u0007G\u0003A\u0011IBS\u0011\u001d\u0019Y\u000b\u0001C!\u0007[;\u0011ba-J\u0003\u0003E\ta!.\u0007\u0011!K\u0015\u0011!E\u0001\u0007oCaA\u001c#\u0005\u0002\re\u0006\"CB^\tF\u0005I\u0011AB_\u0011%\u0019\t\rRI\u0001\n\u0003\u0019\u0019MA\bJ]6+Wn\u001c:z\u0007\u0006$\u0018\r\\8h\u0015\tQ5*A\u0004dCR\fGn\\4\u000b\u00051k\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00059{\u0015aA:rY*\u0011\u0001+U\u0001\u0006gB\f'o\u001b\u0006\u0003%N\u000ba!\u00199bG\",'\"\u0001+\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019V\f\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016L\u0001\u0004B]f\u0014VM\u001a\t\u0003=~k\u0011!S\u0005\u0003A&\u0013q\"\u0012=uKJt\u0017\r\\\"bi\u0006dwnZ\u0001\u0005G>tg\r\u0005\u0002dI6\tq*\u0003\u0002f\u001f\nI1\u000b]1sW\u000e{gNZ\u0001\rQ\u0006$wn\u001c9D_:4\u0017n\u001a\t\u0003Q2l\u0011!\u001b\u0006\u0003C*T!a[)\u0002\r!\fGm\\8q\u0013\ti\u0017NA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\f(\u000f\u0005\u0002_\u0001!9\u0011m\u0001I\u0001\u0002\u0004\u0011\u0007b\u00024\u0004!\u0003\u0005\ra\u001a\u0002\n)\u0006\u0014G.\u001a#fg\u000e\u001c\"\u0001B,\u0002\u000bQ\f'\r\\3\u0016\u0003]\u0004\"A\u0018=\n\u0005eL%\u0001D\"bi\u0006dwn\u001a+bE2,\u0017!\u0003;bE2,w\fJ3r)\tax\u0010\u0005\u0002Y{&\u0011a0\u0017\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0002\u0019\t\t\u00111\u0001x\u0003\rAH%M\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0015\t\u0005\u001d\u00111\u0002\t\u0004\u0003\u0013!Q\"\u0001\u0001\t\u000bUD\u0001\u0019A<\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0002\u0012AA\u00111CA\u000f\u0003C\ty#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u001diW\u000f^1cY\u0016T1!a\u0007Z\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\t)BA\u0004ICNDW*\u00199\u0011\t\u0005\r\u0012\u0011\u0006\b\u0004=\u0006\u0015\u0012bAA\u0014\u0013\u0006a1)\u0019;bY><G+\u001f9fg&!\u00111FA\u0017\u0005I!\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u000b\u0007\u0005\u001d\u0012\nE\u0002_\u0003cI1!a\rJ\u0005U\u0019\u0015\r^1m_\u001e$\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\f1\u0002]1si&$\u0018n\u001c8tA\taA)\u0019;bE\u0006\u001cX\rR3tGN\u00111bV\u0001\u0003I\n,\"!a\u0010\u0011\u0007y\u000b\t%C\u0002\u0002D%\u0013qbQ1uC2|w\rR1uC\n\f7/Z\u0001\u0007I\n|F%Z9\u0015\u0007q\fI\u0005C\u0005\u0002\u00025\t\t\u00111\u0001\u0002@\u0005\u0019AM\u0019\u0011\u0015\t\u0005=\u0013\u0011\u000b\t\u0004\u0003\u0013Y\u0001bBA\u001e\u001f\u0001\u0007\u0011qH\u0001\u0007i\u0006\u0014G.Z:\u0016\u0005\u0005]\u0003\u0003CA\n\u0003;\tI&a\u0002\u0011\t\u0005m\u0013\u0011\u000e\b\u0005\u0003;\n)\u0007E\u0002\u0002`ek!!!\u0019\u000b\u0007\u0005\rT+\u0001\u0004=e>|GOP\u0005\u0004\u0003OJ\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002l\u00055$AB*ue&twMC\u0002\u0002he\u000bq\u0001^1cY\u0016\u001c\b%A\u0005gk:\u001cG/[8ogV\u0011\u0011Q\u000f\t\t\u0003'\ti\"!\u0017\u0002xA\u0019a,!\u001f\n\u0007\u0005m\u0014JA\bDCR\fGn\\4Gk:\u001cG/[8o\u0003)1WO\\2uS>t7\u000fI\u000b\u0003\u0003\u0003\u0003\u0002\"a\u0005\u0002\u001e\u0005e\u0013qJ\u0001\tG\u0006$\u0018\r\\8hA\u0005y\u0001/\u0019:uSRLwN\\#ySN$8\u000f\u0006\u0005\u0002\n\u0006=\u0015\u0011SAJ!\rA\u00161R\u0005\u0004\u0003\u001bK&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003w1\u0002\u0019AA-\u0011\u0019)h\u00031\u0001\u0002Z!9\u0011Q\u0013\fA\u0002\u0005\u0005\u0012\u0001B:qK\u000e\fQC]3rk&\u0014X\rV1cY\u0016tu\u000e^#ySN$8\u000fF\u0003}\u00037\u000bi\nC\u0004\u0002<]\u0001\r!!\u0017\t\rU<\u0002\u0019AA-\u0003Y\u0011X-];je\u0016\u0004\u0016M\u001d;ji&|gn]#ySN$Hc\u0002?\u0002$\u0006\u0015\u0016q\u0015\u0005\b\u0003wA\u0002\u0019AA-\u0011\u0019)\b\u00041\u0001\u0002Z!9\u0011\u0011\u0016\rA\u0002\u0005-\u0016!B:qK\u000e\u001c\bCBAW\u0003o\u000b\tC\u0004\u0003\u00020\u0006Mf\u0002BA0\u0003cK\u0011AW\u0005\u0004\u0003kK\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003s\u000bYLA\u0002TKFT1!!.Z\u0003e\u0011X-];je\u0016\u0004\u0016M\u001d;ji&|gn\u001d(pi\u0016C\u0018n\u001d;\u0015\u000fq\f\t-a1\u0002F\"9\u00111H\rA\u0002\u0005e\u0003BB;\u001a\u0001\u0004\tI\u0006C\u0004\u0002*f\u0001\r!a+\u0002\u001d\r\u0014X-\u0019;f\t\u0006$\u0018MY1tKR)A0a3\u0002P\"9\u0011Q\u001a\u000eA\u0002\u0005}\u0012\u0001\u00043c\t\u00164\u0017N\\5uS>t\u0007bBAi5\u0001\u0007\u0011\u0011R\u0001\u000fS\u001etwN]3JM\u0016C\u0018n\u001d;t\u00031!'o\u001c9ECR\f'-Y:f)\u001da\u0018q[Am\u0003;Dq!a\u000f\u001c\u0001\u0004\tI\u0006C\u0004\u0002\\n\u0001\r!!#\u0002#%<gn\u001c:f\u0013\u001atu\u000e^#ySN$8\u000fC\u0004\u0002`n\u0001\r!!#\u0002\u000f\r\f7oY1eK\u0006i\u0011\r\u001c;fe\u0012\u000bG/\u00192bg\u0016$2\u0001`As\u0011\u001d\ti\r\ba\u0001\u0003\u007f\t1bZ3u\t\u0006$\u0018MY1tKR!\u0011qHAv\u0011\u001d\tY$\ba\u0001\u00033\na\u0002Z1uC\n\f7/Z#ySN$8\u000f\u0006\u0003\u0002\n\u0006E\bbBA\u001e=\u0001\u0007\u0011\u0011L\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0005\u0005]\bCBAW\u0003o\u000bI\u0006\u0006\u0003\u0002x\u0006m\bbBA\u007fA\u0001\u0007\u0011\u0011L\u0001\ba\u0006$H/\u001a:o\u0003I\u0019X\r^\"veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0015\u0007q\u0014\u0019\u0001C\u0004\u0002<\u0005\u0002\r!!\u0017\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0006y\n%!Q\u0002\u0005\u0007\u0005\u0017\u0011\u0003\u0019A<\u0002\u001fQ\f'\r\\3EK\u001aLg.\u001b;j_:Dq!!5#\u0001\u0004\tI)A\u0005ee>\u0004H+\u00192mKRIAPa\u0005\u0003\u0016\t]!\u0011\u0004\u0005\b\u0003w\u0019\u0003\u0019AA-\u0011\u0019)8\u00051\u0001\u0002Z!9\u00111\\\u0012A\u0002\u0005%\u0005b\u0002B\u000eG\u0001\u0007\u0011\u0011R\u0001\u0006aV\u0014x-Z\u0001\fe\u0016t\u0017-\\3UC\ndW\rF\u0004}\u0005C\u0011\u0019Ca\n\t\u000f\u0005mB\u00051\u0001\u0002Z!9!Q\u0005\u0013A\u0002\u0005e\u0013aB8mI:\u000bW.\u001a\u0005\b\u0005S!\u0003\u0019AA-\u0003\u001dqWm\u001e(b[\u0016\f!\"\u00197uKJ$\u0016M\u00197f)\ra(q\u0006\u0005\u0007\u0005\u0017)\u0003\u0019A<\u0002)\u0005dG/\u001a:UC\ndW\rR1uCN\u001b\u0007.Z7b)\u001da(Q\u0007B\u001c\u0005sAq!a\u000f'\u0001\u0004\tI\u0006\u0003\u0004vM\u0001\u0007\u0011\u0011\f\u0005\b\u0005w1\u0003\u0019\u0001B\u001f\u00035qWm\u001e#bi\u0006\u001c6\r[3nCB!!q\bB#\u001b\t\u0011\tEC\u0002\u0003D5\u000bQ\u0001^=qKNLAAa\u0012\u0003B\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001f\u0005dG/\u001a:UC\ndWm\u0015;biN$r\u0001 B'\u0005\u001f\u0012\t\u0006C\u0004\u0002<\u001d\u0002\r!!\u0017\t\rU<\u0003\u0019AA-\u0011\u001d\u0011\u0019f\na\u0001\u0005+\nQa\u001d;biN\u0004R\u0001\u0017B,\u00057J1A!\u0017Z\u0005\u0019y\u0005\u000f^5p]B\u0019aL!\u0018\n\u0007\t}\u0013JA\tDCR\fGn\\4Ti\u0006$\u0018n\u001d;jGN\f\u0001bZ3u)\u0006\u0014G.\u001a\u000b\u0006o\n\u0015$q\r\u0005\b\u0003wA\u0003\u0019AA-\u0011\u0019)\b\u00061\u0001\u0002Z\u0005yq-\u001a;UC\ndWm\u001d\"z\u001d\u0006lW\r\u0006\u0004\u0003n\t=$\u0011\u000f\t\u0006\u0003[\u000b9l\u001e\u0005\b\u0003wI\u0003\u0019AA-\u0011\u001d\t\u0019&\u000ba\u0001\u0003o\f1\u0002^1cY\u0016,\u00050[:ugR1\u0011\u0011\u0012B<\u0005sBq!a\u000f+\u0001\u0004\tI\u0006\u0003\u0004vU\u0001\u0007\u0011\u0011L\u0001\u000bY&\u001cH\u000fV1cY\u0016\u001cH\u0003BA|\u0005\u007fBq!a\u000f,\u0001\u0004\tI\u0006\u0006\u0004\u0002x\n\r%Q\u0011\u0005\b\u0003wa\u0003\u0019AA-\u0011\u001d\ti\u0010\fa\u0001\u00033\n\u0011\u0002\\5tiZKWm^:\u0015\r\u0005](1\u0012BG\u0011\u001d\tY$\fa\u0001\u00033Bq!!@.\u0001\u0004\tI&A\u0005m_\u0006$G+\u00192mKRYAPa%\u0003\u0016\n]%1\u0014BP\u0011\u001d\tYD\fa\u0001\u00033Ba!\u001e\u0018A\u0002\u0005e\u0003b\u0002BM]\u0001\u0007\u0011\u0011L\u0001\tY>\fG\rU1uQ\"9!Q\u0014\u0018A\u0002\u0005%\u0015aC5t\u001fZ,'o\u001e:ji\u0016DqA!)/\u0001\u0004\tI)\u0001\u0006jgN\u00138\rT8dC2\fQ\u0002\\8bIB\u000b'\u000f^5uS>tGc\u0004?\u0003(\n%&1\u0016BW\u0005c\u0013\u0019La.\t\u000f\u0005mr\u00061\u0001\u0002Z!1Qo\fa\u0001\u00033BqA!'0\u0001\u0004\tI\u0006C\u0004\u00030>\u0002\r!!\t\u0002\u0013A\f'\u000f^5uS>t\u0007b\u0002BO_\u0001\u0007\u0011\u0011\u0012\u0005\b\u0005k{\u0003\u0019AAE\u0003EIg\u000e[3sSR$\u0016M\u00197f'B,7m\u001d\u0005\b\u0005C{\u0003\u0019AAE\u0003Uaw.\u00193Es:\fW.[2QCJ$\u0018\u000e^5p]N$R\u0002 B_\u0005\u007f\u0013\tMa1\u0003F\n%\u0007bBA\u001ea\u0001\u0007\u0011\u0011\f\u0005\u0007kB\u0002\r!!\u0017\t\u000f\te\u0005\u00071\u0001\u0002Z!9!q\u0016\u0019A\u0002\u0005\u0005\u0002b\u0002Bda\u0001\u0007\u0011\u0011R\u0001\be\u0016\u0004H.Y2f\u0011\u001d\u0011Y\r\ra\u0001\u0005\u001b\fQA\\;n\tB\u00032\u0001\u0017Bh\u0013\r\u0011\t.\u0017\u0002\u0004\u0013:$\u0018\u0001E2sK\u0006$X\rU1si&$\u0018n\u001c8t)%a(q\u001bBm\u00057\u0014\t\u000fC\u0004\u0002<E\u0002\r!!\u0017\t\rU\f\u0004\u0019AA-\u0011\u001d\u0011i.\ra\u0001\u0005?\fQ\u0001]1siN\u0004b!!,\u00028\u0006=\u0002bBAic\u0001\u0007\u0011\u0011R\u0001\u000fIJ|\u0007\u000fU1si&$\u0018n\u001c8t)5a(q\u001dBu\u0005W\u0014yO!=\u0003t\"9\u00111\b\u001aA\u0002\u0005e\u0003BB;3\u0001\u0004\tI\u0006C\u0004\u0003nJ\u0002\r!a+\u0002\u0013A\f'\u000f^*qK\u000e\u001c\bbBAne\u0001\u0007\u0011\u0011\u0012\u0005\b\u00057\u0011\u0004\u0019AAE\u0011\u001d\u0011)P\ra\u0001\u0003\u0013\u000b!B]3uC&tG)\u0019;b\u0003A\u0011XM\\1nKB\u000b'\u000f^5uS>t7\u000fF\u0005}\u0005w\u0014iPa@\u0004\u0002!9\u00111H\u001aA\u0002\u0005e\u0003BB;4\u0001\u0004\tI\u0006C\u0004\u0002*N\u0002\r!a+\t\u000f\r\r1\u00071\u0001\u0002,\u0006Aa.Z<Ta\u0016\u001c7/A\bbYR,'\u000fU1si&$\u0018n\u001c8t)\u001da8\u0011BB\u0006\u0007\u001bAq!a\u000f5\u0001\u0004\tI\u0006\u0003\u0004vi\u0001\u0007\u0011\u0011\f\u0005\b\u0005;$\u0004\u0019\u0001Bp\u000319W\r\u001e)beRLG/[8o)!\tyca\u0005\u0004\u0016\r]\u0001bBA\u001ek\u0001\u0007\u0011\u0011\f\u0005\u0007kV\u0002\r!!\u0017\t\u000f\u0005UU\u00071\u0001\u0002\"\u0005\u0011r-\u001a;QCJ$\u0018\u000e^5p]>\u0003H/[8o)!\u0019iba\b\u0004\"\r\r\u0002#\u0002-\u0003X\u0005=\u0002bBA\u001em\u0001\u0007\u0011\u0011\f\u0005\u0007kZ\u0002\r!!\u0017\t\u000f\u0005Ue\u00071\u0001\u0002\"\u0005\u0011B.[:u!\u0006\u0014H/\u001b;j_:t\u0015-\\3t)!\t9p!\u000b\u0004,\r5\u0002bBA\u001eo\u0001\u0007\u0011\u0011\f\u0005\u0007k^\u0002\r!!\u0017\t\u0013\r=r\u0007%AA\u0002\rE\u0012a\u00039beRL\u0017\r\\*qK\u000e\u0004R\u0001\u0017B,\u0003C\tA\u0004\\5tiB\u000b'\u000f^5uS>tg*Y7fg\u0012\"WMZ1vYR$3'\u0006\u0002\u00048)\"1\u0011GB\u001dW\t\u0019Y\u0004\u0005\u0003\u0004>\r\u001dSBAB \u0015\u0011\u0019\tea\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAB#3\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r%3q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00047jgR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\t\u0005?\u001cye!\u0015\u0004T!9\u00111H\u001dA\u0002\u0005e\u0003BB;:\u0001\u0004\tI\u0006C\u0005\u00040e\u0002\n\u00111\u0001\u00042\u0005AB.[:u!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0002-1L7\u000f\u001e)beRLG/[8og\nKh)\u001b7uKJ$\"Ba8\u0004\\\ru3qLB9\u0011\u001d\tYd\u000fa\u0001\u00033Ba!^\u001eA\u0002\u0005e\u0003bBB1w\u0001\u000711M\u0001\u000baJ,G-[2bi\u0016\u001c\bCBAW\u0003o\u001b)\u0007\u0005\u0003\u0004h\r5TBAB5\u0015\r\u0019YgS\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0004p\r%$AC#yaJ,7o]5p]\"911O\u001eA\u0002\u0005e\u0013!\u00053fM\u0006,H\u000e\u001e+j[\u0016TvN\\3JI\u0006q1M]3bi\u00164UO\\2uS>tG#\u0002?\u0004z\rm\u0004bBA\u001ey\u0001\u0007\u0011\u0011\f\u0005\b\u0007{b\u0004\u0019AA<\u0003\u00111WO\\2\u0002\u0019\u0011\u0014x\u000e\u001d$v]\u000e$\u0018n\u001c8\u0015\u000bq\u001c\u0019i!\"\t\u000f\u0005mR\b1\u0001\u0002Z!91qQ\u001fA\u0002\u0005e\u0013\u0001\u00034v]\u000et\u0015-\\3\u0002\u001b\u0005dG/\u001a:Gk:\u001cG/[8o)\u0015a8QRBH\u0011\u001d\tYD\u0010a\u0001\u00033Bqa! ?\u0001\u0004\t9(\u0001\bsK:\fW.\u001a$v]\u000e$\u0018n\u001c8\u0015\u000fq\u001c)ja&\u0004\u001a\"9\u00111H A\u0002\u0005e\u0003b\u0002B\u0013\u007f\u0001\u0007\u0011\u0011\f\u0005\b\u0005Sy\u0004\u0019AA-\u0003-9W\r\u001e$v]\u000e$\u0018n\u001c8\u0015\r\u0005]4qTBQ\u0011\u001d\tY\u0004\u0011a\u0001\u00033Bqaa\"A\u0001\u0004\tI&\u0001\bgk:\u001cG/[8o\u000bbL7\u000f^:\u0015\r\u0005%5qUBU\u0011\u001d\tY$\u0011a\u0001\u00033Bqaa\"B\u0001\u0004\tI&A\u0007mSN$h)\u001e8di&|gn\u001d\u000b\u0007\u0003o\u001cyk!-\t\u000f\u0005m\"\t1\u0001\u0002Z!9\u0011Q \"A\u0002\u0005e\u0013aD%o\u001b\u0016lwN]=DCR\fGn\\4\u0011\u0005y#5C\u0001#X)\t\u0019),A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0007\u007fS3AYB\u001d\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0019\u0016\u0004O\u000ee\u0002")
public class InMemoryCatalog
implements ExternalCatalog {
    private final Configuration hadoopConfig;
    private final HashMap<String, DatabaseDesc> catalog;

    public static Configuration $lessinit$greater$default$2() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$2();
    }

    public static SparkConf $lessinit$greater$default$1() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void requireDbExists(String db) {
        ExternalCatalog.requireDbExists$(this, db);
    }

    @Override
    public void requireTableExists(String db, String table) {
        ExternalCatalog.requireTableExists$(this, db, table);
    }

    @Override
    public void requireFunctionExists(String db, String funcName) {
        ExternalCatalog.requireFunctionExists$(this, db, funcName);
    }

    @Override
    public void requireFunctionNotExists(String db, String funcName) {
        ExternalCatalog.requireFunctionNotExists$(this, db, funcName);
    }

    private HashMap<String, DatabaseDesc> catalog() {
        return this.catalog;
    }

    private boolean partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireTableNotExists(String db, String table) {
        if (this.tableExists(db, table)) {
            throw new TableAlreadyExistsException(db, table);
        }
    }

    private void requirePartitionsExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private void requirePartitionsNotExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsNotExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) {
                    throw new DatabaseAlreadyExistsException(dbDefinition.name());
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1(dbDefinition);
                boxedUnit = this.catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, dbDefinition));
            }
        }
    }

    @Override
    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)db)) {
                if (!cascade) {
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).tables().nonEmpty()) {
                        throw new AnalysisException(new StringBuilder(49).append("Database ").append(db).append(" is not empty. One or more tables exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).functions().nonEmpty()) {
                        throw new AnalysisException(new StringBuilder(54).append("Database '").append(db).append("' is not empty. One or more functions exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                }
                CatalogDatabase dbDefinition = ((DatabaseDesc)this.catalog().apply((Object)db)).db();
                this.liftedTree2$1(dbDefinition);
                boxedUnit = this.catalog().remove((Object)db);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchDatabaseException(db);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return (Seq)this.catalog().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    @Override
    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
            String db = (String)tableDefinition.identifier().database().get();
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) {
                    throw new TableAlreadyExistsException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Map tableProp;
                CatalogTable catalogTable;
                boolean needDefaultTableLocation;
                CatalogTableType catalogTableType = tableDefinition.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                boolean bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null) && tableDefinition.storage().locationUri().isEmpty() ? true : (needDefaultTableLocation = false);
                if (needDefaultTableLocation) {
                    Path defaultTableLocation = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), table);
                    this.liftedTree3$1(defaultTableLocation, table);
                    catalogTable = tableDefinition.withNewStorage((Option<URI>)new Some((Object)defaultTableLocation.toUri()), tableDefinition.withNewStorage$default$2(), tableDefinition.withNewStorage$default$3(), tableDefinition.withNewStorage$default$4(), tableDefinition.withNewStorage$default$5(), tableDefinition.withNewStorage$default$6());
                } else {
                    catalogTable = tableDefinition;
                }
                CatalogTable tableWithLocation = catalogTable;
                Map x$12 = tableProp = (Map)tableWithLocation.properties().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$createTable$1(x$1)));
                TableIdentifier x$2 = tableWithLocation.copy$default$1();
                CatalogTableType x$3 = tableWithLocation.copy$default$2();
                CatalogStorageFormat x$4 = tableWithLocation.copy$default$3();
                StructType x$5 = tableWithLocation.copy$default$4();
                Option<String> x$6 = tableWithLocation.copy$default$5();
                Seq<String> x$7 = tableWithLocation.copy$default$6();
                Option<BucketSpec> x$8 = tableWithLocation.copy$default$7();
                String x$9 = tableWithLocation.copy$default$8();
                long x$10 = tableWithLocation.copy$default$9();
                long x$11 = tableWithLocation.copy$default$10();
                String x$122 = tableWithLocation.copy$default$11();
                Option<CatalogStatistics> x$13 = tableWithLocation.copy$default$13();
                Option<String> x$14 = tableWithLocation.copy$default$14();
                Option<String> x$15 = tableWithLocation.copy$default$15();
                Seq<String> x$16 = tableWithLocation.copy$default$16();
                boolean x$17 = tableWithLocation.copy$default$17();
                boolean x$18 = tableWithLocation.copy$default$18();
                Map<String, String> x$19 = tableWithLocation.copy$default$19();
                Option<String> x$20 = tableWithLocation.copy$default$20();
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableWithLocation.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, (Map<String, String>)x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20)));
            }
        }
    }

    @Override
    public void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            this.requireDbExists(db);
            if (this.tableExists(db, table)) {
                Object object;
                CatalogTable tableMeta = this.getTable(db, table);
                CatalogTableType catalogTableType = tableMeta.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                    Seq locationAllParts = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.location(), Seq$.MODULE$.canBuildFrom());
                    locationAllParts.foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$dropTable$2(this, loc)));
                    Predef$.MODULE$.assert(tableMeta.storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                    Path dir = new Path(tableMeta.location());
                    object = BoxesRunTime.boxToBoolean((boolean)this.liftedTree4$1(dir, table));
                } else {
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)table);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchTableException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void renameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            this.requireTableNotExists(db, newName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier x$1 = new TableIdentifier(newName, (Option<String>)new Some((Object)db));
            CatalogTableType x$2 = qual$1.copy$default$2();
            CatalogStorageFormat x$3 = qual$1.copy$default$3();
            StructType x$4 = qual$1.copy$default$4();
            Option<String> x$5 = qual$1.copy$default$5();
            Seq<String> x$6 = qual$1.copy$default$6();
            Option<BucketSpec> x$7 = qual$1.copy$default$7();
            String x$8 = qual$1.copy$default$8();
            long x$9 = qual$1.copy$default$9();
            long x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            Map<String, String> x$12 = qual$1.copy$default$12();
            Option<CatalogStatistics> x$13 = qual$1.copy$default$13();
            Option<String> x$14 = qual$1.copy$default$14();
            Option<String> x$15 = qual$1.copy$default$15();
            Seq<String> x$16 = qual$1.copy$default$16();
            boolean x$17 = qual$1.copy$default$17();
            boolean x$18 = qual$1.copy$default$18();
            Map<String, String> x$19 = qual$1.copy$default$19();
            Option<String> x$20 = qual$1.copy$default$20();
            oldDesc.table_$eq(qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            CatalogTableType catalogTableType = oldDesc.table().tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                Predef$.MODULE$.assert(oldDesc.table().storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                Path oldDir = new Path(oldDesc.table().location());
                Path newDir = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), newName);
                this.liftedTree5$1(oldDir, newDir, oldName, newName);
                CatalogTable qual$2 = oldDesc.table();
                Some x$21 = new Some((Object)newDir.toUri());
                Option<String> x$22 = qual$2.withNewStorage$default$2();
                Option<String> x$23 = qual$2.withNewStorage$default$3();
                boolean x$24 = qual$2.withNewStorage$default$4();
                Option<String> x$25 = qual$2.withNewStorage$default$5();
                Map<String, String> x$26 = qual$2.withNewStorage$default$6();
                oldDesc.table_$eq(qual$2.withNewStorage((Option<URI>)x$21, x$22, x$23, x$24, x$25, x$26));
            }
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)oldName);
        }
    }

    @Override
    public synchronized void alterTable(CatalogTable tableDefinition) {
        Map updatedProperties;
        Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
        String db = (String)tableDefinition.identifier().database().get();
        this.requireTableExists(db, tableDefinition.identifier().table());
        Map x$1 = updatedProperties = (Map)tableDefinition.properties().filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$alterTable$1(kv)));
        TableIdentifier x$2 = tableDefinition.copy$default$1();
        CatalogTableType x$3 = tableDefinition.copy$default$2();
        CatalogStorageFormat x$4 = tableDefinition.copy$default$3();
        StructType x$5 = tableDefinition.copy$default$4();
        Option<String> x$6 = tableDefinition.copy$default$5();
        Seq<String> x$7 = tableDefinition.copy$default$6();
        Option<BucketSpec> x$8 = tableDefinition.copy$default$7();
        String x$9 = tableDefinition.copy$default$8();
        long x$10 = tableDefinition.copy$default$9();
        long x$11 = tableDefinition.copy$default$10();
        String x$12 = tableDefinition.copy$default$11();
        Option<CatalogStatistics> x$13 = tableDefinition.copy$default$13();
        Option<String> x$14 = tableDefinition.copy$default$14();
        Option<String> x$15 = tableDefinition.copy$default$15();
        Seq<String> x$16 = tableDefinition.copy$default$16();
        boolean x$17 = tableDefinition.copy$default$17();
        boolean x$18 = tableDefinition.copy$default$18();
        Map<String, String> x$19 = tableDefinition.copy$default$19();
        Option<String> x$20 = tableDefinition.copy$default$20();
        CatalogTable newTableDefinition = tableDefinition.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(newTableDefinition);
    }

    @Override
    public synchronized void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        StructType newSchema;
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        StructType x$1 = newSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)newDataSchema.$plus$plus(origTable.partitionSchema(), Seq$.MODULE$.canBuildFrom())));
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        Option<String> x$5 = origTable.copy$default$5();
        Seq<String> x$6 = origTable.copy$default$6();
        Option<BucketSpec> x$7 = origTable.copy$default$7();
        String x$8 = origTable.copy$default$8();
        long x$9 = origTable.copy$default$9();
        long x$10 = origTable.copy$default$10();
        String x$11 = origTable.copy$default$11();
        Map<String, String> x$12 = origTable.copy$default$12();
        Option<CatalogStatistics> x$13 = origTable.copy$default$13();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized void alterTableStats(String db, String table, Option<CatalogStatistics> stats) {
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        Option<CatalogStatistics> x$1 = stats;
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        StructType x$5 = origTable.copy$default$4();
        Option<String> x$6 = origTable.copy$default$5();
        Seq<String> x$7 = origTable.copy$default$6();
        Option<BucketSpec> x$8 = origTable.copy$default$7();
        String x$9 = origTable.copy$default$8();
        long x$10 = origTable.copy$default$9();
        long x$11 = origTable.copy$default$10();
        String x$12 = origTable.copy$default$11();
        Map<String, String> x$13 = origTable.copy$default$12();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public Seq<CatalogTable> getTablesByName(String db, Seq<String> tables) {
        this.requireDbExists(db);
        HashMap<String, TableDesc> hashMap = ((DatabaseDesc)this.catalog().apply((Object)db)).tables();
        return (Seq)((TraversableLike)tables.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(hashMap.get(key)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.table(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return (Seq)((DatabaseDesc)this.catalog().apply((Object)db)).tables().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public synchronized Seq<String> listViews(String db, String pattern) {
        this.requireDbExists(db);
        Set views = ((HashMap)((DatabaseDesc)this.catalog().apply((Object)db)).tables().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$listViews$1(x$4)))).keySet();
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((Seq)views.toSeq().sorted((Ordering)Ordering.String$.MODULE$)), pattern);
    }

    @Override
    public void loadTable(String db, String table, String loadPath, boolean isOverwrite, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadTable is not implemented");
    }

    @Override
    public void loadPartition(String db, String table, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean inheritTableSpecs, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadPartition is not implemented.");
    }

    @Override
    public void loadDynamicPartitions(String db, String table, String loadPath, Map<String, String> partition, boolean replace, int numDP) {
        throw new UnsupportedOperationException("loadDynamicPartitions is not implemented.");
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> parts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.existingParts$1.contains(A1.spec()) ? A1.spec() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                boolean bl = this.existingParts$1.contains(catalogTablePartition.spec());
                return bl;
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new PartitionsAlreadyExistException(db, table, (Seq<Map<String, String>>)dupSpecs);
        }
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Path partitionPath = (Path)p.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$5 -> new Path(x$5)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ExternalCatalogUtils$.MODULE$.generatePartitionPath(p.spec(), partitionColumnNames, tablePath));
            try {
                FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                Object object = !fs.exists(partitionPath) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(partitionPath)) : BoxedUnit.UNIT;
            }
            catch (IOException e) {
                throw new SparkException(new StringBuilder(32).append("Unable to create partition path ").append(partitionPath).toString(), (Throwable)e);
            }
            CatalogStorageFormat x$1 = p.storage().copy((Option<URI>)new Some((Object)partitionPath.toUri()), p.storage().copy$default$2(), p.storage().copy$default$3(), p.storage().copy$default$4(), p.storage().copy$default$5(), p.storage().copy$default$6());
            Map<String, String> x$2 = p.copy$default$1();
            Map<String, String> x$3 = p.copy$default$3();
            long x$4 = p.copy$default$4();
            long x$52 = p.copy$default$5();
            Option<CatalogStatistics> x$6 = p.copy$default$6();
            return existingParts.put(p.spec(), (Object)p.copy(x$2, x$1, x$3, x$4, x$52, x$6));
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> partSpecs, boolean ignoreIfNotExists, boolean purge, boolean retainData) {
        boolean bl;
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = !this.existingParts$2.contains(A1) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Map<String, String> x1) {
                Map<String, String> map = x1;
                boolean bl = !this.existingParts$2.contains(map);
                return bl;
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new NoSuchPartitionsException(db, table, (Seq<Map<String, String>>)missingSpecs);
        }
        if (retainData) {
            bl = false;
        } else {
            CatalogTableType catalogTableType = this.getTable(db, table).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        }
        boolean shouldRemovePartitionLocation = bl;
        partSpecs.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Object object;
            if (existingParts.contains(p) && shouldRemovePartitionLocation) {
                boolean bl;
                Path partitionPath = new Path(((CatalogTablePartition)existingParts.apply(p)).location());
                try {
                    FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
                    bl = fs.delete(partitionPath, true);
                }
                catch (IOException e) {
                    throw new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
                }
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else {
                object = BoxedUnit.UNIT;
            }
            return existingParts.remove(p);
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> specs, Seq<Map<String, String>> newSpecs) {
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0 & Serializable & scala.Serializable)() -> "number of old and new partition specs differ");
        this.requirePartitionsExist(db, table, specs);
        this.requirePartitionsNotExist(db, table, newSpecs);
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        CatalogTableType catalogTableType = this.getTable(db, table).tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        boolean shouldUpdatePartitionLocation = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        ((IterableLike)specs.zip(newSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CatalogTablePartition catalogTablePartition;
            Map newSpec;
            Map oldSpec;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                oldSpec = (Map)tuple2._1();
                newSpec = (Map)tuple2._2();
                CatalogTablePartition oldPartition = this.getPartition(db, table, (Map<String, String>)oldSpec);
                if (shouldUpdatePartitionLocation) {
                    Path oldPartPath = new Path(oldPartition.location());
                    Path newPartPath = ExternalCatalogUtils$.MODULE$.generatePartitionPath((Map<String, String>)newSpec, partitionColumnNames, tablePath);
                    try {
                        FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                        fs.rename(oldPartPath, newPartPath);
                    }
                    catch (IOException e) {
                        throw new SparkException(new StringBuilder(32).append("Unable to rename partition path ").append(oldPartPath).toString(), (Throwable)e);
                    }
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.storage().copy((Option<URI>)new Some((Object)newPartPath.toUri()), oldPartition.storage().copy$default$2(), oldPartition.storage().copy$default$3(), oldPartition.storage().copy$default$4(), oldPartition.storage().copy$default$5(), oldPartition.storage().copy$default$6()), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                } else {
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.copy$default$2(), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CatalogTablePartition newPartition = catalogTablePartition;
            existingParts.remove((Object)oldSpec);
            Option option = existingParts.put((Object)newSpec, (Object)newPartition);
            return option;
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> parts) {
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)parts.map((Function1 & Serializable & scala.Serializable)p -> p.spec(), Seq$.MODULE$.canBuildFrom())));
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().put(p.spec(), p));
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> spec) {
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec}))));
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec);
    }

    @Override
    public synchronized Option<CatalogTablePartition> getPartitionOption(String db, String table, Map<String, String> spec) {
        return !this.partitionExists(db, table, spec) ? None$.MODULE$ : Option$.MODULE$.apply(((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec));
    }

    @Override
    public synchronized Seq<String> listPartitionNames(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq<String> partitionColumnNames = this.getTable(db, table).partitionColumnNames();
        return (Seq)((SeqLike)this.listPartitions(db, table, partialSpec).map((Function1 & Serializable & scala.Serializable)partition -> ((TraversableOnce)partitionColumnNames.map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(1).append(ExternalCatalogUtils$.MODULE$.escapePathName((String)name)).append("=").append(ExternalCatalogUtils$.MODULE$.escapePathName((String)partition.spec().apply(name))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("/"), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq seq;
        this.requireTableExists(db, table);
        Option<Map<String, String>> option = partialSpec;
        if (None$.MODULE$.equals(option)) {
            seq = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Map partial = (Map)some.value();
            seq = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().toSeq().collect((PartialFunction)new scala.Serializable(null, partial){
                public static final long serialVersionUID = 0L;
                private final Map partial$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Map<String, String>, CatalogTablePartition>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Map spec = (Map)A1._1();
                        CatalogTablePartition partition = (CatalogTablePartition)A1._2();
                        if (ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)spec)) {
                            object = partition;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Map<String, String>, CatalogTablePartition> x1) {
                    Map spec;
                    Tuple2<Map<String, String>, CatalogTablePartition> tuple2 = x1;
                    boolean bl = tuple2 != null && ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)(spec = (Map)tuple2._1()));
                    return bl;
                }
                {
                    this.partial$1 = partial$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    @Override
    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Seq<CatalogTablePartition> listPartitionsByFilter(String db, String table, Seq<Expression> predicates, String defaultTimeZoneId) {
        CatalogTable catalogTable = this.getTable(db, table);
        Seq<CatalogTablePartition> allPartitions = this.listPartitions(db, table, this.listPartitions$default$3());
        return ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(catalogTable, allPartitions, predicates, defaultTimeZoneId);
    }

    @Override
    public void createFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionNotExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void dropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)funcName);
        }
    }

    @Override
    public void alterFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void renameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            this.requireFunctionNotExists(db, newName);
            CatalogFunction qual$1 = this.getFunction(db, oldName);
            FunctionIdentifier x$1 = new FunctionIdentifier(newName, (Option<String>)new Some((Object)db));
            String x$2 = qual$1.copy$default$2();
            Seq<FunctionResource> x$3 = qual$1.copy$default$3();
            CatalogFunction newFunc = qual$1.copy(x$1, x$2, x$3);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((DatabaseDesc)this.catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsExist$1(InMemoryCatalog $this, String db$1, String table$1, Map s) {
        if (!$this.partitionExists(db$1, table$1, (Map<String, String>)s)) {
            throw new NoSuchPartitionException(db$1, table$1, (Map<String, String>)s);
        }
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsNotExist$1(InMemoryCatalog $this, String db$2, String table$2, Map s) {
        if ($this.partitionExists(db$2, table$2, (Map<String, String>)s)) {
            throw new PartitionAlreadyExistsException(db$2, table$2, (Map<String, String>)s);
        }
    }

    private final boolean liftedTree1$1(CatalogDatabase dbDefinition$1) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$1.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(location);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(61).append("Unable to create database ").append(dbDefinition$1.name()).append(" as failed ").append("to create its directory ").append(dbDefinition$1.locationUri()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree2$1(CatalogDatabase dbDefinition$2) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$2.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.delete(location, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(59).append("Unable to drop database ").append(dbDefinition$2.name()).append(" as failed ").append("to delete its directory ").append(dbDefinition$2.locationUri()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree3$1(Path defaultTableLocation$1, String table$3) {
        boolean bl;
        try {
            FileSystem fs = defaultTableLocation$1.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(defaultTableLocation$1);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(58).append("Unable to create table ").append(table$3).append(" as failed ").append("to create its directory ").append(defaultTableLocation$1).toString(), (Throwable)e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createTable$1(Tuple2 x$1) {
        Object object = x$1._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$2(InMemoryCatalog $this, URI loc) {
        boolean bl;
        Path partitionPath = new Path(loc);
        try {
            FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
            bl = fs.delete(partitionPath, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree4$1(Path dir$1, String table$4) {
        boolean bl;
        try {
            FileSystem fs = dir$1.getFileSystem(this.hadoopConfig);
            bl = fs.delete(dir$1, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(56).append("Unable to drop table ").append(table$4).append(" as failed ").append("to delete its directory ").append(dir$1).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree5$1(Path oldDir$1, Path newDir$1, String oldName$1, String newName$1) {
        boolean bl;
        try {
            FileSystem fs = oldDir$1.getFileSystem(this.hadoopConfig);
            bl = fs.rename(oldDir$1, newDir$1);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(62).append("Unable to rename table ").append(oldName$1).append(" to ").append(newName$1).append(" as failed ").append("to rename its directory ").append(oldDir$1).toString(), (Throwable)e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$alterTable$1(Tuple2 kv) {
        Object object = kv._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listViews$1(Tuple2 x$4) {
        CatalogTableType catalogTableType = ((TableDesc)x$4._2()).table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        return !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
    }

    public InMemoryCatalog(SparkConf conf, Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        ExternalCatalog.$init$(this);
        this.catalog = new HashMap();
    }

    public class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }

    public class TableDesc {
        private CatalogTable table;
        private final HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }
}

