/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic$;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001E4QAD\b\u0002\u0002qAQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001C\u0002\u0013EA\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\u0006i\u0001!\t%\u000e\u0005\ty\u0001A)\u0019!C!Y!)Q\b\u0001C\u0001}!)!\n\u0001C\u0001}!)1\n\u0001C\u0001\u0019\")\u0001\u000b\u0001C!#\u001e)ql\u0004E\u0001A\u001a)ab\u0004E\u0001C\")\u0001f\u0003C\u0001K\")am\u0003C\u0001O\n\u0001\")\u001b8bef\f%/\u001b;i[\u0016$\u0018n\u0019\u0006\u0003!E\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011!cE\u0001\tG\u0006$\u0018\r\\=ti*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!H\u0011\u0011\u0005yyR\"A\b\n\u0005\u0001z!A\u0004\"j]\u0006\u0014\u0018p\u00149fe\u0006$xN\u001d\t\u0003E\u0015r!AH\u0012\n\u0005\u0011z\u0011a\u00029bG.\fw-Z\u0005\u0003M\u001d\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002%\u001f\u00051A(\u001b8jiz\"\u0012A\u000b\t\u0003=\u0001\tQb\u00195fG.|e/\u001a:gY><X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u000f\t{w\u000e\\3b]\u0006q1\r[3dW>3XM\u001d4m_^\u0004\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR!!O\n\u0002\u000bQL\b/Z:\n\u0005mB$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0011I,7o\u001c7wK\u0012\fQ\u0002Z3dS6\fG.T3uQ>$W#A \u0011\u0005\u0001;eBA!F!\t\u0011u&D\u0001D\u0015\t!5$\u0001\u0004=e>|GOP\u0005\u0003\r>\na\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011aiL\u0001\u0017G\u0006dWM\u001c3be&sG/\u001a:wC2lU\r\u001e5pI\u0006yQ\r_1di6\u000bG\u000f['fi\"|G-F\u0001N!\rqcjP\u0005\u0003\u001f>\u0012aa\u00149uS>t\u0017!\u00033p\u000f\u0016t7i\u001c3f)\r\u0011\u0006,\u0018\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+>\tqaY8eK\u001e,g.\u0003\u0002X)\nAQ\t\u001f9s\u0007>$W\rC\u0003Z\u0013\u0001\u0007!,A\u0002dib\u0004\"aU.\n\u0005q#&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006=&\u0001\rAU\u0001\u0003KZ\f\u0001CQ5oCJL\u0018I]5uQ6,G/[2\u0011\u0005yY1CA\u0006c!\tq3-\u0003\u0002e_\t1\u0011I\\=SK\u001a$\u0012\u0001Y\u0001\bk:\f\u0007\u000f\u001d7z)\tAw\u000eE\u0002/\u001d&\u0004BA\f6mY&\u00111n\f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005yi\u0017B\u00018\u0010\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006a6\u0001\rAK\u0001\u0002K\u0002")
public abstract class BinaryArithmetic
extends BinaryOperator
implements package.NullIntolerant {
    private boolean resolved;
    private final boolean checkOverflow = SQLConf$.MODULE$.get().ansiEnabled();
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(BinaryArithmetic binaryArithmetic) {
        return BinaryArithmetic$.MODULE$.unapply(binaryArithmetic);
    }

    public boolean checkOverflow() {
        return this.checkOverflow;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    private boolean resolved$lzycompute() {
        BinaryArithmetic binaryArithmetic = this;
        synchronized (binaryArithmetic) {
            if (!this.bitmap$0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess();
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    public String decimalMethod() {
        throw package$.MODULE$.error("BinaryArithmetics must override either decimalMethod or genCode");
    }

    public String calendarIntervalMethod() {
        throw package$.MODULE$.error("BinaryArithmetics must override either calendarIntervalMethod or genCode");
    }

    public Option<String> exactMathMethod() {
        return None$.MODULE$;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(3).append((String)eval1).append(".").append(this.decimalMethod()).append("(").append((String)eval2).append(")").toString());
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            String iu = new StringOps(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(5).append(iu).append(".").append(this.calendarIntervalMethod()).append("(").append((String)eval1).append(", ").append((String)eval2).append(")").toString());
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType);
            if (bl) {
                exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                    String string;
                    String tmpResult = ctx.freshName("tmpResult");
                    if (this.checkOverflow()) {
                        String javaType = CodeGenerator$.MODULE$.boxedType(this.dataType());
                        string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(161).append("\n             |if (").append(tmpResult).append(" < ").append(javaType).append(".MIN_VALUE || ").append(tmpResult).append(" > ").append(javaType).append(".MAX_VALUE) {\n             |  throw new ArithmeticException(").append((String)eval1).append(" + \" ").append(this.symbol()).append(" \" + ").append((String)eval2).append(" + \" caused overflow.\");\n             |}\n           ").toString())).stripMargin();
                    } else {
                        string = "";
                    }
                    String overflowCheck = string;
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n           |").append("int").append(" ").append(tmpResult).append(" = ").append((String)eval1).append(" ").append(this.symbol()).append(" ").append((String)eval2).append(";\n           |").append(overflowCheck).append("\n           |").append(ev.value()).append(" = (").append(CodeGenerator$.MODULE$.javaType(this.dataType())).append(")(").append(tmpResult).append(");\n         ").toString())).stripMargin();
                });
            } else {
                boolean bl2 = IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType);
                if (bl2) {
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                        String string;
                        if (this.checkOverflow() && this.exactMathMethod().isDefined()) {
                            String mathClass = Math.class.getName();
                            string = new StringBuilder(5).append(mathClass).append(".").append(this.exactMathMethod().get()).append("(").append((String)eval1).append(", ").append((String)eval2).append(")").toString();
                        } else {
                            string = new StringBuilder(2).append((String)eval1).append(" ").append(this.symbol()).append(" ").append((String)eval2).toString();
                        }
                        String operation = string;
                        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(27).append("\n           |").append(ev.value()).append(" = ").append(operation).append(";\n         ").toString())).stripMargin();
                    });
                } else {
                    boolean bl3 = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
                    if (bl3) {
                        exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(29).append("\n           |").append(ev.value()).append(" = ").append((String)eval1).append(" ").append(this.symbol()).append(" ").append((String)eval2).append(";\n         ").toString())).stripMargin());
                    } else {
                        throw new MatchError((Object)dataType);
                    }
                }
            }
        }
        return exprCode;
    }
}

