/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u00181\u0001vB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t?\u0002\u0011\t\u0012)A\u00053\"A\u0001\r\u0001BK\u0002\u0013\u0005\u0011\r\u0003\u0005q\u0001\tE\t\u0015!\u0003c\u0011!\t\bA!f\u0001\n\u0003\u0011\b\u0002\u0003<\u0001\u0005#\u0005\u000b\u0011B:\t\u0011]\u0004!Q3A\u0005\u0002aD\u0001\u0002 \u0001\u0003\u0012\u0003\u0006I!\u001f\u0005\u0006{\u0002!\tA \u0005\t\u0003\u0013\u0001!\u0019!C\u00011\"9\u00111\u0002\u0001!\u0002\u0013I\u0006bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\u0007{\u0002!\t!a\u0006\t\ru\u0004A\u0011AA\u0010\u0011\u0019i\b\u0001\"\u0001\u0002&!9\u0011Q\u0006\u0001\u0005B\u0005=\u0002BCA\u001f\u0001!\u0015\r\u0011\"\u0001\u0002@!I\u0011q\u0010\u0001C\u0002\u0013\u0005\u0011\u0011\u0011\u0005\b\u0003\u0007\u0003\u0001\u0015!\u0003n\u0011)\t)\t\u0001EC\u0002\u0013\u0005\u0011q\u0011\u0005\u0007\u0003K\u0003A\u0011\t-\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006bBA^\u0001\u0011\u0005\u0013Q\u0018\u0005\u0007k\u0001!\t%!!\t\u000f\u0005-\u0007\u0001\"\u0011\u0002\u0002\"I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u00033\u0004\u0011\u0013!C\u0001\u00037D\u0011\"!=\u0001#\u0003%\t!a=\t\u0013\u0005]\b!%A\u0005\u0002\u0005e\b\"CA\u007f\u0001E\u0005I\u0011AA\u0000\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0012)\u0001C\u0005\u0003\f\u0001\t\t\u0011\"\u0001\u0003\u000e!I!Q\u0003\u0001\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005;\u0001\u0011\u0011!C!\u0005?A\u0011Ba\u000b\u0001\u0003\u0003%\tA!\f\t\u0013\tE\u0002!!A\u0005B\tMr!\u0003B,a\u0005\u0005\t\u0012\u0001B-\r!y\u0003'!A\t\u0002\tm\u0003BB?(\t\u0003\u0011I\u0007C\u0005\u0003l\u001d\n\t\u0011\"\u0012\u0003n!I!qN\u0014\u0002\u0002\u0013\u0005%\u0011\u000f\u0005\n\u0005w:\u0013\u0013!C\u0001\u0003\u007fD\u0011B! (\u0003\u0003%\tIa \t\u0013\t5u%%A\u0005\u0002\u0005}\b\"\u0003BHO\u0005\u0005I\u0011\u0002BI\u00055Q5o\u001c8U_N#(/^2ug*\u0011\u0011GM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00024i\u0005A1-\u0019;bYf\u001cHO\u0003\u00026m\u0005\u00191/\u001d7\u000b\u0005]B\u0014!B:qCJ\\'BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001e\u001c\u0001aE\u0004\u0001}\t+5J\u0014+\u0011\u0005}\u0002U\"\u0001\u0019\n\u0005\u0005\u0003$aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005}\u001a\u0015B\u0001#1\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002G\u00136\tqI\u0003\u0002Ia\u000591m\u001c3fO\u0016t\u0017B\u0001&H\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007CA M\u0013\ti\u0005GA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002P+&\u0011a\u000b\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007g\u000eDW-\\1\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001\u0018\u001b\u0002\u000bQL\b/Z:\n\u0005y[&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u00059q\u000e\u001d;j_:\u001cX#\u00012\u0011\t\rTW.\u001c\b\u0003I\"\u0004\"!\u001a)\u000e\u0003\u0019T!a\u001a\u001f\u0002\rq\u0012xn\u001c;?\u0013\tI\u0007+\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u00141!T1q\u0015\tI\u0007\u000b\u0005\u0002d]&\u0011q\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011=\u0004H/[8og\u0002\nQa\u00195jY\u0012,\u0012a\u001d\t\u0003\u007fQL!!\u001e\u0019\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u000bi&lWMW8oK&#W#A=\u0011\u0007=SX.\u0003\u0002|!\n1q\n\u001d;j_:\f1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"\u0012b`A\u0001\u0003\u0007\t)!a\u0002\u0011\u0005}\u0002\u0001\"B,\n\u0001\u0004I\u0006\"\u00021\n\u0001\u0004\u0011\u0007\"B9\n\u0001\u0004\u0019\bbB<\n!\u0003\u0005\r!_\u0001\u000f]VdG.\u00192mKN\u001b\u0007.Z7b\u0003=qW\u000f\u001c7bE2,7k\u00195f[\u0006\u0004\u0013\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005E\u0001cA(\u0002\u0014%\u0019\u0011Q\u0003)\u0003\u000f\t{w\u000e\\3b]R9q0!\u0007\u0002\u001c\u0005u\u0001\"B9\u000e\u0001\u0004\u0019\b\"B,\u000e\u0001\u0004\u0019\b\"\u00021\u000e\u0001\u0004\u0011G#B@\u0002\"\u0005\r\u0002\"B9\u000f\u0001\u0004\u0019\b\"B,\u000f\u0001\u0004\u0019HcB@\u0002(\u0005%\u00121\u0006\u0005\u0006c>\u0001\ra\u001d\u0005\u0006/>\u0001\ra\u001d\u0005\u0006A>\u0001\ra]\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o\u0011\u0014\u0001C1oC2L8/[:\n\t\u0005m\u0012Q\u0007\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006I1m\u001c8wKJ$XM]\u000b\u0003\u0003\u0003\u0002raTA\"\u0003\u000f\n\t'C\u0002\u0002FA\u0013\u0011BR;oGRLwN\\\u0019\u0011\r\u0005%\u00131KA-\u001d\u0011\tY%a\u0014\u000f\u0007\u0015\fi%C\u0001R\u0013\r\t\t\u0006U\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)&a\u0016\u0003\u0011%#XM]1u_JT1!!\u0015Q!\u0011\tY&!\u0018\u000e\u0003IJ1!a\u00183\u0005-Ie\u000e^3s]\u0006d'k\\<\u0013\u000b\u0005\rD+a\u001a\u0007\r\u0005\u0015\u0004\u0001AA1\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\nA\u0001\\1oO*\u0011\u0011\u0011O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002v\u0005-$AB(cU\u0016\u001cG\u000fK\u0002\u0012\u0003s\u00022aTA>\u0013\r\ti\b\u0015\u0002\niJ\fgn]5f]R\f1C\\1nK>37i\u001c:skB$(+Z2pe\u0012,\u0012!\\\u0001\u0015]\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000f\u001a\u0011\u0002\rA\f'o]3s+\t\tI\t\u0005\u0004\u0002\f\u0006E\u0015QS\u0007\u0003\u0003\u001bS1!a$3\u0003\u0011)H/\u001b7\n\t\u0005M\u0015Q\u0012\u0002\u0012\r\u0006LG.\u001e:f'\u00064W\rU1sg\u0016\u0014\b\u0003BAL\u0003?k!!!'\u000b\u0007q\u000bYJC\u0002\u0002\u001eZ\na!\u001e8tC\u001a,\u0017\u0002BAQ\u00033\u0013!\"\u0016+GqM#(/\u001b8hQ\r!\u0012\u0011P\u0001\tI\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR\u0019!)a+\t\u000b]4\u0002\u0019A7\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005E\u0016q\u0017\t\u0004\u001f\u0006M\u0016bAA[!\n\u0019\u0011I\\=\t\u000f\u0005ev\u00031\u0001\u00022\u0006!!n]8o\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u007f\u0003b!!\u0013\u0002B\u0006\u0015\u0017\u0002BAb\u0003/\u00121aU3r!\rQ\u0016qY\u0005\u0004\u0003\u0013\\&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u0001\u0005G>\u0004\u0018\u0010F\u0005\u0000\u0003#\f\u0019.!6\u0002X\"9qk\u0007I\u0001\u0002\u0004I\u0006b\u00021\u001c!\u0003\u0005\rA\u0019\u0005\bcn\u0001\n\u00111\u0001t\u0011\u001d98\u0004%AA\u0002e\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002^*\u001a\u0011,a8,\u0005\u0005\u0005\b\u0003BAr\u0003[l!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a;Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\f)OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002v*\u001a!-a8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111 \u0016\u0004g\u0006}\u0017AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0003Q3!_Ap\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\u0001\t\u0005\u0003S\u0012I!C\u0002p\u0003W\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0004\u0011\u0007=\u0013\t\"C\u0002\u0003\u0014A\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!-\u0003\u001a!I!1\u0004\u0012\u0002\u0002\u0003\u0007!qB\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0002C\u0002B\u0012\u0005S\t\t,\u0004\u0002\u0003&)\u0019!q\u0005)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002V\t\u0015\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E!q\u0006\u0005\n\u00057!\u0013\u0011!a\u0001\u0003c\u000ba!Z9vC2\u001cH\u0003BA\t\u0005kA\u0011Ba\u0007&\u0003\u0003\u0005\r!!-)'\u0001\u0011IDa\u0010\u0003B\t\u0015#q\tB&\u0005\u001b\u0012\tFa\u0015\u0011\u0007}\u0012Y$C\u0002\u0003>A\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003D\u0005\u0011wLR+O\u0007~C#n]8o'R\u0014H\u0006I:dQ\u0016l\u0017m\u0017\u0017!_B$\u0018n\u001c8t;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAM$(/^2uAY\fG.^3!o&$\b\u000e\t;iK\u0002:\u0017N^3oA\u0001T7o\u001c8TiJ\u0004\u0007%\u00198eA\u0001\u001c8\r[3nC\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t%\u0013!!:\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ(%\u0019\u0012;c1\u0002#E\u0019\u0012;a9BTp\n\u0017!O\u0005\u0004\u0013J\u0014+-A\t\u0004CiT+C\u0019\u0016;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|E\u0005\u0014#(\r\u0017#E\nR\u0004G\f\u001d~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3P\t;j[\u0016\u0014#H\t\u001a7_ABtF\r\u00192k\tjx\u0005\f\u0011(i&lW\r\t+j[\u0016\u001cH/Y7qO1\u0002S.\u00199)OQLW.Z:uC6\u0004hi\u001c:nCR<C\u0006I\u0014eI>jUjL=zsf<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\"\u0018.\\3#uI\u0002\u0014'N\u00171q5\u0012d\u0007\t\u00191uA\u0002$\b\r\u0019~\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B(\u0003)Q7o\u001c8`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005+\nQA\r\u00183]A\nQBS:p]R{7\u000b\u001e:vGR\u001c\bCA ('\u00119#Q\f+\u0011\u0013\t}#QM-cgf|XB\u0001B1\u0015\r\u0011\u0019\u0007U\u0001\beVtG/[7f\u0013\u0011\u00119G!\u0019\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0003Z\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\b\u0005)\u0011\r\u001d9msRIqPa\u001d\u0003v\t]$\u0011\u0010\u0005\u0006/*\u0002\r!\u0017\u0005\u0006A*\u0002\rA\u0019\u0005\u0006c*\u0002\ra\u001d\u0005\bo*\u0002\n\u00111\u0001z\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0003\u0013I\t\u0005\u0003Pu\n\r\u0005cB(\u0003\u0006f\u00137/_\u0005\u0004\u0005\u000f\u0003&A\u0002+va2,G\u0007\u0003\u0005\u0003\f2\n\t\u00111\u0001\u0000\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003O\u0002")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<UTF8String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes.checkInputDataTypes$(this) : new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Input schema ").append(this.nullableSchema().catalogString()).append(" must be a struct, an array or a map.").toString());
        return typeCheckResult;
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? (InternalRow)rows.next() : null;
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getArray(0) : null;
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)rows -> rows.hasNext() ? ((SpecializedGetters)rows.next()).getMap(0) : null;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<UTF8String> parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Tuple2 tuple2;
                DataType dataType;
                ParseMode mode;
                JSONOptions parsedOptions = new JSONOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw new IllegalArgumentException(new StringBuilder(66).append("from_json() doesn't support the ").append(mode.name()).append(" mode. ").append("Acceptable modes are ").append(PermissiveMode$.MODULE$.name()).append(" and ").append(FailFastMode$.MODULE$.name()).append(".").toString());
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType, parsedOptions.columnNameOfCorruptRecord());
                    tuple2 = new Tuple2((Object)structType, (Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)structType.filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JsonToStructs.$anonfun$parser$1(parsedOptions, x$11))))));
                } else {
                    StructField structField = new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$.$colon$colon((Object)structField)), (Object)dataType);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                StructType parserSchema = (StructType)tuple22._1();
                DataType actualSchema = (DataType)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                Tuple2 tuple24 = tuple23;
                StructType parserSchema2 = (StructType)tuple24._1();
                DataType actualSchema2 = (DataType)tuple24._2();
                JacksonParser rawParser = new JacksonParser(actualSchema2, parsedOptions, false);
                Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record);
                this.parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<UTF8String> parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        return this.converter().apply(this.parser().parse((UTF8String)json));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        String string = dataType instanceof MapType ? "entries" : super.sql();
        return string;
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.schema();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(JSONOptions parsedOptions$1, StructField x$11) {
        String string = x$11.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

