/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NTile$;
import org.apache.spark.sql.catalyst.expressions.RowNumberLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.NoOp$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(n) - Divides the rows for each window partition into `n` buckets ranging\n      from 1 to at most `n`.\n  ", arguments="\n    Arguments:\n      * buckets - an int expression which is number of buckets to divide the rows in.\n          Default value is 1.\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0014)\u0001VB\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\")A\n\u0001C\u0001\u001b\")A\n\u0001C\u0001!\")\u0011\u000b\u0001C!%\")q\f\u0001C!A\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u00025\t\r9\u0004\u0001\u0015!\u0003j\u0011\u001dy\u0007A1A\u0005\n!Da\u0001\u001d\u0001!\u0002\u0013I\u0007bB9\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007e\u0002\u0001\u000b\u0011B5\t\u000bM\u0004A\u0011\u0002;\t\u000fi\u0004!\u0019!C!w\"9\u00111\u0001\u0001!\u0002\u0013a\b\"CA\u0003\u0001\t\u0007I\u0011IA\u0004\u0011!\tY\u0001\u0001Q\u0001\n\u0005%\u0001\"CA\u0007\u0001\t\u0007I\u0011IA\u0004\u0011!\ty\u0001\u0001Q\u0001\n\u0005%\u0001\u0002CA\t\u0001\t\u0007I\u0011\t5\t\u000f\u0005M\u0001\u0001)A\u0005S\"I\u0011Q\u0003\u0001\u0002\u0002\u0013\u0005\u0011q\u0003\u0005\n\u00037\u0001\u0011\u0013!C\u0001\u0003;A\u0011\"a\r\u0001\u0003\u0003%\t%!\u000e\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0003\"CA)\u0001\u0005\u0005I\u0011AA*\u0011%\ty\u0006AA\u0001\n\u0003\n\t\u0007C\u0005\u0002j\u0001\t\t\u0011\"\u0001\u0002l!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0013qO\u0004\n\u00037C\u0013\u0011!E\u0001\u0003;3\u0001b\n\u0015\u0002\u0002#\u0005\u0011q\u0014\u0005\u0007\u0019\u0006\"\t!!,\t\u0013\u0005=\u0016%!A\u0005F\u0005E\u0006\"CAZC\u0005\u0005I\u0011QA[\u0011%\tI,IA\u0001\n\u0003\u000bY\fC\u0005\u0002H\u0006\n\t\u0011\"\u0003\u0002J\n)a\nV5mK*\u0011\u0011FK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002,Y\u0005A1-\u0019;bYf\u001cHO\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001mij4\t\u0005\u00028q5\t\u0001&\u0003\u0002:Q\ti!k\\<Ok6\u0014WM\u001d'jW\u0016\u0004\"aN\u001e\n\u0005qB#aF*ju\u0016\u0014\u0015m]3e/&tGm\\<Gk:\u001cG/[8o!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010#\n\u0005\u0015{$\u0001D*fe&\fG.\u001b>bE2,\u0017a\u00022vG.,Go]\u000b\u0002\u0011B\u0011q'S\u0005\u0003\u0015\"\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003!\u0011WoY6fiN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002O\u001fB\u0011q\u0007\u0001\u0005\u0006\r\u000e\u0001\r\u0001\u0013\u000b\u0002\u001d\u0006A1\r[5mIJ,g.F\u0001T!\r!F\f\u0013\b\u0003+js!AV-\u000e\u0003]S!\u0001\u0017\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0015BA.@\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u00180\u0003\u0007M+\u0017O\u0003\u0002\\\u007f\u0005\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002eU\u0005A\u0011M\\1msNL7/\u0003\u0002gG\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0004ck\u000e\\W\r^\u000b\u0002SB\u0011qG[\u0005\u0003W\"\u0012!#\u0011;ue&\u0014W\u000f^3SK\u001a,'/\u001a8dK\u00069!-^2lKR\u0004\u0013a\u00042vG.,G\u000f\u00165sKNDw\u000e\u001c3\u0002!\t,8m[3u)\"\u0014Xm\u001d5pY\u0012\u0004\u0013A\u00032vG.,GoU5{K\u0006Y!-^2lKR\u001c\u0016N_3!\u0003I\u0011WoY6fiN<\u0016\u000e\u001e5QC\u0012$\u0017N\\4\u0002'\t,8m[3ug^KG\u000f\u001b)bI\u0012Lgn\u001a\u0011\u0002\u001d\t,8m[3u\u001fZ,'O\u001a7poR\u0011Q\u000f\u001f\t\u0003oYL!a\u001e\u0015\u0003\u0005%3\u0007\"B=\u0010\u0001\u0004A\u0015!A3\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0003q\u0004B!`A\u0001S6\taP\u0003\u0002\u0000\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005us\u0018\u0001F1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\b%A\u0007j]&$\u0018.\u00197WC2,Xm]\u000b\u0003\u0003\u0013\u0001B!`A\u0001\u0011\u0006q\u0011N\\5uS\u0006dg+\u00197vKN\u0004\u0013!E;qI\u0006$X-\u0012=qe\u0016\u001c8/[8og\u0006\u0011R\u000f\u001d3bi\u0016,\u0005\u0010\u001d:fgNLwN\\:!\u0003I)g/\u00197vCR,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002'\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002\t\r|\u0007/\u001f\u000b\u0004\u001d\u0006e\u0001b\u0002$\u0019!\u0003\u0005\r\u0001S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyBK\u0002I\u0003CY#!a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[y\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011GA\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005Y\u0006twM\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\u0011\t)%a\u000f\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0005E\u0002?\u0003\u001bJ1!a\u0014@\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)&a\u0017\u0011\u0007y\n9&C\u0002\u0002Z}\u00121!\u00118z\u0011%\ti\u0006HA\u0001\u0002\u0004\tY%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003G\u0002R!`A3\u0003+J1!a\u001a\u007f\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u00055\u00141\u000f\t\u0004}\u0005=\u0014bAA9\u007f\t9!i\\8mK\u0006t\u0007\"CA/=\u0005\u0005\t\u0019AA+\u0003\u0019)\u0017/^1mgR!\u0011QNA=\u0011%\tifHA\u0001\u0002\u0004\t)\u0006K\n\u0001\u0003{\n\u0019)!\"\u0002\n\u0006-\u0015qRAI\u0003+\u000b9\nE\u00028\u0003\u007fJ1!!!)\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\"\u0002i*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015oS\u0001j\u0003\u0005R5wS\u0012,7\u000f\t;iK\u0002\u0012xn^:!M>\u0014\b%Z1dQ\u0002:\u0018N\u001c3po\u0002\u0002\u0018M\u001d;ji&|g\u000eI5oi>\u0004\u0003M\u001c1!EV\u001c7.\u001a;tAI\fgnZ5oO*\u0001\u0003\u0005\t\u0011!A\u0019\u0014x.\u001c\u00112AQ|\u0007%\u0019;![>\u001cH\u000f\t1oA:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!!$\u0002\u0003\u001bQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t2vG.,Go\u001d\u0011.A\u0005t\u0007%\u001b8uA\u0015D\bO]3tg&|g\u000eI<iS\u000eD\u0007%[:!]Vl'-\u001a:!_\u001a\u0004#-^2lKR\u001c\b\u0005^8!I&4\u0018\u000eZ3!i\",\u0007E]8xg\u0002JgN\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"UMZ1vYR\u0004c/\u00197vK\u0002J7\u000fI\u0019/\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAJ\u0003\u0015\u0011d\u0006\r\u00181\u0003\u00159'o\\;qC\t\tI*\u0001\u0007xS:$wn^0gk:\u001c7/A\u0003O)&dW\r\u0005\u00028CM!\u0011%!)D!\u0019\t\u0019+!+I\u001d6\u0011\u0011Q\u0015\u0006\u0004\u0003O{\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003W\u000b)KA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!!(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00079\u000b9\fC\u0003GI\u0001\u0007\u0001*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u00161\u0019\t\u0005}\u0005}\u0006*C\u0002\u0002B~\u0012aa\u00149uS>t\u0007\u0002CAcK\u0005\u0005\t\u0019\u0001(\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAf!\u0011\tI$!4\n\t\u0005=\u00171\b\u0002\u0007\u001f\nTWm\u0019;")
public class NTile
extends RowNumberLike
implements SizeBasedWindowFunction {
    private final Expression buckets;
    private final AttributeReference bucket;
    private final AttributeReference bucketThreshold;
    private final AttributeReference bucketSize;
    private final AttributeReference bucketsWithPadding;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Expression> initialValues;
    private final Seq<Expression> updateExpressions;
    private final AttributeReference evaluateExpression;
    private final AttributeReference n;

    public static Option<Expression> unapply(NTile nTile) {
        return NTile$.MODULE$.unapply(nTile);
    }

    public static <A> Function1<Expression, A> andThen(Function1<NTile, A> function1) {
        return NTile$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, NTile> compose(Function1<A, Expression> function1) {
        return NTile$.MODULE$.compose(function1);
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    public Expression buckets() {
        return this.buckets;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.buckets()}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.buckets().foldable()) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append("Buckets expression must be foldable, but got ").append(this.buckets()).toString());
        }
        DataType dataType = this.buckets().dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(49).append("Buckets expression must be integer type, but got ").append(this.buckets()).toString());
        }
        int i = BoxesRunTime.unboxToInt((Object)this.buckets().eval(this.buckets().eval$default$1()));
        return i > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("Buckets expression must be positive, but got: ").append(i).toString());
    }

    private AttributeReference bucket() {
        return this.bucket;
    }

    private AttributeReference bucketThreshold() {
        return this.bucketThreshold;
    }

    private AttributeReference bucketSize() {
        return this.bucketSize;
    }

    private AttributeReference bucketsWithPadding() {
        return this.bucketsWithPadding;
    }

    private If bucketOverflow(Expression e) {
        return new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.rowNumber()).$greater$eq(this.bucketThreshold())), e, this.zero());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Expression> initialValues() {
        return this.initialValues;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return this.evaluateExpression;
    }

    public NTile copy(Expression buckets) {
        return new NTile(buckets);
    }

    public Expression copy$default$1() {
        return this.buckets();
    }

    @Override
    public String productPrefix() {
        return "NTile";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.buckets();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NTile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        NTile nTile = (NTile)x$1;
        Expression expression = this.buckets();
        Expression expression2 = nTile.buckets();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!nTile.canEqual(this)) return false;
        return true;
    }

    public NTile(Expression buckets) {
        this.buckets = buckets;
        SizeBasedWindowFunction.$init$(this);
        String x$1 = "bucket";
        IntegerType$ x$2 = IntegerType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        this.bucket = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        String x$7 = "bucketThreshold";
        IntegerType$ x$8 = IntegerType$.MODULE$;
        boolean x$9 = false;
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, x$8, x$9, x$10);
        Seq<String> x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, x$8, x$9, x$10);
        this.bucketThreshold = new AttributeReference(x$7, x$8, x$9, x$10, x$11, x$12);
        String x$13 = "bucketSize";
        IntegerType$ x$14 = IntegerType$.MODULE$;
        boolean x$15 = false;
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, x$14, x$15, x$16);
        Seq<String> x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, x$14, x$15, x$16);
        this.bucketSize = new AttributeReference(x$13, x$14, x$15, x$16, x$17, x$18);
        String x$19 = "bucketsWithPadding";
        IntegerType$ x$20 = IntegerType$.MODULE$;
        boolean x$21 = false;
        Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, x$20, x$21, x$22);
        Seq<String> x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, x$20, x$21, x$22);
        this.bucketsWithPadding = new AttributeReference(x$19, x$20, x$21, x$22, x$23, x$24);
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{this.rowNumber(), this.bucket(), this.bucketThreshold(), this.bucketSize(), this.bucketsWithPadding()}));
        this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.zero(), this.zero(), this.zero(), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).cast(DecimalType$.MODULE$.IntDecimal())).$div(package$expressions$.MODULE$.DslExpression(buckets).cast(DecimalType$.MODULE$.IntDecimal()))).cast(IntegerType$.MODULE$), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$percent(buckets)).cast(IntegerType$.MODULE$)}));
        this.updateExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.rowNumber()).$plus(this.one()), package$expressions$.MODULE$.DslExpression(this.bucket()).$plus(this.bucketOverflow(this.one())), package$expressions$.MODULE$.DslExpression(this.bucketThreshold()).$plus(this.bucketOverflow(package$expressions$.MODULE$.DslExpression(this.bucketSize()).$plus(new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.bucket()).$less(this.bucketsWithPadding())), this.one(), this.zero())))), NoOp$.MODULE$, NoOp$.MODULE$}));
        this.evaluateExpression = this.bucket();
    }

    public NTile() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

