/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\u0010 \u00012B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005A\t\u0003\u0005I\u0001\tE\t\u0015!\u0003F\u0011!I\u0005A!f\u0001\n\u0003q\u0004\u0002\u0003&\u0001\u0005#\u0005\u000b\u0011B \t\u000b-\u0003A\u0011\u0001'\t\u000b-\u0003A\u0011A)\t\u000b-\u0003A\u0011\u0001+\t\u000bY\u0003A\u0011I,\t\u000b\u0011\u0002A\u0011I4\t\u000bA\u0004A\u0011I4\t\u000fE\u0004\u0011\u0011!C\u0001e\"9a\u000fAI\u0001\n\u00039\b\"CA\u0003\u0001E\u0005I\u0011AA\u0004\u0011!\tY\u0001AI\u0001\n\u00039\b\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u0011%\ty\u0002AA\u0001\n\u0003\t\t\u0003C\u0005\u0002*\u0001\t\t\u0011\"\u0001\u0002,!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C\u0001\u0003\u0003B\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\b\u0013\u0005]t$!A\t\u0002\u0005ed\u0001\u0003\u0010 \u0003\u0003E\t!a\u001f\t\r-CB\u0011AAE\u0011%\tY\tGA\u0001\n\u000b\ni\tC\u0005\u0002\u0010b\t\t\u0011\"!\u0002\u0012\"I\u0011\u0011\u0014\r\u0002\u0002\u0013\u0005\u00151\u0014\u0005\n\u0003SC\u0012\u0011!C\u0005\u0003W\u00131\u0002U1sg\u0016$v\u000eR1uK*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001[E\"$\b\u0005\u0002/_5\tq$\u0003\u00021?\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004Qe>$Wo\u0019;\u0011\u0005UZ\u0014B\u0001\u001f7\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003}\u0002\"A\f!\n\u0005\u0005{\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u00051am\u001c:nCR,\u0012!\u0012\t\u0004k\u0019{\u0014BA$7\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001b:{\u0005\u000b\u0005\u0002/\u0001!)Qh\u0002a\u0001\u007f!)1i\u0002a\u0001\u000b\")\u0011j\u0002a\u0001\u007fQ\u0019QJU*\t\u000buB\u0001\u0019A \t\u000b\rC\u0001\u0019A \u0015\u00055+\u0006\"B\u001f\n\u0001\u0004y\u0014!\u00044mCR\f%oZ;nK:$8/F\u0001Y!\rI\u0016\r\u001a\b\u00035~s!a\u00170\u000e\u0003qS!!X\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u000117\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\u0011%#XM]1u_JT!\u0001\u0019\u001c\u0011\u0005U*\u0017B\u000147\u0005\r\te._\u000b\u0002QB\u0011\u0011.\u001c\b\u0003U.\u0004\"a\u0017\u001c\n\u000514\u0014A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\u001c\u001c\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0003d_BLH\u0003B'tiVDq!P\u0007\u0011\u0002\u0003\u0007q\bC\u0004D\u001bA\u0005\t\u0019A#\t\u000f%k\u0001\u0013!a\u0001\u007f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001=+\u0005}J8&\u0001>\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0005v]\u000eDWmY6fI*\u0011qPN\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0002y\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0002\u0016\u0003\u000bf\fabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003mC:<'BAA\u000e\u0003\u0011Q\u0017M^1\n\u00079\f)\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002$A\u0019Q'!\n\n\u0007\u0005\u001dbGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002e\u0003[A\u0011\"a\f\u0014\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0004E\u0003\u00028\u0005uB-\u0004\u0002\u0002:)\u0019\u00111\b\u001c\u0002\u0015\r|G\u000e\\3di&|g.C\u0002c\u0003s\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0007\nI\u0005E\u00026\u0003\u000bJ1!a\u00127\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\f\u0016\u0003\u0003\u0005\r\u0001Z\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0013q\n\u0005\t\u0003_1\u0012\u0011!a\u0001I\":\u0002!a\u0015\u0002Z\u0005m\u0013qLA1\u0003K\n9'a\u001b\u0002n\u0005E\u00141\u000f\t\u0004]\u0005U\u0013bAA,?\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA/\u0003\u0005e&\u0002\t\u0011!A}3UKT\"`Q\u0011\fG/Z0tiJ\\F\u0006\t4nivK\u0003%\f\u0011QCJ\u001cXm\u001d\u0011uQ\u0016\u0004\u0003\rZ1uK~\u001bHO\u001d1!Kb\u0004(/Z:tS>t\u0007e^5uQ\u0002\"\b.\u001a\u0011aM6$\b\rI3yaJ,7o]5p]\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003%\u0019\u0011eCR,g\u0006\t*fiV\u0014hn\u001d\u0011ok2d\u0007e^5uQ\u0002JgN^1mS\u0012\u0004\u0013N\u001c9vi:\u0002#)\u001f\u0011eK\u001a\fW\u000f\u001c;-A%$\bEZ8mY><8\u000fI2bgRLgn\u001a\u0011sk2,7\u000f\t;pA\u0005\u0004C-\u0019;fA%4'\u0002\t\u0011!A\u0001\u0002C\u000f[3!A\u001alG\u000f\u0019\u0011jg\u0002zW.\u001b;uK\u0012t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA2\u0003\t}!\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eCR,wl\u001d;sA5\u0002\u0013\tI:ue&tw\r\t;pA\t,\u0007\u0005]1sg\u0016$\u0007\u0005^8!I\u0006$XM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M6$\b%\f\u0011ECR,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014h\u000e\t;pA\u0019|G\u000e\\8x]\u0001\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006Z1uKRLW.Z\u0017qCR$XM\u001d8/QRlGN\t ECR,G/[7fAA\u000bG\u000f^3s]Ndt&\u0019 !M>\u0014\bE^1mS\u0012T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C-\u0019;fA\u0005tG\r\t;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt7O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002j\u0005\tiC\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00172e5\u001a\u0014g\n\u0017!OeL\u00180_\u0017N\u001b6\"GmJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014GN\u00172e5\u001a\u0014G\u0003\u0011!\u0003\u00159'o\\;qC\t\ty'\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005U\u0014!B\u0019/k9\u0002\u0014a\u0003)beN,Gk\u001c#bi\u0016\u0004\"A\f\r\u0014\ta\tiH\u000f\t\t\u0003\u007f\n)iP#@\u001b6\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u00073\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u000f\u000b\tIA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!\u001f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0005\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f5\u000b\u0019*!&\u0002\u0018\")Qh\u0007a\u0001\u007f!)1i\u0007a\u0001\u000b\")\u0011j\u0007a\u0001\u007f\u00059QO\\1qa2LH\u0003BAO\u0003K\u0003B!\u000e$\u0002 B1Q'!)@\u000b~J1!a)7\u0005\u0019!V\u000f\u001d7fg!A\u0011q\u0015\u000f\u0002\u0002\u0003\u0007Q*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0016\t\u0005\u0003'\ty+\u0003\u0003\u00022\u0006U!AB(cU\u0016\u001cG\u000f")
public class ParseToDate
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String sql() {
        return this.format().isDefined() ? new StringBuilder(4).append(this.prettyName()).append("(").append(this.left().sql()).append(", ").append(((Expression)this.format().get()).sql()).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(this.left().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToDate(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToDate.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new Cast(new UnixTimestamp(left, format, UnixTimestamp$.MODULE$.apply$default$3()), TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()), DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

