/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp[, idx]) - Extracts a group that matches `regexp`.", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression.\n          The regex string should be a Java regular expression.\n      * idx - an integer expression that representing the group index. The group index should be\n          non-negative. If `idx` is not specified, the default group index value is 1.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)-(\\\\d+)', 1);\n       100\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015s!\u0002\u0014(\u0011\u0003!d!\u0002\u001c(\u0011\u00039\u0004\"B!\u0002\t\u0003\u0011\u0005\"B\"\u0002\t\u0003!\u0005bB(\u0002\u0003\u0003%\t\t\u0015\u0005\n\u0005O\t\u0011\u0011!CA\u0005SA\u0011Ba\u000f\u0002\u0003\u0003%IA!\u0010\u0007\tY:\u0003I\u0015\u0005\t9\u001e\u0011)\u001a!C\u0001;\"A\u0011m\u0002B\tB\u0003%a\f\u0003\u0005c\u000f\tU\r\u0011\"\u0001^\u0011!\u0019wA!E!\u0002\u0013q\u0006\u0002\u00033\b\u0005+\u0007I\u0011A/\t\u0011\u0015<!\u0011#Q\u0001\nyCQ!Q\u0004\u0005\u0002\u0019DQ!Q\u0004\u0005\u0002)D\u0011b\\\u0004A\u0002\u0003\u0007I\u0011\u00029\t\u0013e<\u0001\u0019!a\u0001\n\u0013Q\b\"C?\b\u0001\u0004\u0005\t\u0015)\u0003r\u0011-\t)a\u0002a\u0001\u0002\u0004%I!a\u0002\t\u0017\u0005uq\u00011AA\u0002\u0013%\u0011q\u0004\u0005\f\u0003G9\u0001\u0019!A!B\u0013\tI\u0001C\u0004\u0002(\u001d!\t%!\u000b\t\u000f\u0005er\u0001\"\u0011\u0002<!9\u0011qI\u0004\u0005B\u0005%\u0003bBA5\u000f\u0011\u0005\u00131\u000e\u0005\b\u0003_:A\u0011IA9\u0011\u001d\t\u0019i\u0002C)\u0003\u000bC\u0011\"!)\b\u0003\u0003%\t!a)\t\u0013\u0005-v!%A\u0005\u0002\u00055\u0006\"CAb\u000fE\u0005I\u0011AAW\u0011%\t)mBI\u0001\n\u0003\ti\u000bC\u0005\u0002H\u001e\t\t\u0011\"\u0011\u0002J\"I\u0011Q[\u0004\u0002\u0002\u0013\u0005\u0011q\u001b\u0005\n\u00033<\u0011\u0011!C\u0001\u00037D\u0011\"a8\b\u0003\u0003%\t%!9\t\u0013\u0005=x!!A\u0005\u0002\u0005E\b\"CA~\u000f\u0005\u0005I\u0011IA\u007f\u00035\u0011VmZ#ya\u0016CHO]1di*\u0011\u0001&K\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002+W\u0005A1-\u0019;bYf\u001cHO\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00026\u00035\tqEA\u0007SK\u001e,\u0005\u0010]#yiJ\f7\r^\n\u0004\u0003ar\u0004CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$AB!osJ+g\r\u0005\u0002:\u007f%\u0011\u0001I\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\nqb\u00195fG.<%o\\;q\u0013:$W\r\u001f\u000b\u0004\u000b\"k\u0005CA\u001dG\u0013\t9%H\u0001\u0003V]&$\b\"B%\u0004\u0001\u0004Q\u0015AC4s_V\u00048i\\;oiB\u0011\u0011hS\u0005\u0003\u0019j\u00121!\u00138u\u0011\u0015q5\u00011\u0001K\u0003)9'o\\;q\u0013:$W\r_\u0001\u0006CB\u0004H.\u001f\u000b\b#\n\u0005\"1\u0005B\u0013!\t)taE\u0003\b'ZKf\b\u0005\u00026)&\u0011Qk\n\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001bX\u0013\tAvE\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tI$,\u0003\u0002\\u\t9\u0001K]8ek\u000e$\u0018aB:vE*,7\r^\u000b\u0002=B\u0011QgX\u0005\u0003A\u001e\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003!\u0019XO\u00196fGR\u0004\u0013A\u0002:fO\u0016D\b/A\u0004sK\u001e,\u0007\u0010\u001d\u0011\u0002\u0007%$\u00070\u0001\u0003jIb\u0004C\u0003B)hQ&DQ\u0001\u0018\bA\u0002yCQA\u0019\bA\u0002yCQ\u0001\u001a\bA\u0002y#2!U6n\u0011\u0015aw\u00021\u0001_\u0003\u0005\u0019\b\"\u00028\u0010\u0001\u0004q\u0016!\u0001:\u0002\u00131\f7\u000f\u001e*fO\u0016DX#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018!\u0002;za\u0016\u001c(B\u0001<.\u0003\u0019)hn]1gK&\u0011\u0001p\u001d\u0002\u000b+R3\u0005h\u0015;sS:<\u0017!\u00047bgR\u0014VmZ3y?\u0012*\u0017\u000f\u0006\u0002Fw\"9A0EA\u0001\u0002\u0004\t\u0018a\u0001=%c\u0005QA.Y:u%\u0016<W\r\u001f\u0011)\u0005Iy\bcA\u001d\u0002\u0002%\u0019\u00111\u0001\u001e\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00029biR,'O\\\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u001a5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0003sK\u001e,\u0007P\u0003\u0003\u0002\u0014\u0005U\u0011\u0001B;uS2T!!a\u0006\u0002\t)\fg/Y\u0005\u0005\u00037\tiAA\u0004QCR$XM\u001d8\u0002\u0017A\fG\u000f^3s]~#S-\u001d\u000b\u0004\u000b\u0006\u0005\u0002\u0002\u0003?\u0015\u0003\u0003\u0005\r!!\u0003\u0002\u0011A\fG\u000f^3s]\u0002B#!F@\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0011\u0005-\u0012\u0011GA\u001a\u0003o\u00012!OA\u0017\u0013\r\tyC\u000f\u0002\u0004\u0003:L\bB\u00027\u0017\u0001\u0004\tY\u0003C\u0004\u00026Y\u0001\r!a\u000b\u0002\u0003ADaA\u001c\fA\u0002\u0005-\u0012\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005u\u0002\u0003BA \u0003\u0007j!!!\u0011\u000b\u0005Q\\\u0013\u0002BA#\u0003\u0003\u0012\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA&!\u0019\ti%!\u0018\u0002d9!\u0011qJA-\u001d\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+g\u00051AH]8pizJ\u0011aO\u0005\u0004\u00037R\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003?\n\tGA\u0002TKFT1!a\u0017;!\u0011\ty$!\u001a\n\t\u0005\u001d\u0014\u0011\t\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003[\u0002R!!\u0014\u0002^y\u000b!\u0002\u001d:fiRLh*Y7f+\t\t\u0019\b\u0005\u0003\u0002v\u0005ud\u0002BA<\u0003s\u00022!!\u0015;\u0013\r\tYHO\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0014\u0011\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005m$(A\u0005e_\u001e+gnQ8eKR1\u0011qQAJ\u0003;\u0003B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001b;\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003#\u000bYI\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t)j\u0007a\u0001\u0003/\u000b1a\u0019;y!\u0011\tI)!'\n\t\u0005m\u00151\u0012\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tyj\u0007a\u0001\u0003\u000f\u000b!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\b#\u0006\u0015\u0016qUAU\u0011\u001daF\u0004%AA\u0002yCqA\u0019\u000f\u0011\u0002\u0003\u0007a\fC\u0004e9A\u0005\t\u0019\u00010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0016\u0016\u0004=\u0006E6FAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u&(\u0001\u0006b]:|G/\u0019;j_:LA!!1\u00028\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002LB!\u0011QZAj\u001b\t\tyM\u0003\u0003\u0002R\u0006U\u0011\u0001\u00027b]\u001eLA!a \u0002P\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t!*\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0012Q\u001c\u0005\by\n\n\t\u00111\u0001K\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAr!\u0019\t)/a;\u0002,5\u0011\u0011q\u001d\u0006\u0004\u0003ST\u0014AC2pY2,7\r^5p]&!\u0011Q^At\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M\u0018\u0011 \t\u0004s\u0005U\u0018bAA|u\t9!i\\8mK\u0006t\u0007\u0002\u0003?%\u0003\u0003\u0005\r!a\u000b\u0002\r\u0015\fX/\u00197t)\u0011\t\u00190a@\t\u0011q,\u0013\u0011!a\u0001\u0003WA3c\u0002B\u0002\u0005\u0013\u0011YAa\u0004\u0003\u0012\tU!q\u0003B\u000e\u0005;\u00012!\u000eB\u0003\u0013\r\u00119a\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011i!\u0001#`\rVs5i\u0018\u0015tiJd\u0003E]3hKb\u00048\f\f\u0011jIbl\u0016\u0006I\u0017!\u000bb$(/Y2ug\u0002\n\u0007e\u001a:pkB\u0004C\u000f[1uA5\fGo\u00195fg\u0002\u0002'/Z4fqB\u0004g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012!1C\u0001\u0003V*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e\u001d;sA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]:R\u0001\u0005\t\u0011!A\u0001R\u0003E]3hKb\u0004\b%\f\u0011bAM$(/\u001b8hAI,\u0007O]3tK:$\u0018N\\4!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u00165fAI,w-\u001a=!gR\u0014\u0018N\\4!g\"|W\u000f\u001c3!E\u0016\u0004\u0013\r\t&bm\u0006\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o])\u0001\u0003\u0005\t\u0011!A)\u0002\u0013\u000e\u001a=![\u0001\ng\u000eI5oi\u0016<WM\u001d\u0011fqB\u0014Xm]:j_:\u0004C\u000f[1uAI,\u0007O]3tK:$\u0018N\\4!i\",\u0007e\u001a:pkB\u0004\u0013N\u001c3fq:\u0002C\u000b[3!OJ|W\u000f\u001d\u0011j]\u0012,\u0007\u0010I:i_VdG\r\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E\\8o[9,w-\u0019;jm\u0016t\u0003%\u00134!A&$\u0007\u0010\u0019\u0011jg\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI2\u0002C\u000f[3!I\u00164\u0017-\u001e7uA\u001d\u0014x.\u001e9!S:$W\r\u001f\u0011wC2,X\rI5tAEr#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\u0007\u0002%*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u00191[I\u0002\u0004g\n\u0017!O!bF\fZ\u0016*[!bF\fZ\u0016*O1\u0002\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cA\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t}\u0011!B\u0019/k9\u0002\u0004\"\u0002/\u0005\u0001\u0004q\u0006\"\u00022\u0005\u0001\u0004q\u0006\"\u00023\u0005\u0001\u0004q\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005W\u00119\u0004E\u0003:\u0005[\u0011\t$C\u0002\u00030i\u0012aa\u00149uS>t\u0007CB\u001d\u00034ysf,C\u0002\u00036i\u0012a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u001d\u000b\u0005\u0005\t\u0019A)\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B !\u0011\tiM!\u0011\n\t\t\r\u0013q\u001a\u0002\u0007\u001f\nTWm\u0019;")
public class RegExpExtract
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtract regExpExtract) {
        return RegExpExtract$.MODULE$.unapply(regExpExtract);
    }

    public static void checkGroupIndex(int n, int n2) {
        RegExpExtract$.MODULE$.checkGroupIndex(n, n2);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression idx() {
        return this.idx;
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        UTF8String uTF8String;
        Matcher m;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        if ((m = this.pattern().matcher(s.toString())).find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtract$.MODULE$.checkGroupIndex(mr.groupCount(), index);
            String group = mr.group(index);
            uTF8String = group == null ? UTF8String.EMPTY_UTF8 : UTF8String.fromString((String)group);
        } else {
            uTF8String = UTF8String.EMPTY_UTF8;
        }
        return uTF8String;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.idx();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_extract";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameRegExpExtract = RegExpExtract.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, idx) -> new StringBuilder(519).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      java.util.regex.Matcher ").append(matcher).append(" =\n        ").append(termPattern).append(".matcher(").append((String)subject).append(".toString());\n      if (").append(matcher).append(".find()) {\n        java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n        ").append(classNameRegExpExtract).append(".checkGroupIndex(").append(matchResult).append(".groupCount(), ").append((String)idx).append(");\n        if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n          ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        } else {\n          ").append(ev.value()).append(" = UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append("));\n        }\n        ").append(setEvNotNull).append("\n      } else {\n        ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        ").append(setEvNotNull).append("\n      }").toString());
    }

    public RegExpExtract copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtract(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.idx();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtract regExpExtract = (RegExpExtract)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtract.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtract.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtract.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtract.canEqual(this)) return false;
        return true;
    }

    public RegExpExtract(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
        ExpectsInputTypes.$init$(this);
    }

    public RegExpExtract(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

