/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(fmt, ts) - Returns timestamp `ts` truncated to the unit specified by the format model `fmt`.\n  ", arguments="\n     Arguments:\n       * fmt - the format representing the unit to be truncated to\n           - \"YEAR\", \"YYYY\", \"YY\" - truncate to the first date of the year that the `ts` falls in, the time part will be zero out\n           - \"QUARTER\" - truncate to the first date of the quarter that the `ts` falls in, the time part will be zero out\n           - \"MONTH\", \"MM\", \"MON\" - truncate to the first date of the month that the `ts` falls in, the time part will be zero out\n           - \"WEEK\" - truncate to the Monday of the week that the `ts` falls in, the time part will be zero out\n           - \"DAY\", \"DD\" - zero out the time part\n           - \"HOUR\" - zero out the minute and second with fraction part\n           - \"MINUTE\"- zero out the second with fraction part\n           - \"SECOND\" -  zero out the second fraction part\n           - \"MILLISECOND\" - zero out the microseconds\n           - \"MICROSECOND\" - everything remains\n       * ts - datetime value or valid timestamp string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', '2015-03-05T09:32:05.359');\n       2015-01-01 00:00:00\n      > SELECT _FUNC_('MM', '2015-03-05T09:32:05.359');\n       2015-03-01 00:00:00\n      > SELECT _FUNC_('DD', '2015-03-05T09:32:05.359');\n       2015-03-05 00:00:00\n      > SELECT _FUNC_('HOUR', '2015-03-05T09:32:05.359');\n       2015-03-05 09:00:00\n      > SELECT _FUNC_('MILLISECOND', '2015-03-05T09:32:05.123456');\n       2015-03-05 09:32:05.123\n  ", group="datetime_funcs", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\tua\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011!\u0001\u0006A!f\u0001\n\u0003\t\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u001d\u0004A\u0011I%\t\u000b!\u0004A\u0011I%\t\u000b%\u0004A\u0011\t6\t\u000bi\u0004A\u0011I>\t\r}\u0004A\u0011IA\u0001\u0011!\t\u0019\u0001\u0001b\u0001\n\u0003J\u0005bBA\u0003\u0001\u0001\u0006IA\u0013\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u0019\t\u0007\u0001\"\u0001\u0002\u000e!9\u00111\u0003\u0001\u0005B\u0005U\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013B\u0011\"!\u0015\u0001#\u0003%\t!a\u0015\t\u0013\u0005%\u0004!%A\u0005\u0002\u0005M\u0003\"CA6\u0001E\u0005I\u0011AA7\u0011%\t\t\bAA\u0001\n\u0003\n\u0019\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/C\u0011\"!*\u0001\u0003\u0003%\t!a*\t\u0013\u0005E\u0006!!A\u0005B\u0005Mv!CAoO\u0005\u0005\t\u0012AAp\r!1s%!A\t\u0002\u0005\u0005\bBB1\u001f\t\u0003\ty\u000fC\u0005\u0002rz\t\t\u0011\"\u0012\u0002t\"I\u0011Q\u001f\u0010\u0002\u0002\u0013\u0005\u0015q\u001f\u0005\n\u0003\u007ft\u0012\u0013!C\u0001\u0003[B\u0011B!\u0001\u001f\u0003\u0003%\tIa\u0001\t\u0013\tEa$%A\u0005\u0002\u00055\u0004\"\u0003B\n=\u0005\u0005I\u0011\u0002B\u000b\u00059!&/\u001e8d)&lWm\u001d;b[BT!\u0001K\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003U-\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003Y5\n1a]9m\u0015\tqs&A\u0003ta\u0006\u00148N\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<7\u0001A\n\u0007\u0001UJDhP#\u0011\u0005Y:T\"A\u0014\n\u0005a:#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t1$(\u0003\u0002<O\taAK];oG&s7\u000f^1oiB\u0011a'P\u0005\u0003}\u001d\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001IR\u0005\u0003\u000f\u0006\u0013AbU3sS\u0006d\u0017N_1cY\u0016\faAZ8s[\u0006$X#\u0001&\u0011\u0005YZ\u0015B\u0001'(\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\bM>\u0014X.\u0019;!\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u0006uS6,7\u000f^1na\u0002\n!\u0002^5nKj{g.Z%e+\u0005\u0011\u0006c\u0001!T+&\u0011A+\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YkfBA,\\!\tA\u0016)D\u0001Z\u0015\tQ6'\u0001\u0004=e>|GOP\u0005\u00039\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A,Q\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005G\u0012,g\r\u0005\u00027\u0001!)\u0001j\u0002a\u0001\u0015\")aj\u0002a\u0001\u0015\"9\u0001k\u0002I\u0001\u0002\u0004\u0011\u0016\u0001\u00027fMR\fQA]5hQR\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005Y\u0007c\u00017ri:\u0011Qn\u001c\b\u00031:L\u0011AQ\u0005\u0003a\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0002sg\n\u00191+Z9\u000b\u0005A\f\u0005CA;y\u001b\u00051(BA<,\u0003\u0015!\u0018\u0010]3t\u0013\tIhO\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001}!\t)X0\u0003\u0002\u007fm\niA+[7fgR\fW\u000e\u001d+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\u0005)\u0016aB5ogR\fg\u000e^\u0001\tS:\u001cH/\u00198uA\u0005aq/\u001b;i)&lWMW8oKR\u0019A(a\u0003\t\u000bA{\u0001\u0019A+\u0015\u000b\r\fy!!\u0005\t\u000b!\u0003\u0002\u0019\u0001&\t\u000b9\u0003\u0002\u0019\u0001&\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003/\ti\u0002E\u0002A\u00033I1!a\u0007B\u0005\r\te.\u001f\u0005\n\u0003?\t\u0002\u0013!a\u0001\u0003C\tQ!\u001b8qkR\u0004B!a\t\u0002&5\t\u0011&C\u0002\u0002(%\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003[\tI$a\u0011\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r(\u0003\u001d\u0019w\u000eZ3hK:LA!a\u000e\u00022\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002<I\u0001\r!!\u0010\u0002\u0007\r$\b\u0010\u0005\u0003\u00020\u0005}\u0012\u0002BA!\u0003c\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002FI\u0001\r!!\f\u0002\u0005\u00154\u0018\u0001B2paf$raYA&\u0003\u001b\ny\u0005C\u0004I'A\u0005\t\u0019\u0001&\t\u000f9\u001b\u0002\u0013!a\u0001\u0015\"9\u0001k\u0005I\u0001\u0002\u0004\u0011\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003+R3ASA,W\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA2\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyGK\u0002S\u0003/\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\nA\u0001\\1oO*\u0011\u0011qP\u0001\u0005U\u00064\u0018-C\u0002_\u0003s\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\"\u0011\u0007\u0001\u000bI)C\u0002\u0002\f\u0006\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0006\u0002\u0012\"I\u00111S\r\u0002\u0002\u0003\u0007\u0011qQ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0005CBAN\u0003C\u000b9\"\u0004\u0002\u0002\u001e*\u0019\u0011qT!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002$\u0006u%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!+\u00020B\u0019\u0001)a+\n\u0007\u00055\u0016IA\u0004C_>dW-\u00198\t\u0013\u0005M5$!AA\u0002\u0005]\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002*\u0006U\u0006\"CAJ9\u0005\u0005\t\u0019AA\fQ]\u0001\u0011\u0011XA`\u0003\u0003\f)-a2\u0002L\u00065\u0017\u0011[Aj\u0003/\fI\u000eE\u00027\u0003wK1!!0(\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a1\u0002W*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015g[Rd\u0003\u0005^:*A5\u0002#+\u001a;ve:\u001c\b\u0005^5nKN$\u0018-\u001c9!AR\u001c\b\r\t;sk:\u001c\u0017\r^3eAQ|\u0007\u0005\u001e5fAUt\u0017\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u0012\u0017\u0010\t;iK\u00022wN]7bi\u0002jw\u000eZ3mA\u00014W\u000e\u001e1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\tI-ADW\u0015\u0001\u0002\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005\u001e5fA\u0019|'/\\1uAI,\u0007O]3tK:$\u0018N\\4!i\",\u0007%\u001e8ji\u0002\"x\u000e\t2fAQ\u0014XO\\2bi\u0016$\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#3\u0016\u000b%K\t\u0017!EeK\u0016,\u0017\u0012-A\tJ\u0016L\t\u0011.AQ\u0014XO\\2bi\u0016\u0004Co\u001c\u0011uQ\u0016\u0004c-\u001b:ti\u0002\"\u0017\r^3!_\u001a\u0004C\u000f[3!s\u0016\f'\u000f\t;iCR\u0004C\u000f[3!AR\u001c\b\r\t4bY2\u001c\b%\u001b8-AQDW\r\t;j[\u0016\u0004\u0003/\u0019:uA]LG\u000e\u001c\u0011cK\u0002RXM]8!_V$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%U+B%R+%K\t\u0011.AQ\u0014XO\\2bi\u0016\u0004Co\u001c\u0011uQ\u0016\u0004c-\u001b:ti\u0002\"\u0017\r^3!_\u001a\u0004C\u000f[3!cV\f'\u000f^3sAQD\u0017\r\u001e\u0011uQ\u0016\u0004\u0003\r^:aA\u0019\fG\u000e\\:!S:d\u0003\u0005\u001e5fAQLW.\u001a\u0011qCJ$\be^5mY\u0002\u0012W\r\t>fe>\u0004s.\u001e;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b>sE\u000b\u0013\u0012-A\tjUJ\t\u0017!E5{eJ\t\u0011.AQ\u0014XO\\2bi\u0016\u0004Co\u001c\u0011uQ\u0016\u0004c-\u001b:ti\u0002\"\u0017\r^3!_\u001a\u0004C\u000f[3![>tG\u000f\u001b\u0011uQ\u0006$\b\u0005\u001e5fA\u0001$8\u000f\u0019\u0011gC2d7\u000fI5oY\u0001\"\b.\u001a\u0011uS6,\u0007\u0005]1si\u0002:\u0018\u000e\u001c7!E\u0016\u0004#0\u001a:pA=,HO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI,F\u000b.\u0013\u0003%\f\u0011ueVt7-\u0019;fAQ|\u0007\u0005\u001e5fA5{g\u000eZ1zA=4\u0007\u0005\u001e5fA],Wm\u001b\u0011uQ\u0006$\b\u0005\u001e5fA\u0001$8\u000f\u0019\u0011gC2d7\u000fI5oY\u0001\"\b.\u001a\u0011uS6,\u0007\u0005]1si\u0002:\u0018\u000e\u001c7!E\u0016\u0004#0\u001a:pA=,HO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#B3\nb\u0003E\t#EE\u0001j\u0003E_3s_\u0002zW\u000f\u001e\u0011uQ\u0016\u0004C/[7fAA\f'\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012I\u001fV\u0013&\u0005I\u0017!u\u0016\u0014x\u000eI8vi\u0002\"\b.\u001a\u0011nS:,H/\u001a\u0011b]\u0012\u00043/Z2p]\u0012\u0004s/\u001b;iA\u0019\u0014\u0018m\u0019;j_:\u0004\u0003/\u0019:u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5Ke*\u0016+FE5\u0002#0\u001a:pA=,H\u000f\t;iK\u0002\u001aXmY8oI\u0002:\u0018\u000e\u001e5!MJ\f7\r^5p]\u0002\u0002\u0018M\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#'\u0016\u001buJ\u0014##A5\u0002\u0003E_3s_\u0002zW\u000f\u001e\u0011uQ\u0016\u00043/Z2p]\u0012\u0004cM]1di&|g\u000e\t9beRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012S*\u0013'M\u0013N+5i\u0014(EE\u0001j\u0003E_3s_\u0002zW\u000f\u001e\u0011uQ\u0016\u0004S.[2s_N,7m\u001c8eg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tj\u0015j\u0011*P'\u0016\u001buJ\u0014##A5\u0002SM^3ssRD\u0017N\\4!e\u0016l\u0017-\u001b8t\u0015\u0001\u0002\u0003\u0005\t\u0011!A)\u0002Co\u001d\u0011.A\u0011\fG/\u001a;j[\u0016\u0004c/\u00197vK\u0002z'\u000f\t<bY&$\u0007\u0005^5nKN$\u0018-\u001c9!gR\u0014\u0018N\\4\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u001f\f1\u0011\u0012\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oe+\u0015IU\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001djUj\n\u0017!OI\u0002\u0014'N\u00171g5\u0002T\u0007\u0016\u0019:uM\u0012$\bM\u001b/gUJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nT'\f\u00194[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0011#u\u0005\f\u0011(eA\nT'\f\u00194[A*D\u000bM\u001d;gIR\u0004'\u000e\u00184ke:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE*T\u0006M\u001a.aU\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0011>+&k\n\u0017!OI\u0002\u0014'N\u00171g5\u0002T\u0007\u0016\u0019:uM\u0012$\bM\u001b/gUJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nT'\f\u00194[A*\u0004\u0005M\u001d;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O5KE\nT%T\u000b\u000e{e\nR\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]E\u00124\u0007N\u001b7O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192k5\u00024'\f\u00196AAJ$h\r\u001a;aUr\u0013GM\u001a\u000bA\u0001\nQa\u001a:pkB\f#!!6\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u00111\\\u0001\u0006e9\u001ad\u0006M\u0001\u000f)J,hn\u0019+j[\u0016\u001cH/Y7q!\t1dd\u0005\u0003\u001f\u0003G,\u0005\u0003CAs\u0003WT%JU2\u000e\u0005\u0005\u001d(bAAu\u0003\u00069!/\u001e8uS6,\u0017\u0002BAw\u0003O\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\ty.\u0001\u0005u_N#(/\u001b8h)\t\t)(A\u0003baBd\u0017\u0010F\u0004d\u0003s\fY0!@\t\u000b!\u000b\u0003\u0019\u0001&\t\u000b9\u000b\u0003\u0019\u0001&\t\u000fA\u000b\u0003\u0013!a\u0001%\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0015!Q\u0002\t\u0005\u0001N\u00139\u0001\u0005\u0004A\u0005\u0013Q%JU\u0005\u0004\u0005\u0017\t%A\u0002+va2,7\u0007\u0003\u0005\u0003\u0010\r\n\t\u00111\u0001d\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005/\u0001B!a\u001e\u0003\u001a%!!1DA=\u0005\u0019y%M[3di\u0002")
public class TruncTimestamp
extends BinaryExpression
implements TruncInstant,
TimeZoneAwareExpression,
scala.Serializable {
    private final Expression format;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private final Expression instant;
    private boolean resolved;
    private transient ZoneId zoneId;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return TruncTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(TruncTimestamp truncTimestamp) {
        return TruncTimestamp$.MODULE$.unapply(truncTimestamp);
    }

    public static Option<String> apply$default$3() {
        return TruncTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, TruncTimestamp> tupled() {
        return TruncTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, TruncTimestamp>>> curried() {
        return TruncTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int minLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, minLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int minLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, minLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.format();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, TimestampType$.MODULE$}));
    }

    @Override
    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "date_trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_TIMESTAMP_TRUNC(), (Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(t, level) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.truncTimestamp(BoxesRunTime.unboxToLong((Object)t), BoxesRunTime.unboxToInt((Object)level), this.zoneId())));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_TIMESTAMP_TRUNC(), true, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(date, fmt) -> new StringBuilder(21).append("truncTimestamp(").append((String)date).append(", ").append((String)fmt).append(", ").append(zid).append(");").toString());
    }

    public TruncTimestamp copy(Expression format, Expression timestamp, Option<String> timeZoneId) {
        return new TruncTimestamp(format, timestamp, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.format();
    }

    public Expression copy$default$2() {
        return this.timestamp();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TruncTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.format();
                break;
            }
            case 1: {
                option = this.timestamp();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncTimestamp truncTimestamp = (TruncTimestamp)x$1;
        Expression expression = this.format();
        Expression expression2 = truncTimestamp.format();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = truncTimestamp.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = truncTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncTimestamp.canEqual(this)) return false;
        return true;
    }

    public TruncTimestamp(Expression format, Expression timestamp, Option<String> timeZoneId) {
        this.format = format;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        this.instant = timestamp;
    }

    public TruncTimestamp(Expression format, Expression timestamp) {
        this(format, timestamp, (Option<String>)None$.MODULE$);
    }
}

