/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.PartialResultException;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u000f\u001e\u0001)B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011)\u0019!C\u0001\u007f!AA\t\u0001B\u0001B\u0003%\u0001\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015I\u0005\u0001\"\u0001K\u000b\u0011y\u0005\u0001\u0002)\t\u000f}\u0003!\u0019!C\u0005A\"1!\u000f\u0001Q\u0001\n\u0005Dqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004y\u0001\u0001\u0006I!\u001e\u0005\ts\u0002A)\u0019!C\u0005u\"Q\u00111\u0001\u0001\t\u0006\u0004%I!!\u0002\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010!9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011%\ty\u0004\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA\"\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!a\u001d\u0001\t\u0013\t)\bC\u0005\u0002(\u0002\u0011\r\u0011\"\u0003\u0002*\"9\u00111\u0016\u0001!\u0002\u00131\u0005bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\ty\r\u0001C\u0005\u0003#Dq!a8\u0001\t\u0013\t\t\u000fC\u0004\u0002n\u0002!\t!a<\u0003\u001b)\u000b7m[:p]B\u000b'o]3s\u0015\tqr$\u0001\u0003kg>t'B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"AM\u001b\u000e\u0003MR!\u0001N\u0012\u0002\u0011%tG/\u001a:oC2L!AN\u001a\u0003\u000f1{wmZ5oO\u000611o\u00195f[\u0006\u0004\"!\u000f\u001f\u000e\u0003iR!aO\u0011\u0002\u000bQL\b/Z:\n\u0005uR$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000f=\u0004H/[8ogV\t\u0001\t\u0005\u0002B\u00056\tQ$\u0003\u0002D;\tY!jU(O\u001fB$\u0018n\u001c8t\u0003!y\u0007\u000f^5p]N\u0004\u0013aE1mY><\u0018I\u001d:bs\u0006\u001b8\u000b\u001e:vGR\u001c\bC\u0001\u0017H\u0013\tAUFA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0011YE*\u0014(\u0011\u0005\u0005\u0003\u0001\"B\u001c\u0006\u0001\u0004A\u0004\"\u0002 \u0006\u0001\u0004\u0001\u0005\"B#\u0006\u0001\u00041%A\u0004,bYV,7i\u001c8wKJ$XM\u001d\t\u0005YE\u001b6&\u0003\u0002S[\tIa)\u001e8di&|g.\r\t\u0003)vk\u0011!\u0016\u0006\u0003-^\u000bAaY8sK*\u0011\u0001,W\u0001\bU\u0006\u001c7n]8o\u0015\tQ6,A\u0005gCN$XM\u001d=nY*\tA,A\u0002d_6L!AX+\u0003\u0015)\u001bxN\u001c)beN,'/A\u0007s_>$8i\u001c8wKJ$XM]\u000b\u0002CB!A&U*c!\r\u00197N\u001c\b\u0003I&t!!\u001a5\u000e\u0003\u0019T!aZ\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013B\u00016.\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0011%#XM]1cY\u0016T!A[\u0017\u0011\u0005=\u0004X\"A\u0010\n\u0005E|\"aC%oi\u0016\u0014h.\u00197S_^\faB]8pi\u000e{gN^3si\u0016\u0014\b%A\u0004gC\u000e$xN]=\u0016\u0003U\u0004\"\u0001\u0016<\n\u0005],&a\u0003&t_:4\u0015m\u0019;pef\f\u0001BZ1di>\u0014\u0018\u0010I\u0001\u0013i&lWm\u001d;b[B4uN]7biR,'/F\u0001|!\tax0D\u0001~\u0015\tqx$\u0001\u0003vi&d\u0017bAA\u0001{\n\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u00035!\u0017\r^3G_Jl\u0017\r\u001e;feV\u0011\u0011q\u0001\t\u0004y\u0006%\u0011bAA\u0006{\niA)\u0019;f\r>\u0014X.\u0019;uKJ\f\u0011#\\1lKJ{w\u000e^\"p]Z,'\u000f^3s)\r\t\u0017\u0011\u0003\u0005\u0007\u0003'i\u0001\u0019\u0001\u001d\u0002\u0005\u0011$\u0018aF7bW\u0016\u001cFO];diJ{w\u000e^\"p]Z,'\u000f^3s)\r\t\u0017\u0011\u0004\u0005\b\u00037q\u0001\u0019AA\u000f\u0003\t\u0019H\u000fE\u0002:\u0003?I1!!\t;\u0005)\u0019FO];diRK\b/Z\u0001\u0015[\u0006\\W-T1q%>|GoQ8om\u0016\u0014H/\u001a:\u0015\u0007\u0005\f9\u0003C\u0004\u0002*=\u0001\r!a\u000b\u0002\u00055$\bcA\u001d\u0002.%\u0019\u0011q\u0006\u001e\u0003\u000f5\u000b\u0007\u000fV=qK\u00061R.Y6f\u0003J\u0014\u0018-\u001f*p_R\u001cuN\u001c<feR,'\u000fF\u0002b\u0003kAq!a\u000e\u0011\u0001\u0004\tI$\u0001\u0002biB\u0019\u0011(a\u000f\n\u0007\u0005u\"HA\u0005BeJ\f\u0017\u0010V=qK\u0006iA-Z2j[\u0006d\u0007+\u0019:tKJ,\"!a\u0011\u0011\r1\n\u0016QIA+!\u0011\t9%a\u0014\u000f\t\u0005%\u00131\n\t\u0003K6J1!!\u0014.\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011KA*\u0005\u0019\u0019FO]5oO*\u0019\u0011QJ\u0017\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u0005!Q.\u0019;i\u0015\t\ty&\u0001\u0003kCZ\f\u0017\u0002BA2\u00033\u0012!BQ5h\t\u0016\u001c\u0017.\\1m\u00039!WmY5nC2\u0004\u0016M]:fe\u0002\nQ\"\\1lK\u000e{gN^3si\u0016\u0014H\u0003BA6\u0003_\u00022!!\u001c\u0007\u001b\u0005\u0001\u0001BBA9'\u0001\u0007\u0001(\u0001\u0005eCR\fG+\u001f9f\u00039\u0001\u0018M]:f\u0015N|g\u000eV8lK:,B!a\u001e\u0002\u0000Q1\u0011\u0011PAQ\u0003K#B!a\u001f\u0002\u0012B!\u0011QPA@\u0019\u0001!q!!!\u0015\u0005\u0004\t\u0019IA\u0001S#\u0011\t))a#\u0011\u00071\n9)C\u0002\u0002\n6\u0012AAT;mYB\u0019A&!$\n\u0007\u0005=UFA\u0002B]fDq!a%\u0015\u0001\u0004\t)*A\u0001g!\u001da\u0013qSAN\u0003wJ1!!'.\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007c\u0001+\u0002\u001e&\u0019\u0011qT+\u0003\u0013)\u001bxN\u001c+pW\u0016t\u0007BBAR)\u0001\u00071+\u0001\u0004qCJ\u001cXM\u001d\u0005\u0007\u0003c\"\u0002\u0019\u0001\u001d\u0002!\u0005dGn\\<F[B$\u0018p\u0015;sS:<W#\u0001$\u0002#\u0005dGn\\<F[B$\u0018p\u0015;sS:<\u0007%\u0001\tgC&dW\rZ\"p]Z,'o]5p]V!\u0011\u0011WA\\)\u0019\t\u0019,!/\u0002<B9A&a&\u0002\u001c\u0006U\u0006\u0003BA?\u0003o#q!!!\u0018\u0005\u0004\t\u0019\t\u0003\u0004\u0002$^\u0001\ra\u0015\u0005\u0007\u0003c:\u0002\u0019\u0001\u001d\u0002\u001b\r|gN^3si>\u0013'.Z2u)\u001dq\u0017\u0011YAb\u0003\u000bDa!a)\u0019\u0001\u0004\u0019\u0006BB\u001c\u0019\u0001\u0004\ti\u0002C\u0004\u0002Hb\u0001\r!!3\u0002\u001f\u0019LW\r\u001c3D_:4XM\u001d;feN\u0004R\u0001LAf\u0003WJ1!!4.\u0005\u0015\t%O]1z\u0003)\u0019wN\u001c<feRl\u0015\r\u001d\u000b\u0007\u0003'\fI.a7\u0011\u0007q\f).C\u0002\u0002Xv\u0014q!T1q\t\u0006$\u0018\r\u0003\u0004\u0002$f\u0001\ra\u0015\u0005\b\u0003;L\u0002\u0019AA6\u000391\u0017.\u001a7e\u0007>tg/\u001a:uKJ\fAbY8om\u0016\u0014H/\u0011:sCf$b!a9\u0002j\u0006-\bc\u0001?\u0002f&\u0019\u0011q]?\u0003\u0013\u0005\u0013(/Y=ECR\f\u0007BBAR5\u0001\u00071\u000bC\u0004\u0002^j\u0001\r!a\u001b\u0002\u000bA\f'o]3\u0016\t\u0005E\u0018\u0011 \u000b\bE\u0006M(Q\u0001B\b\u0011\u001d\t)p\u0007a\u0001\u0003o\faA]3d_J$\u0007\u0003BA?\u0003s$q!a?\u001c\u0005\u0004\tiPA\u0001U#\u0011\ty0a#\u0011\u00071\u0012\t!C\u0002\u0003\u00045\u0012qAT8uQ&tw\rC\u0004\u0003\bm\u0001\rA!\u0003\u0002\u0019\r\u0014X-\u0019;f!\u0006\u00148/\u001a:\u0011\u000f1\u0012Y!^A|'&\u0019!QB\u0017\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004b\u0002B\t7\u0001\u0007!1C\u0001\u000ee\u0016\u001cwN\u001d3MSR,'/\u00197\u0011\r1\n\u0016q\u001fB\u000b!\u0011\u00119Ba\b\u000e\u0005\te!bA\u001e\u0003\u001c)\u0019!QD\u0012\u0002\rUt7/\u00194f\u0013\u0011\u0011\tC!\u0007\u0003\u0015U#f\tO*ue&tw\r")
public class JacksonParser
implements Logging {
    private TimestampFormatter org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter;
    private DateFormatter org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter;
    public final DataType org$apache$spark$sql$catalyst$json$JacksonParser$$schema;
    private final JSONOptions options;
    public final boolean org$apache$spark$sql$catalyst$json$JacksonParser$$allowArrayAsStructs;
    private final Function1<JsonParser, Iterable<InternalRow>> rootConverter;
    private final JsonFactory org$apache$spark$sql$catalyst$json$JacksonParser$$factory;
    private final Function1<String, BigDecimal> org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser;
    private final boolean org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public JSONOptions options() {
        return this.options;
    }

    private Function1<JsonParser, Iterable<InternalRow>> rootConverter() {
        return this.rootConverter;
    }

    public JsonFactory org$apache$spark$sql$catalyst$json$JacksonParser$$factory() {
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        JacksonParser jacksonParser = this;
        synchronized (jacksonParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampFormat(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter;
    }

    public TimestampFormatter org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.timestampFormatter$lzycompute() : this.org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        JacksonParser jacksonParser = this;
        synchronized (jacksonParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormat(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter;
    }

    public DateFormatter org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dateFormatter$lzycompute() : this.org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter;
    }

    private Function1<JsonParser, Iterable<InternalRow>> makeRootConverter(DataType dt) {
        Function1<JsonParser, Iterable<InternalRow>> function1;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            function1 = this.makeStructRootConverter(structType);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            function1 = this.makeMapRootConverter(mapType);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            function1 = this.makeArrayRootConverter(arrayType);
        } else {
            throw new MatchError((Object)dataType);
        }
        return function1;
    }

    private Function1<JsonParser, Iterable<InternalRow>> makeStructRootConverter(StructType st) {
        Function1<JsonParser, Object> elementConverter = this.makeConverter(st);
        Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        return (Function1 & Serializable & scala.Serializable)parser -> (Iterable)this.parseJsonToken((JsonParser)parser, st, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, st, fieldConverters, (Function1)elementConverter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$1;
            private final StructType st$1;
            private final Function1[] fieldConverters$1;
            private final Function1 elementConverter$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                Object var5_4 = null;
                A1 A1 = x1;
                if (JsonToken.START_OBJECT.equals(A1)) {
                    object = Option$.MODULE$.option2Iterable((Option)new Some((Object)this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$1, this.st$1, this.fieldConverters$1)));
                    return (B1)object;
                }
                if (JsonToken.START_ARRAY.equals(A1)) {
                    bl = true;
                    var5_4 = A1;
                    if (this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$allowArrayAsStructs) {
                        ArrayData array = this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$1, (Function1<JsonParser, Object>)this.elementConverter$1);
                        object = array.numElements() == 0 ? Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class))) : Predef$.MODULE$.wrapRefArray((Object[])array.toArray(this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$schema, ClassTag$.MODULE$.apply(InternalRow.class)));
                        return (B1)object;
                    }
                }
                if (bl) {
                    throw new RuntimeException("Parsing JSON arrays as structs is forbidden.");
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(JsonToken x1) {
                boolean bl = false;
                JsonToken jsonToken = null;
                JsonToken jsonToken2 = x1;
                if (JsonToken.START_OBJECT.equals(jsonToken2)) {
                    return true;
                }
                if (JsonToken.START_ARRAY.equals(jsonToken2)) {
                    bl = true;
                    jsonToken = jsonToken2;
                    if (this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$allowArrayAsStructs) {
                        return true;
                    }
                }
                if (!bl) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$1 = parser$1;
                this.st$1 = st$1;
                this.fieldConverters$1 = fieldConverters$1;
                this.elementConverter$1 = elementConverter$1;
            }
        });
    }

    private Function1<JsonParser, Iterable<InternalRow>> makeMapRootConverter(MapType mt) {
        Function1<JsonParser, Object> fieldConverter = this.makeConverter(mt.valueType());
        return (Function1 & Serializable & scala.Serializable)parser -> (Iterable)this.parseJsonToken((JsonParser)parser, mt, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)fieldConverter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$2;
            private final Function1 fieldConverter$1;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = JsonToken.START_OBJECT.equals(A1) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(this.parser$2, (Function1<JsonParser, Object>)this.fieldConverter$1)})))) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$2 = parser$2;
                this.fieldConverter$1 = fieldConverter$1;
            }
        });
    }

    private Function1<JsonParser, Iterable<InternalRow>> makeArrayRootConverter(ArrayType at) {
        Function1<JsonParser, Object> elemConverter = this.makeConverter(at.elementType());
        return (Function1 & Serializable & scala.Serializable)parser -> (Iterable)this.parseJsonToken((JsonParser)parser, at, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)elemConverter, at){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$3;
            private final Function1 elemConverter$1;
            private final ArrayType at$1;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (JsonToken.START_ARRAY.equals(A1)) {
                    object = Option$.MODULE$.option2Iterable((Option)new Some((Object)InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$3, (Function1<JsonParser, Object>)this.elemConverter$1)}))));
                } else if (JsonToken.START_OBJECT.equals(A1) && this.at$1.elementType() instanceof StructType) {
                    StructType st = (StructType)this.at$1.elementType();
                    Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> $this.$outer.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
                    object = Option$.MODULE$.option2Iterable((Option)new Some((Object)InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$3, st, fieldConverters)}))))}))));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.START_ARRAY.equals(jsonToken) ? true : JsonToken.START_OBJECT.equals(jsonToken) && this.at$1.elementType() instanceof StructType;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$3 = parser$3;
                this.elemConverter$1 = elemConverter$1;
                this.at$1 = at$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.types.StructField ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeArrayRootConverter$1$1 org.apache.spark.sql.types.DataType )}, serializedLambda);
            }
        });
    }

    public Function1<String, BigDecimal> org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser() {
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser;
    }

    public Function1<JsonParser, Object> makeConverter(DataType dataType2) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType3 = dataType2;
        if (BooleanType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Boolean)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = JsonToken.VALUE_TRUE.equals(A1) ? Predef$.MODULE$.boolean2Boolean(true) : (JsonToken.VALUE_FALSE.equals(A1) ? Predef$.MODULE$.boolean2Boolean(false) : function1.apply(x1));
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x1) {
                    JsonToken jsonToken = x1;
                    boolean bl = JsonToken.VALUE_TRUE.equals(jsonToken) ? true : JsonToken.VALUE_FALSE.equals(jsonToken);
                    return bl;
                }
            });
        } else if (ByteType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Byte)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$4;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.byte2Byte(this.parser$4.getByteValue()) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x2) {
                    JsonToken jsonToken = x2;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$4 = parser$4;
                }
            });
        } else if (ShortType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Short)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$5;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.short2Short(this.parser$5.getShortValue()) : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x3) {
                    JsonToken jsonToken = x3;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$5 = parser$5;
                }
            });
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$6;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.int2Integer(this.parser$6.getIntValue()) : function1.apply(x4);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x4) {
                    JsonToken jsonToken = x4;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$6 = parser$6;
                }
            });
        } else if (LongType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$7;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    A1 A1 = x5;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.long2Long(this.parser$7.getLongValue()) : function1.apply(x5);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x5) {
                    JsonToken jsonToken = x5;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$7 = parser$7;
                }
            });
        } else if (FloatType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Float)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$8;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x6;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Predef$.MODULE$.float2Float(this.parser$8.getFloatValue());
                    } else if (JsonToken.VALUE_STRING.equals(A1) && this.parser$8.getTextLength() >= 1) {
                        Float f;
                        String string = this.parser$8.getText();
                        if ("NaN".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.NaN);
                        } else if ("Infinity".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.POSITIVE_INFINITY);
                        } else if ("-Infinity".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.NEGATIVE_INFINITY);
                        } else {
                            throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(FloatType$.MODULE$.catalogString()).append(".").toString());
                        }
                        object = f;
                    } else {
                        object = function1.apply(x6);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x6) {
                    JsonToken jsonToken = x6;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$8.getTextLength() >= 1;
                    return bl2;
                }
                {
                    this.parser$8 = parser$8;
                }
            });
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Double)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$9;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x7;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Predef$.MODULE$.double2Double(this.parser$9.getDoubleValue());
                    } else if (JsonToken.VALUE_STRING.equals(A1) && this.parser$9.getTextLength() >= 1) {
                        Double d;
                        String string = this.parser$9.getText();
                        if ("NaN".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.NaN);
                        } else if ("Infinity".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.POSITIVE_INFINITY);
                        } else if ("-Infinity".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.NEGATIVE_INFINITY);
                        } else {
                            throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(DoubleType$.MODULE$.catalogString()).append(".").toString());
                        }
                        object = d;
                    } else {
                        object = function1.apply(x7);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x7) {
                    JsonToken jsonToken = x7;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$9.getTextLength() >= 1;
                    return bl2;
                }
                {
                    this.parser$9 = parser$9;
                }
            });
        } else if (StringType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (UTF8String)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$10;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                    UTF8String uTF8String;
                    A1 A1 = x8;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        uTF8String = UTF8String.fromString((String)this.parser$10.getText());
                    } else {
                        ByteArrayOutputStream writer = new ByteArrayOutputStream();
                        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$factory().createGenerator((OutputStream)writer, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> {
                            $anonfun$$nestedInanonfun$makeConverter$8$1.$anonfun$applyOrElse$4(this, generator);
                            return BoxedUnit.UNIT;
                        });
                        uTF8String = UTF8String.fromBytes((byte[])writer.toByteArray());
                    }
                    return (B1)uTF8String;
                }

                public final boolean isDefinedAt(JsonToken x8) {
                    JsonToken jsonToken = x8;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) ? true : true;
                    return bl;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$4($anonfun$$nestedInanonfun$makeConverter$8$1 $this, JsonGenerator generator) {
                    generator.copyCurrentStructure($this.parser$10);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$10 = parser$10;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$8$1 java.io.ByteArrayOutputStream ), $anonfun$applyOrElse$4$adapted(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$8$1 com.fasterxml.jackson.core.JsonGenerator )}, serializedLambda);
                }
            });
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$11;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x9;
                    if (JsonToken.VALUE_STRING.equals(A1) && this.parser$11.getTextLength() >= 1) {
                        Long l;
                        try {
                            l = Predef$.MODULE$.long2Long(this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter().parse(this.parser$11.getText()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            UTF8String str = UTF8String.fromString((String)DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(this.parser$11.getText()));
                            Long l2 = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(str, this.$outer.options().zoneId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                throw e;
                            })));
                            l = l2;
                        }
                        object = l;
                    } else {
                        object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.long2Long(this.parser$11.getLongValue() * 1000000L) : function1.apply(x9);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x9) {
                    JsonToken jsonToken = x9;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$11.getTextLength() >= 1 ? true : JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$11 = parser$11;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(java.lang.Throwable )}, serializedLambda);
                }
            });
        } else if (DateType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$12;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x10;
                    if (JsonToken.VALUE_STRING.equals(A1) && this.parser$12.getTextLength() >= 1) {
                        Integer n;
                        try {
                            n = Predef$.MODULE$.int2Integer(this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter().parse(this.parser$12.getText()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            UTF8String str = UTF8String.fromString((String)DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(this.parser$12.getText()));
                            Integer n2 = (Integer)DateTimeUtils$.MODULE$.stringToDate(str, this.$outer.options().zoneId()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                                int n;
                                try {
                                    n = RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(new StringOps(Predef$.MODULE$.augmentString($this.parser$12.getText())).toInt());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw e;
                                }
                                return n;
                            });
                            n = n2;
                        }
                        object = n;
                    } else {
                        object = function1.apply(x10);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x10) {
                    JsonToken jsonToken = x10;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$12.getTextLength() >= 1;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$12 = parser$12;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$10$1 java.lang.Throwable )}, serializedLambda);
                }
            });
        } else if (BinaryType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (byte[])this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$13;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                    A1 A1 = x11;
                    Object object = JsonToken.VALUE_STRING.equals(A1) ? this.parser$13.getBinaryValue() : (Object)function1.apply(x11);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x11) {
                    JsonToken jsonToken = x11;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$13 = parser$13;
                }
            });
        } else if (dataType3 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType3;
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Decimal)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, decimalType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$14;
                private final DecimalType x13$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x12;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Decimal$.MODULE$.apply(this.parser$14.getDecimalValue(), this.x13$1.precision(), this.x13$1.scale());
                    } else if (JsonToken.VALUE_STRING.equals(A1) && this.parser$14.getTextLength() >= 1) {
                        BigDecimal bigDecimal = (BigDecimal)this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser().apply((Object)this.parser$14.getText());
                        object = Decimal$.MODULE$.apply(bigDecimal, this.x13$1.precision(), this.x13$1.scale());
                    } else {
                        object = function1.apply(x12);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x12) {
                    JsonToken jsonToken = x12;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$14.getTextLength() >= 1;
                    return bl2;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$14 = parser$14;
                    this.x13$1 = x13$1;
                }
            });
        } else if (CalendarIntervalType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (CalendarInterval)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$15;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                    A1 A1 = x13;
                    Object object = JsonToken.VALUE_STRING.equals(A1) ? IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)this.parser$15.getText())) : function1.apply(x13);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x13) {
                    JsonToken jsonToken = x13;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$15 = parser$15;
                }
            });
        } else if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (InternalRow)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, structType, fieldConverters){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$16;
                private final StructType x15$1;
                private final Function1[] fieldConverters$2;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                    A1 A1 = x14;
                    Object object = JsonToken.START_OBJECT.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$16, this.x15$1, this.fieldConverters$2) : function1.apply(x14);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x14) {
                    JsonToken jsonToken = x14;
                    boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$16 = parser$16;
                    this.x15$1 = x15$1;
                    this.fieldConverters$2 = fieldConverters$2;
                }
            });
        } else if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            Function1<JsonParser, Object> elementConverter = this.makeConverter(arrayType.elementType());
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (ArrayData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)elementConverter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$17;
                private final Function1 elementConverter$2;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                    A1 A1 = x15;
                    Object object = JsonToken.START_ARRAY.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$17, (Function1<JsonParser, Object>)this.elementConverter$2) : function1.apply(x15);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x15) {
                    JsonToken jsonToken = x15;
                    boolean bl = JsonToken.START_ARRAY.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$17 = parser$17;
                    this.elementConverter$2 = elementConverter$2;
                }
            });
        } else if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            Function1<JsonParser, Object> valueConverter = this.makeConverter(mapType.valueType());
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (MapData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)valueConverter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$18;
                private final Function1 valueConverter$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                    A1 A1 = x16;
                    Object object = JsonToken.START_OBJECT.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(this.parser$18, (Function1<JsonParser, Object>)this.valueConverter$1) : function1.apply(x16);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x16) {
                    JsonToken jsonToken = x16;
                    boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$18 = parser$18;
                    this.valueConverter$1 = valueConverter$1;
                }
            });
        } else if (dataType3 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            intersect = this.makeConverter(userDefinedType.sqlType());
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)PartialFunction$.MODULE$.empty());
        }
        return intersect;
    }

    private <R> R parseJsonToken(JsonParser parser, DataType dataType, PartialFunction<JsonToken, R> f) {
        JsonToken jsonToken;
        while (JsonToken.FIELD_NAME.equals(jsonToken = parser.getCurrentToken())) {
            parser.nextToken();
        }
        boolean bl = jsonToken == null ? true : JsonToken.VALUE_NULL.equals(jsonToken);
        Object object = bl ? null : f.applyOrElse((Object)jsonToken, this.failedConversion(parser, dataType));
        return (R)object;
    }

    public boolean org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString() {
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString;
    }

    private <R> PartialFunction<JsonToken, R> failedConversion(JsonParser parser, DataType dataType) {
        return new scala.Serializable(this, parser, dataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$19;
            private final DataType dataType$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                Object var7_4 = null;
                A1 A1 = x1;
                if (JsonToken.VALUE_STRING.equals(A1)) {
                    bl = true;
                    var7_4 = A1;
                    if (this.parser$19.getTextLength() < 1 && this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString()) {
                        B1 B1;
                        DataType dataType = this.dataType$2;
                        boolean bl2 = FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType)));
                        if (bl2) {
                            throw new RuntimeException(new StringBuilder(46).append("Failed to parse an empty string for data type ").append(this.dataType$2.catalogString()).toString());
                        }
                        B1 B12 = B1 = null;
                        return B12;
                    }
                }
                if (!bl) throw new RuntimeException(new StringBuilder(57).append("Failed to parse a value for data type ").append(this.dataType$2.catalogString()).append(" (current token: ").append(A1).append(").").toString());
                if (this.parser$19.getTextLength() >= 1) throw new RuntimeException(new StringBuilder(57).append("Failed to parse a value for data type ").append(this.dataType$2.catalogString()).append(" (current token: ").append(A1).append(").").toString());
                throw new RuntimeException(new StringBuilder(46).append("Failed to parse an empty string for data type ").append(this.dataType$2.catalogString()).toString());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(JsonToken x1) {
                boolean bl = false;
                JsonToken jsonToken = null;
                JsonToken jsonToken2 = x1;
                if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
                    bl = true;
                    jsonToken = jsonToken2;
                    if (this.parser$19.getTextLength() < 1 && this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString()) {
                        return true;
                    }
                }
                if (!bl) return true;
                if (this.parser$19.getTextLength() >= 1) return true;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$19 = parser$19;
                this.dataType$2 = dataType$2;
            }
        };
    }

    public InternalRow org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(JsonParser parser, StructType schema, Function1<JsonParser, Object>[] fieldConverters) {
        GenericInternalRow row = new GenericInternalRow(schema.length());
        None$ badRecordException = None$.MODULE$;
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            JsonParser jsonParser;
            Option<Object> option = schema.getFieldIndex(parser.getCurrentName());
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                int index = BoxesRunTime.unboxToInt((Object)some.value());
                try {
                    row.update(index, fieldConverters[index].apply((Object)parser));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SparkUpgradeException) {
                        SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                        throw sparkUpgradeException;
                    }
                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option2.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option2.get();
                    badRecordException = badRecordException.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)e));
                    JsonParser jsonParser2 = parser.skipChildren();
                    boxedUnit = jsonParser2;
                }
                jsonParser = boxedUnit;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                jsonParser = parser.skipChildren();
                continue;
            }
            throw new MatchError(option);
        }
        if (!badRecordException.isEmpty()) {
            throw new PartialResultException(row, (Throwable)badRecordException.get());
        }
        return row;
    }

    public MapData org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            keys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return ArrayBasedMapData$.MODULE$.apply(keys.toArray(ClassTag$.MODULE$.apply(UTF8String.class)), values.toArray(ClassTag$.MODULE$.Any()));
    }

    public ArrayData org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return new GenericArrayData((Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    public <T> Iterable<InternalRow> parse(T record, Function2<JsonFactory, T, JsonParser> createParser, Function1<T, UTF8String> recordLiteral) {
        Iterable iterable;
        try {
            iterable = (Iterable)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory(), record), (Function1 & Serializable & scala.Serializable)parser -> {
                Iterable iterable;
                JsonToken jsonToken = parser.nextToken();
                if (jsonToken == null) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    Iterable iterable2;
                    Iterable iterable3 = (Iterable)this.rootConverter().apply(parser);
                    if (iterable3 == null) {
                        throw new RuntimeException("Root converter returned null");
                    }
                    iterable = iterable2 = iterable3;
                }
                return iterable;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkUpgradeException) {
                SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                throw sparkUpgradeException;
            }
            boolean bl = throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException);
            if (bl) {
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, throwable2);
            }
            if (throwable2 instanceof CharConversionException) {
                CharConversionException charConversionException = (CharConversionException)throwable2;
                if (this.options().encoding().isEmpty()) {
                    String msg = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n            |Specifying encoding as an input option explicitly might help to resolve the issue.\n            |")).stripMargin()).append(charConversionException.getMessage()).toString();
                    CharConversionException wrappedCharException = new CharConversionException(msg);
                    wrappedCharException.initCause(charConversionException);
                    throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, wrappedCharException);
                }
            }
            if (throwable2 instanceof PartialResultException) {
                PartialResultException partialResultException = (PartialResultException)throwable2;
                InternalRow row = partialResultException.partialResult();
                Throwable cause = partialResultException.cause();
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> new Some((Object)row), cause);
            }
            throw throwable;
        }
        return iterable;
    }

    public JacksonParser(DataType schema, JSONOptions options, boolean allowArrayAsStructs) {
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$schema = schema;
        this.options = options;
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$allowArrayAsStructs = allowArrayAsStructs;
        Logging.$init$((Logging)this);
        this.rootConverter = this.makeRootConverter(schema);
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory = options.buildJsonFactory();
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_ALLOW_EMPTY_STRING_IN_JSON()));
    }
}

