/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class ClassFieldMap {
    private static final boolean debugReflection = false;
    private final Logger log;
    private final Class clazz;
    private final Map fieldCache;

    public ClassFieldMap(Class clazz, Logger log) {
        this.clazz = clazz;
        this.log = log;
        this.fieldCache = this.createFieldCache();
    }

    public Class getCachedClass() {
        return this.clazz;
    }

    public Field findField(String name) {
        return (Field)this.fieldCache.get(name);
    }

    private Map createFieldCache() {
        ConcurrentHashMap fieldCache = new ConcurrentHashMap();
        for (Class classToReflect = this.getCachedClass(); classToReflect != null; classToReflect = classToReflect.getSuperclass()) {
            Class<?>[] interfaces;
            if (Modifier.isPublic(classToReflect.getModifiers())) {
                this.populateFieldCacheWith(fieldCache, classToReflect);
            }
            for (Class<?> anInterface : interfaces = classToReflect.getInterfaces()) {
                this.populateFieldCacheWithInterface(fieldCache, anInterface);
            }
        }
        return fieldCache;
    }

    private void populateFieldCacheWithInterface(Map fieldCache, Class iface) {
        Class<?>[] supers;
        if (Modifier.isPublic(iface.getModifiers())) {
            this.populateFieldCacheWith(fieldCache, iface);
        }
        for (Class<?> aSuper : supers = iface.getInterfaces()) {
            this.populateFieldCacheWithInterface(fieldCache, aSuper);
        }
    }

    private void populateFieldCacheWith(Map fieldCache, Class classToReflect) {
        try {
            Field[] fields;
            for (Field field : fields = classToReflect.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers)) continue;
                fieldCache.put(field.getName(), field);
            }
        }
        catch (SecurityException se) {
            this.log.debug("While accessing fields of {}:", (Object)classToReflect, (Object)se);
        }
    }
}

